/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnexe.command.add;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.log.ScmLogger;
import org.codehaus.plexus.util.cli.StreamConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnAddConsumer
implements StreamConsumer {
    private ScmLogger logger;
    private List<ScmFile> addedFiles = new ArrayList<ScmFile>();

    public SvnAddConsumer(ScmLogger logger) {
        this.logger = logger;
    }

    public void consumeLine(String line) {
        if (line.length() <= 3) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Unexpected input, the line must be at least three characters long. Line: '" + line + "'.");
            }
            return;
        }
        String statusString = line.substring(0, 1);
        String file = line.substring(3);
        if (!statusString.equals("A")) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Unknown file status: '" + statusString + "'.");
            }
            return;
        }
        ScmFileStatus status = ScmFileStatus.ADDED;
        this.addedFiles.add(new ScmFile(file, status));
    }

    public List<ScmFile> getAddedFiles() {
        return this.addedFiles;
    }
}

