/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnexe.command.checkin;

import java.io.File;
import java.util.List;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.svn.svnexe.command.AbstractFileCheckingConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnCheckInConsumer
extends AbstractFileCheckingConsumer {
    private static final String SENDING_TOKEN = "Sending        ";
    private static final String ADDING_TOKEN = "Adding         ";
    private static final String ADDING_BIN_TOKEN = "Adding  (bin)  ";
    private static final String DELETING_TOKEN = "Deleting       ";
    private static final String TRANSMITTING_TOKEN = "Transmitting file data";
    private static final String COMMITTED_REVISION_TOKEN = "Committed revision";

    public SvnCheckInConsumer(ScmLogger logger, File workingDirectory) {
        super(logger, workingDirectory);
    }

    @Override
    protected void parseLine(String line) {
        String file;
        if (line.startsWith(COMMITTED_REVISION_TOKEN)) {
            String revisionString = line.substring(COMMITTED_REVISION_TOKEN.length() + 1, line.length() - 1);
            this.revision = this.parseInt(revisionString);
            return;
        }
        if (line.startsWith(SENDING_TOKEN)) {
            file = line.substring(SENDING_TOKEN.length());
        } else if (line.startsWith(ADDING_TOKEN)) {
            file = line.substring(ADDING_TOKEN.length());
        } else if (line.startsWith(ADDING_BIN_TOKEN)) {
            file = line.substring(ADDING_BIN_TOKEN.length());
        } else if (line.startsWith(DELETING_TOKEN)) {
            file = line.substring(DELETING_TOKEN.length());
        } else {
            if (line.startsWith(TRANSMITTING_TOKEN)) {
                return;
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Unknown line: '" + line + "'");
            }
            return;
        }
        this.addFile(new ScmFile(file, ScmFileStatus.CHECKED_IN));
    }

    public List<ScmFile> getCheckedInFiles() {
        return this.getFiles();
    }
}

