/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.jgit.command;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.git.repository.GitScmProviderRepository;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.StringUtils;

public class JGitTransportConfigCallback
implements TransportConfigCallback {
    private SshSessionFactory sshSessionFactory = null;

    public JGitTransportConfigCallback(GitScmProviderRepository repo, ScmLogger logger) {
        if (repo.getFetchInfo().getProtocol().equals("ssh")) {
            if (!StringUtils.isEmptyOrNull((String)repo.getPrivateKey()) && repo.getPassphrase() == null) {
                logger.debug("using private key: " + repo.getPrivateKey());
                this.sshSessionFactory = new UnprotectedPrivateKeySessionFactory(repo);
            } else if (!StringUtils.isEmptyOrNull((String)repo.getPrivateKey()) && repo.getPassphrase() != null) {
                logger.debug("using private key with passphrase: " + repo.getPrivateKey());
                this.sshSessionFactory = new ProtectedPrivateKeyFileSessionFactory(repo);
            } else {
                this.sshSessionFactory = new SimpleSessionFactory();
            }
        }
    }

    public void configure(Transport transport) {
        if (transport instanceof SshTransport) {
            SshTransport sshTransport = (SshTransport)transport;
            sshTransport.setSshSessionFactory(this.sshSessionFactory);
        }
    }

    private static class ProtectedPrivateKeyFileSessionFactory
    extends PrivateKeySessionFactory {
        ProtectedPrivateKeyFileSessionFactory(GitScmProviderRepository repo) {
            super(repo);
        }

        protected JSch createDefaultJSch(FS fs) throws JSchException {
            JSch defaultJSch = super.createDefaultJSch(fs);
            defaultJSch.addIdentity(this.getRepo().getPrivateKey(), this.getRepo().getPassphrase());
            return defaultJSch;
        }
    }

    private static class UnprotectedPrivateKeySessionFactory
    extends PrivateKeySessionFactory {
        UnprotectedPrivateKeySessionFactory(GitScmProviderRepository repo) {
            super(repo);
        }

        protected JSch createDefaultJSch(FS fs) throws JSchException {
            JSch defaultJSch = super.createDefaultJSch(fs);
            defaultJSch.addIdentity(this.getRepo().getPrivateKey());
            return defaultJSch;
        }
    }

    private static abstract class PrivateKeySessionFactory
    extends SimpleSessionFactory {
        private final GitScmProviderRepository repo;

        GitScmProviderRepository getRepo() {
            return this.repo;
        }

        PrivateKeySessionFactory(GitScmProviderRepository repo) {
            this.repo = repo;
        }
    }

    private static class SimpleSessionFactory
    extends JschConfigSessionFactory {
        private SimpleSessionFactory() {
        }

        protected void configure(OpenSshConfig.Host host, Session session) {
        }
    }
}

