/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.jazz.command.checkout;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.jazz.command.consumer.AbstractRepositoryConsumer;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JazzCheckOutConsumer
extends AbstractRepositoryConsumer {
    private static final String DOWNLOAD_PATTERN = "^Downloading\\s(.*)\\s\\s\\(\\d.*B\\)$";
    private RE downloadRegexp;
    protected String fCurrentDir = "";
    private List<ScmFile> fCheckedOutFiles = new ArrayList<ScmFile>();

    public JazzCheckOutConsumer(ScmProviderRepository repository, ScmLogger logger) {
        super(repository, logger);
        try {
            this.downloadRegexp = new RE(DOWNLOAD_PATTERN);
        }
        catch (RESyntaxException ex) {
            throw new RuntimeException("INTERNAL ERROR: Could not create regexp to parse jazz scm checkout output. This shouldn't happen. Something is probably wrong with the oro installation.", ex);
        }
    }

    @Override
    public void consumeLine(String line) {
        if (this.downloadRegexp.match(line)) {
            this.fCheckedOutFiles.add(new ScmFile(this.downloadRegexp.getParen(1), ScmFileStatus.CHECKED_OUT));
        }
    }

    public List<ScmFile> getCheckedOutFiles() {
        return this.fCheckedOutFiles;
    }
}

