/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.repository;

import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.ScmProviderRepositoryWithHost;

public class GitScmProviderRepository
extends ScmProviderRepositoryWithHost {
    private String url;
    private String protocol;
    public static final String PROTOCOL_FILE = "file";
    public static final String PROTOCOL_GIT = "git";
    public static final String PROTOCOL_SSH = "ssh";
    public static final String PROTOCOL_HTTP = "http";
    public static final String PROTOCOL_HTTPS = "https";
    public static final String PROTOCOL_RSYNC = "rsync";

    public GitScmProviderRepository(String url) {
        this.parseUrl(url);
    }

    public GitScmProviderRepository(String url, String user, String password) {
        this(url);
        this.setUser(user);
        this.setPassword(password);
    }

    public String getUrl() {
        return this.url;
    }

    private void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    private void parseUrl(String url) {
        int indexAt;
        if (url.startsWith(PROTOCOL_FILE)) {
            this.setProtocol(PROTOCOL_FILE);
        } else if (url.startsWith(PROTOCOL_HTTPS)) {
            this.setProtocol(PROTOCOL_HTTPS);
        } else if (url.startsWith(PROTOCOL_HTTP)) {
            this.setProtocol(PROTOCOL_HTTP);
        } else if (url.startsWith(PROTOCOL_SSH)) {
            this.setProtocol(PROTOCOL_SSH);
        } else if (url.startsWith(PROTOCOL_GIT)) {
            this.setProtocol(PROTOCOL_GIT);
        } else if (url.startsWith(PROTOCOL_RSYNC)) {
            this.setProtocol(PROTOCOL_RSYNC);
        }
        if (this.getProtocol() == null) {
            return;
        }
        String urlPath = url.substring(this.getProtocol().length());
        if (urlPath.startsWith("://")) {
            urlPath = urlPath.substring(3);
        }
        if ((indexAt = urlPath.indexOf("@")) > 0) {
            String userPassword = urlPath.substring(0, indexAt);
            if (userPassword.indexOf(":") < 0) {
                this.setUser(userPassword);
            } else {
                this.setUser(userPassword.substring(0, userPassword.indexOf(":")));
                this.setPassword(userPassword.substring(userPassword.indexOf(":") + 1));
            }
            urlPath = urlPath.substring(indexAt + 1);
            if (PROTOCOL_SSH.equals(this.getProtocol())) {
                StringBuffer urlSb = new StringBuffer(this.getProtocol());
                urlSb.append("://");
                if (this.getUser() != null) {
                    urlSb.append(this.getUser());
                    if (this.getPassword() != null) {
                        urlSb.append(':').append(this.getPassword());
                    }
                    urlSb.append('@');
                }
                urlSb.append(urlPath);
                this.url = urlSb.toString();
            } else {
                this.url = this.getProtocol() + "://" + urlPath;
            }
        } else {
            this.url = this.getProtocol() + "://" + urlPath;
        }
        if (!PROTOCOL_FILE.equals(this.getProtocol())) {
            int indexColon;
            int indexSlash = urlPath.indexOf("/");
            String hostPort = urlPath;
            if (indexSlash > 0) {
                hostPort = urlPath.substring(0, indexSlash);
            }
            if ((indexColon = hostPort.indexOf(":")) > 0) {
                boolean sshGitDev = false;
                if (hostPort.startsWith("@")) {
                    this.setHost(hostPort.substring(1, indexColon));
                } else {
                    this.setHost(hostPort.substring(0, indexColon));
                }
                String port = hostPort.substring(indexColon + 1);
                if (port.indexOf(":") > 0) {
                    port = port.substring(0, port.indexOf(":"));
                    sshGitDev = true;
                }
                try {
                    this.setPort(Integer.parseInt(port));
                }
                catch (NumberFormatException e) {
                    if (!PROTOCOL_GIT.equals(this.getProtocol())) {
                        throw e;
                    }
                    sshGitDev = true;
                }
                if (sshGitDev) {
                    this.url = PROTOCOL_GIT + urlPath;
                }
            } else {
                this.setHost(hostPort);
            }
        }
    }

    public ScmProviderRepository getParent() {
        String newUrl = this.getUrl().substring(this.getProtocol().length());
        while (newUrl.endsWith("/.")) {
            newUrl = newUrl.substring(0, newUrl.length() - 1);
        }
        while (newUrl.endsWith("/")) {
            newUrl = newUrl.substring(0, newUrl.length());
        }
        int i = newUrl.lastIndexOf("/");
        if (i < 0) {
            return null;
        }
        newUrl = newUrl.substring(0, i);
        return new GitScmProviderRepository(this.getProtocol() + newUrl, this.getUser(), this.getPassword());
    }

    public String getRelativePath(ScmProviderRepository ancestor) {
        if (ancestor instanceof GitScmProviderRepository) {
            GitScmProviderRepository gitAncestor = (GitScmProviderRepository)ancestor;
            String path = this.getUrl().replaceFirst(gitAncestor.getUrl() + "/", "");
            if (!path.equals(this.getUrl())) {
                return path;
            }
        }
        return null;
    }

    public String toString() {
        return this.getUrl();
    }
}

