/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.cvslib.cvsjava.command.checkin;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.provider.cvslib.command.checkin.AbstractCvsCheckInCommand;
import org.apache.maven.scm.provider.cvslib.command.checkin.CvsCheckInConsumer;
import org.apache.maven.scm.provider.cvslib.cvsjava.util.CvsConnection;
import org.apache.maven.scm.provider.cvslib.cvsjava.util.CvsLogListener;
import org.apache.maven.scm.provider.cvslib.repository.CvsScmProviderRepository;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.netbeans.lib.cvsclient.event.CVSListener;

public class CvsJavaCheckInCommand
extends AbstractCvsCheckInCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CheckInScmResult executeCvsCommand(Commandline cl, CvsScmProviderRepository repository, File messageFile) throws ScmException {
        CvsLogListener logListener = new CvsLogListener();
        CvsCheckInConsumer consumer = new CvsCheckInConsumer(repository.getPath(), this.getLogger());
        try {
            String line;
            boolean isSuccess = CvsConnection.processCommand(cl.getArguments(), cl.getWorkingDirectory().getAbsolutePath(), (CVSListener)logListener, this.getLogger());
            if (!isSuccess) {
                CheckInScmResult checkInScmResult = new CheckInScmResult(cl.toString(), "The cvs command failed.", logListener.getStderr().toString(), false);
                return checkInScmResult;
            }
            BufferedReader stream = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(logListener.getStdout().toString().getBytes())));
            while ((line = stream.readLine()) != null) {
                consumer.consumeLine(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            CheckInScmResult checkInScmResult = new CheckInScmResult(cl.toString(), "The cvs command failed.", logListener.getStdout().toString(), false);
            return checkInScmResult;
        }
        finally {
            try {
                FileUtils.forceDelete((File)messageFile);
            }
            catch (IOException iOException) {}
        }
        return new CheckInScmResult(cl.toString(), consumer.getCheckedInFiles());
    }
}

