/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.bazaar.command.update;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.changelog.ChangeLogCommand;
import org.apache.maven.scm.command.update.AbstractUpdateCommand;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.command.update.UpdateScmResultWithRevision;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.bazaar.BazaarUtils;
import org.apache.maven.scm.provider.bazaar.command.BazaarCommand;
import org.apache.maven.scm.provider.bazaar.command.BazaarConsumer;
import org.apache.maven.scm.provider.bazaar.command.changelog.BazaarChangeLogCommand;
import org.apache.maven.scm.provider.bazaar.command.diff.BazaarDiffConsumer;
import org.codehaus.plexus.util.StringUtils;

public class BazaarUpdateCommand
extends AbstractUpdateCommand
implements BazaarCommand {
    protected UpdateScmResult executeUpdateCommand(ScmProviderRepository repo, ScmFileSet fileSet, ScmVersion version) throws ScmException {
        if (version != null && StringUtils.isNotEmpty((String)version.getName())) {
            throw new ScmException("This provider can't handle tags.");
        }
        File workingDir = fileSet.getBasedir();
        String[] update_cmd = new String[]{"pull"};
        ScmResult updateResult = BazaarUtils.execute(new BazaarConsumer(this.getLogger()), this.getLogger(), workingDir, update_cmd);
        if (!updateResult.isSuccess()) {
            return new UpdateScmResult(null, null, updateResult);
        }
        int currentRevision = BazaarUtils.getCurrentRevisionNumber(this.getLogger(), workingDir);
        int previousRevision = currentRevision - 1;
        String[] diffCmd = new String[]{"diff", "--revision", "" + previousRevision};
        BazaarDiffConsumer diffConsumer = new BazaarDiffConsumer(this.getLogger(), workingDir);
        ScmResult diffResult = BazaarUtils.execute(diffConsumer, this.getLogger(), workingDir, diffCmd);
        ArrayList<ScmFile> updatedFiles = new ArrayList<ScmFile>();
        ArrayList changes = new ArrayList();
        List diffFiles = diffConsumer.getChangedFiles();
        Map diffChanges = diffConsumer.getDifferences();
        Iterator it = diffFiles.iterator();
        while (it.hasNext()) {
            ScmFile file = (ScmFile)it.next();
            changes.add(diffChanges.get(file));
            if (file.getStatus() == ScmFileStatus.MODIFIED) {
                updatedFiles.add(new ScmFile(file.getPath(), ScmFileStatus.PATCHED));
                continue;
            }
            updatedFiles.add(file);
        }
        return new UpdateScmResultWithRevision(updatedFiles, changes, String.valueOf(currentRevision), diffResult);
    }

    protected ChangeLogCommand getChangeLogCommand() {
        BazaarChangeLogCommand command = new BazaarChangeLogCommand();
        command.setLogger(this.getLogger());
        return command;
    }
}

