/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.war.packaging;

import java.io.File;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.war.packaging.AbstractWarPackagingTask;
import org.apache.maven.plugin.war.packaging.WarPackagingContext;
import org.apache.maven.plugin.war.util.WebappStructure;

public class DependenciesAnalysisPackagingTask
extends AbstractWarPackagingTask {
    public void performPackaging(WarPackagingContext context) throws MojoExecutionException, MojoFailureException {
        context.getWebappStructure().analyseDependencies(new DependenciesAnalysisCallbackImpl(context));
    }

    protected void handleDependency(WarPackagingContext context, Dependency dependency, String notBundledMessage, String warOrZipMessage, String standardMessage, boolean removeFile) {
        if ("provided".equals(dependency.getScope()) || "test".equals(dependency.getScope()) || dependency.isOptional()) {
            context.getLog().debug((CharSequence)notBundledMessage);
        } else {
            this.handleDependencyScope(context, dependency, warOrZipMessage, standardMessage, removeFile);
        }
    }

    protected void handleDependencyScope(WarPackagingContext context, Dependency dependency, String warOrZipMessage, String standardMessage, boolean removeFile) {
        if ("war".equals(dependency.getType()) || "zip".equals(dependency.getType())) {
            context.getLog().warn((CharSequence)warOrZipMessage);
        } else if ("tld".equals(dependency.getType()) || "aar".equals(dependency.getType()) || "mar".equals(dependency.getType()) || "xar".equals(dependency.getType()) || "jar".equals(dependency.getType()) || "ejb".equals(dependency.getType()) || "ejb-client".equals(dependency.getType()) || "test-jar".equals(dependency.getType()) || "par".equals(dependency.getType())) {
            context.getLog().info((CharSequence)standardMessage);
            if (removeFile) {
                this.removeDependency(context, dependency);
            }
        }
    }

    private void removeDependency(WarPackagingContext context, Dependency dependency) {
        String targetFileName = context.getWebappStructure().getCachedTargetFileName(dependency);
        if (targetFileName != null) {
            String type = dependency.getType();
            File targetFile = null;
            if ("tld".equals(type)) {
                targetFile = new File(context.getWebappDirectory(), "WEB-INF/tld/" + targetFileName);
            } else if ("aar".equals(type)) {
                targetFile = new File(context.getWebappDirectory(), "WEB-INF/services/" + targetFileName);
            } else if ("mar".equals(type)) {
                targetFile = new File(context.getWebappDirectory(), "WEB-INF/modules/" + targetFileName);
            } else if ("xar".equals(type)) {
                targetFile = new File(context.getWebappDirectory(), "WEB-INF/extensions/" + targetFileName);
            } else if ("jar".equals(type) || "ejb".equals(type) || "ejb-client".equals(type) || "test-jar".equals(type)) {
                targetFile = new File(context.getWebappDirectory(), "WEB-INF/lib/" + targetFileName);
            } else if ("par".equals(type)) {
                String targetFileName2 = targetFileName.substring(0, targetFileName.lastIndexOf(46)) + ".jar";
                targetFile = new File(context.getWebappDirectory(), "WEB-INF/lib/" + targetFileName2);
            }
            if (targetFile == null) {
                context.getLog().error((CharSequence)("Could not get file from dependency [" + dependency + "]"));
            } else if (targetFile.exists()) {
                context.getLog().debug((CharSequence)("Removing file [" + targetFile.getAbsolutePath() + "]"));
                targetFile.delete();
            } else {
                context.getLog().warn((CharSequence)("File to remove [" + targetFile.getAbsolutePath() + "] has not been found"));
            }
        } else {
            context.getLog().warn((CharSequence)("Could not retrieve the target file name of dependency [" + dependency + "]"));
        }
    }

    class DependenciesAnalysisCallbackImpl
    implements WebappStructure.DependenciesAnalysisCallback {
        private final WarPackagingContext context;

        DependenciesAnalysisCallbackImpl(WarPackagingContext context) {
            this.context = context;
        }

        public void unchangedDependency(Dependency dependency) {
            this.context.getLog().debug((CharSequence)("Dependency [" + dependency + "] has not changed since last build."));
        }

        public void newDependency(Dependency dependency) {
            this.context.getLog().debug((CharSequence)("New dependency [" + dependency + "]."));
        }

        public void removedDependency(Dependency dependency) {
            DependenciesAnalysisPackagingTask.this.handleDependency(this.context, dependency, "Dependency [" + dependency + "] has been removed from the project but it was not bundled anyway.", "Dependency [" + dependency + "] has been removed from the project. If it was included in the build as an overlay, " + "consider cleaning the target directory of the project (mvn clean)", "Dependency [" + dependency + "] has been removed from the project.", true);
        }

        public void updatedVersion(Dependency dependency, String previousVersion) {
            DependenciesAnalysisPackagingTask.this.handleDependency(this.context, dependency, "Version of dependency [" + dependency + "] has changed (" + previousVersion + " -> " + dependency.getVersion() + ") but it was not bundled anyway.", "Version of dependency [" + dependency + "] has changed (" + previousVersion + " -> " + dependency.getVersion() + "). If it was included in the build as an overlay, " + "consider " + "cleaning the target directory of the project (mvn clean)", "Version of dependency [" + dependency + "] has changed (" + previousVersion + " -> " + dependency.getVersion() + ").", true);
        }

        public void updatedScope(Dependency dependency, String previousScope) {
            if ("provided".equals(dependency.getScope()) || "test".equals(dependency.getScope()) && !"provided".equals(previousScope) && !"test".equals(previousScope)) {
                DependenciesAnalysisPackagingTask.this.handleDependencyScope(this.context, dependency, "Scope of dependency [" + dependency + "] has changed (" + previousScope + " -> " + dependency.getScope() + "). If it was included in the build as an overlay, " + "consider cleaning the target directory of the project (mvn clean)", "Scope of dependency [" + dependency + "] has changed (" + previousScope + " -> " + dependency.getScope() + ").", true);
            }
        }

        public void updatedOptionalFlag(Dependency dependency, boolean previousOptional) {
            if (!previousOptional && dependency.isOptional()) {
                DependenciesAnalysisPackagingTask.this.handleDependency(this.context, dependency, "Dependency [" + dependency + "] is now optional but it was not bundled anyway.", "Dependency [" + dependency + "] is now optional. If it was included in the build as an overlay, " + "consider cleaning the target directory of the project (mvn clean)", "Dependency [" + dependency + "] is now optional", true);
            }
        }

        public void updatedUnknown(Dependency dependency, Dependency previousDep) {
            DependenciesAnalysisPackagingTask.this.handleDependency(this.context, dependency, "Dependency [" + dependency + "] has changed (was " + previousDep + ") but it was not bundled anyway.", "Dependency [" + dependency + "] has changed (was " + previousDep + "). If it was included in the build as an overlay, " + "consider " + "cleaning the target directory of the project (mvn clean)", "Dependency [" + dependency + "] has changed (was " + previousDep + ").", true);
        }
    }
}

