/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.relocation;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.codehaus.plexus.util.SelectorUtils;

public class SimpleRelocator
implements Relocator {
    private static final Pattern RX_ENDS_WITH_DOT_SLASH_SPACE = Pattern.compile("[./ ]$");
    private static final Pattern RX_ENDS_WITH_JAVA_KEYWORD = Pattern.compile("\\b(import|package|public|protected|private|static|final|synchronized|abstract|volatile) $|\\{@link( \\*)* $");
    private final String pattern;
    private final String pathPattern;
    private final String shadedPattern;
    private final String shadedPathPattern;
    private final Set<String> includes;
    private final Set<String> excludes;
    private final Set<String> sourcePackageExcludes = new LinkedHashSet<String>();
    private final Set<String> sourcePathExcludes = new LinkedHashSet<String>();
    private final boolean rawString;

    public SimpleRelocator(String patt, String shadedPattern, List<String> includes, List<String> excludes) {
        this(patt, shadedPattern, includes, excludes, false);
    }

    public SimpleRelocator(String patt, String shadedPattern, List<String> includes, List<String> excludes, boolean rawString) {
        this.rawString = rawString;
        if (rawString) {
            this.pathPattern = patt;
            this.shadedPathPattern = shadedPattern;
            this.pattern = null;
            this.shadedPattern = null;
        } else {
            if (patt == null) {
                this.pattern = "";
                this.pathPattern = "";
            } else {
                this.pattern = patt.replace('/', '.');
                this.pathPattern = patt.replace('.', '/');
            }
            if (shadedPattern != null) {
                this.shadedPattern = shadedPattern.replace('/', '.');
                this.shadedPathPattern = shadedPattern.replace('.', '/');
            } else {
                this.shadedPattern = "hidden." + this.pattern;
                this.shadedPathPattern = "hidden/" + this.pathPattern;
            }
        }
        this.includes = SimpleRelocator.normalizePatterns(includes);
        this.excludes = SimpleRelocator.normalizePatterns(excludes);
        if (includes != null && !includes.isEmpty()) {
            this.includes.addAll(includes);
        }
        if (excludes != null && !excludes.isEmpty()) {
            this.excludes.addAll(excludes);
        }
        if (!rawString && this.excludes != null) {
            for (String exclude : this.excludes) {
                if (exclude.startsWith(this.pattern)) {
                    this.sourcePackageExcludes.add(exclude.substring(this.pattern.length()).replaceFirst("[.][*]$", ""));
                }
                if (!exclude.startsWith(this.pathPattern)) continue;
                this.sourcePathExcludes.add(exclude.substring(this.pathPattern.length()).replaceFirst("[/][*]$", ""));
            }
        }
    }

    private static Set<String> normalizePatterns(Collection<String> patterns) {
        LinkedHashSet<String> normalized = null;
        if (patterns != null && !patterns.isEmpty()) {
            normalized = new LinkedHashSet<String>();
            for (String pattern : patterns) {
                String classPattern = pattern.replace('.', '/');
                normalized.add(classPattern);
                if (!classPattern.endsWith("/*") && !classPattern.endsWith("/**")) continue;
                String packagePattern = classPattern.substring(0, classPattern.lastIndexOf(47));
                normalized.add(packagePattern);
            }
        }
        return normalized;
    }

    private boolean isIncluded(String path) {
        if (this.includes != null && !this.includes.isEmpty()) {
            for (String include : this.includes) {
                if (!SelectorUtils.matchPath((String)include, (String)path, (boolean)true)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean isExcluded(String path) {
        if (this.excludes != null && !this.excludes.isEmpty()) {
            for (String exclude : this.excludes) {
                if (!SelectorUtils.matchPath((String)exclude, (String)path, (boolean)true)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canRelocatePath(String path) {
        if (this.rawString) {
            return Pattern.compile(this.pathPattern).matcher(path).find();
        }
        if (path.endsWith(".class")) {
            path = path.substring(0, path.length() - 6);
        }
        if (!path.isEmpty() && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        return this.isIncluded(path) && !this.isExcluded(path) && path.startsWith(this.pathPattern);
    }

    @Override
    public boolean canRelocateClass(String clazz) {
        return !this.rawString && clazz.indexOf(47) < 0 && this.canRelocatePath(clazz.replace('.', '/'));
    }

    @Override
    public String relocatePath(String path) {
        if (this.rawString) {
            return path.replaceAll(this.pathPattern, this.shadedPathPattern);
        }
        return path.replaceFirst(this.pathPattern, this.shadedPathPattern);
    }

    @Override
    public String relocateClass(String clazz) {
        return this.rawString ? clazz : clazz.replaceFirst(this.pattern, this.shadedPattern);
    }

    @Override
    public String applyToSourceContent(String sourceContent) {
        if (this.rawString) {
            return sourceContent;
        }
        sourceContent = this.shadeSourceWithExcludes(sourceContent, this.pattern, this.shadedPattern, this.sourcePackageExcludes);
        return this.shadeSourceWithExcludes(sourceContent, this.pathPattern, this.shadedPathPattern, this.sourcePathExcludes);
    }

    private String shadeSourceWithExcludes(String sourceContent, String patternFrom, String patternTo, Set<String> excludedPatterns) {
        StringBuilder shadedSourceContent = new StringBuilder(sourceContent.length() * 11 / 10);
        boolean isFirstSnippet = true;
        String[] snippets = sourceContent.split("\\b" + patternFrom.replace(".", "[.]") + "\\b");
        int snippetsLength = snippets.length;
        for (int i = 0; i < snippetsLength; ++i) {
            String snippet = snippets[i];
            String previousSnippet = isFirstSnippet ? "" : snippets[i - 1];
            boolean doExclude = false;
            for (String excludedPattern : excludedPatterns) {
                if (!snippet.startsWith(excludedPattern)) continue;
                doExclude = true;
                break;
            }
            if (isFirstSnippet) {
                shadedSourceContent.append(snippet);
                isFirstSnippet = false;
                continue;
            }
            String previousSnippetOneLine = previousSnippet.replaceAll("\\s+", " ");
            boolean afterDotSlashSpace = RX_ENDS_WITH_DOT_SLASH_SPACE.matcher(previousSnippetOneLine).find();
            boolean afterJavaKeyWord = RX_ENDS_WITH_JAVA_KEYWORD.matcher(previousSnippetOneLine).find();
            boolean shouldExclude = doExclude || afterDotSlashSpace && !afterJavaKeyWord;
            shadedSourceContent.append(shouldExclude ? patternFrom : patternTo).append(snippet);
        }
        return shadedSourceContent.toString();
    }
}

