/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.pmd;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.pmd.AbstractPmdViolationCheckMojo;
import org.apache.maven.plugin.pmd.ExcludeDuplicationsFromFile;
import org.apache.maven.plugin.pmd.ViolationDetails;
import org.apache.maven.plugin.pmd.model.CpdErrorDetail;
import org.apache.maven.plugin.pmd.model.CpdFile;
import org.apache.maven.plugin.pmd.model.Duplication;
import org.apache.maven.plugin.pmd.model.io.xpp3.CpdXpp3Reader;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Mojo(name="cpd-check", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
@Execute(goal="cpd")
public class CpdViolationCheckMojo
extends AbstractPmdViolationCheckMojo<Duplication> {
    @Parameter(property="cpd.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="cpd.failOnViolation", defaultValue="true", required=true)
    protected boolean failOnViolation;

    public CpdViolationCheckMojo() {
        super(new ExcludeDuplicationsFromFile());
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skip) {
            this.executeCheck("cpd.xml", "duplication", "CPD duplication", 10);
        }
    }

    @Override
    protected void printError(Duplication item, String severity) {
        int lines = item.getLines();
        StringBuilder buff = new StringBuilder(100);
        buff.append("CPD ").append(severity).append(": Found ");
        buff.append(lines).append(" lines of duplicated code at locations:");
        this.getLog().info((CharSequence)buff.toString());
        for (CpdFile file : item.getFiles()) {
            buff.setLength(0);
            buff.append("    ");
            buff.append(file.getPath());
            buff.append(" line ").append(file.getLine());
            this.getLog().info((CharSequence)buff.toString());
        }
        this.getLog().debug((CharSequence)("CPD " + severity + ": Code Fragment "));
        this.getLog().debug((CharSequence)item.getCodefragment());
    }

    @Override
    protected List<Duplication> getErrorDetails(File cpdFile) throws XmlPullParserException, IOException {
        CpdXpp3Reader reader = new CpdXpp3Reader();
        CpdErrorDetail details = reader.read(new FileReader(cpdFile), false);
        return details.getDuplications();
    }

    @Override
    protected int getPriority(Duplication errorDetail) {
        return 0;
    }

    @Override
    protected ViolationDetails<Duplication> newViolationDetailsInstance() {
        return new ViolationDetails<Duplication>();
    }

    @Override
    public boolean isFailOnViolation() {
        return this.failOnViolation;
    }
}

