/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.linkcheck;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.SystemUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Reporting;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationOutputHandler;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.maven.shared.invoker.PrintStreamHandler;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.xml.XmlStreamWriter;

public class SiteInvoker {
    private final ArtifactRepository localRepository;
    private final Log log;

    public SiteInvoker(ArtifactRepository localRepository, Log log) {
        this.localRepository = localRepository;
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeSite(MavenProject project, File tmpReportingOutputDirectory) throws IOException {
        MavenProject clone;
        String mavenHome = this.getMavenHome();
        if (StringUtils.isEmpty((String)mavenHome)) {
            this.getLog().error((CharSequence)"Could NOT invoke Maven because no Maven Home is defined. You need to set the M2_HOME system env variable or a 'maven.home' Java system property.");
            return;
        }
        List<String> goals = Collections.singletonList("site");
        Properties properties = new Properties();
        properties.put("linkcheck.skip", "true");
        File invokerLog = FileUtils.createTempFile((String)"invoker-site-plugin", (String)".txt", (File)new File(project.getBuild().getDirectory()));
        try {
            clone = (MavenProject)project.clone();
        }
        catch (CloneNotSupportedException e) {
            IOException ioe = new IOException("CloneNotSupportedException: " + e.getMessage());
            ioe.setStackTrace(e.getStackTrace());
            throw ioe;
        }
        if (clone.getOriginalModel().getReporting() == null) {
            clone.getOriginalModel().setReporting(new Reporting());
        }
        clone.getOriginalModel().getReporting().setOutputDirectory(tmpReportingOutputDirectory.getAbsolutePath());
        List profileIds = SiteInvoker.getActiveProfileIds(clone);
        File tmpProjectFile = FileUtils.createTempFile((String)"pom", (String)".xml", (File)project.getBasedir());
        XmlStreamWriter writer = null;
        try {
            writer = WriterFactory.newXmlWriter((File)tmpProjectFile);
            clone.writeOriginalModel((Writer)writer);
        }
        finally {
            IOUtil.close((Writer)writer);
        }
        try {
            this.invoke(tmpProjectFile, invokerLog, mavenHome, goals, profileIds, properties);
        }
        finally {
            if (!this.getLog().isDebugEnabled()) {
                tmpProjectFile.delete();
            }
        }
    }

    private static List getActiveProfileIds(MavenProject clone) {
        ArrayList<String> profileIds = new ArrayList<String>();
        Iterator it = clone.getActiveProfiles().iterator();
        while (it.hasNext()) {
            profileIds.add(((Profile)it.next()).getId());
        }
        return profileIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invoke(File projectFile, File invokerLog, String mavenHome, List goals, List activeProfiles, Properties properties) {
        InvocationResult invocationResult;
        DefaultInvoker invoker = new DefaultInvoker();
        invoker.setMavenHome(new File(mavenHome));
        File localRepoDir = new File(this.localRepository.getBasedir());
        invoker.setLocalRepositoryDirectory(localRepoDir);
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setLocalRepositoryDirectory(localRepoDir);
        request.setInteractive(false);
        request.setShowErrors(this.getLog().isErrorEnabled());
        request.setDebug(this.getLog().isDebugEnabled());
        request.setBaseDirectory(projectFile.getParentFile());
        request.setPomFile(projectFile);
        request.setGoals(goals);
        request.setProperties(properties);
        request.setProfiles(activeProfiles);
        File javaHome = this.getJavaHome();
        if (javaHome != null) {
            request.setJavaHome(javaHome);
        }
        try {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Invoking Maven for the goals: " + goals + " with properties=" + properties));
            }
            invocationResult = this.invoke((Invoker)invoker, (InvocationRequest)request, invokerLog, goals, properties, null);
        }
        catch (MavenInvocationException e) {
            this.getLog().error((CharSequence)"Error when invoking Maven, consult the invoker log.");
            this.getLog().debug((Throwable)e);
            return;
        }
        String invokerLogContent = null;
        Reader reader = null;
        try {
            reader = ReaderFactory.newReader((File)invokerLog, (String)"UTF-8");
            invokerLogContent = IOUtil.toString((Reader)reader);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("IOException: " + e.getMessage()));
            this.getLog().debug((Throwable)e);
        }
        finally {
            IOUtil.close((Reader)reader);
        }
        if (invokerLogContent != null && invokerLogContent.indexOf("Error occurred during initialization of VM") != -1) {
            this.getLog().info((CharSequence)"Error occurred during initialization of VM, try to use an empty MAVEN_OPTS.");
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Reinvoking Maven for the goals: " + goals + " with an empty MAVEN_OPTS"));
            }
            try {
                invocationResult = this.invoke((Invoker)invoker, (InvocationRequest)request, invokerLog, goals, properties, "");
            }
            catch (MavenInvocationException e) {
                this.getLog().error((CharSequence)"Error when reinvoking Maven, consult the invoker log.");
                this.getLog().debug((Throwable)e);
                return;
            }
        }
        if (invocationResult.getExitCode() != 0 && this.getLog().isErrorEnabled()) {
            this.getLog().error((CharSequence)("Error when invoking Maven, consult the invoker log file: " + invokerLog.getAbsolutePath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InvocationResult invoke(Invoker invoker, InvocationRequest request, File invokerLog, List goals, Properties properties, String mavenOpts) throws MavenInvocationException {
        PrintStream ps;
        FileOutputStream os = null;
        if (invokerLog != null) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Using " + invokerLog.getAbsolutePath() + " to log the invoker"));
            }
            try {
                if (!invokerLog.exists()) {
                    invokerLog.getParentFile().mkdirs();
                }
                os = new FileOutputStream(invokerLog);
                ps = new PrintStream((OutputStream)os, true, "UTF-8");
            }
            catch (FileNotFoundException e) {
                if (this.getLog().isErrorEnabled()) {
                    this.getLog().error((CharSequence)("FileNotFoundException: " + e.getMessage() + ". Using System.out to log the invoker."));
                }
                ps = System.out;
            }
            catch (UnsupportedEncodingException e) {
                if (this.getLog().isErrorEnabled()) {
                    this.getLog().error((CharSequence)("UnsupportedEncodingException: " + e.getMessage() + ". Using System.out to log the invoker."));
                }
                ps = System.out;
            }
        } else {
            this.getLog().debug((CharSequence)"Using System.out to log the invoker.");
            ps = System.out;
        }
        if (mavenOpts != null) {
            request.setMavenOpts(mavenOpts);
        }
        PrintStreamHandler outputHandler = new PrintStreamHandler(ps, false);
        request.setOutputHandler((InvocationOutputHandler)outputHandler);
        request.setErrorHandler((InvocationOutputHandler)outputHandler);
        outputHandler.consumeLine("Invoking Maven for the goals: " + goals + " with properties=" + properties);
        outputHandler.consumeLine("");
        outputHandler.consumeLine("M2_HOME=" + this.getMavenHome());
        outputHandler.consumeLine("MAVEN_OPTS=" + this.getMavenOpts());
        outputHandler.consumeLine("JAVA_HOME=" + this.getJavaHome());
        outputHandler.consumeLine("JAVA_OPTS=" + this.getJavaOpts());
        outputHandler.consumeLine("");
        try {
            InvocationResult invocationResult = invoker.execute(request);
            return invocationResult;
        }
        finally {
            IOUtil.close((OutputStream)os);
            ps = null;
        }
    }

    private String getMavenHome() {
        File m2Home;
        String mavenHome = System.getProperty("maven.home");
        if (mavenHome == null) {
            try {
                mavenHome = CommandLineUtils.getSystemEnvVars().getProperty("M2_HOME");
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("IOException: " + e.getMessage()));
                this.getLog().debug((Throwable)e);
            }
        }
        if (!(m2Home = new File(mavenHome)).exists()) {
            this.getLog().error((CharSequence)"Cannot find Maven application directory. Either specify 'maven.home' system property, or M2_HOME environment variable.");
        }
        return mavenHome;
    }

    private String getMavenOpts() {
        String mavenOpts = null;
        try {
            mavenOpts = CommandLineUtils.getSystemEnvVars().getProperty("MAVEN_OPTS");
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("IOException: " + e.getMessage()));
            this.getLog().debug((Throwable)e);
        }
        return mavenOpts;
    }

    private File getJavaHome() {
        File javaHome = SystemUtils.IS_OS_MAC_OSX ? SystemUtils.getJavaHome() : new File(SystemUtils.getJavaHome(), "..");
        if (javaHome == null || !javaHome.exists()) {
            try {
                javaHome = new File(CommandLineUtils.getSystemEnvVars().getProperty("JAVA_HOME"));
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("IOException: " + e.getMessage()));
                this.getLog().debug((Throwable)e);
            }
        }
        if (javaHome == null || !javaHome.exists()) {
            this.getLog().error((CharSequence)"Cannot find Java application directory. Either specify 'java.home' system property, or JAVA_HOME environment variable.");
        }
        return javaHome;
    }

    private String getJavaOpts() {
        String javaOpts = null;
        try {
            javaOpts = CommandLineUtils.getSystemEnvVars().getProperty("JAVA_OPTS");
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("IOException: " + e.getMessage()));
            this.getLog().debug((Throwable)e);
        }
        return javaOpts;
    }

    private Log getLog() {
        return this.log;
    }
}

