/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ear.output;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.ear.output.FileNameMapping;

public abstract class AbstractFileNameMapping
implements FileNameMapping {
    private boolean useBaseVersion = false;

    public final void setUseBaseVersion(boolean useBaseVersion) {
        this.useBaseVersion = useBaseVersion;
    }

    protected String generateFileName(Artifact a, boolean addVersion) {
        String extension = a.getArtifactHandler().getExtension();
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(a.getArtifactId());
        if (addVersion) {
            if (this.useBaseVersion) {
                buffer.append('-').append(a.getBaseVersion());
            } else {
                buffer.append('-').append(a.getVersion());
            }
        }
        if (a.hasClassifier()) {
            buffer.append('-').append(a.getClassifier());
        }
        if (extension != null && extension.length() > 0) {
            buffer.append('.').append(extension);
        }
        return buffer.toString();
    }
}

