/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.analyze;

import java.util.Locale;
import java.util.Set;
import javax.inject.Inject;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.dependency.analyze.AnalyzeReportRenderer;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalysis;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalyzer;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalyzerException;
import org.codehaus.plexus.i18n.I18N;

@Mojo(name="analyze-report", requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
@Execute(phase=LifecyclePhase.TEST_COMPILE)
public class AnalyzeReport
extends AbstractMavenReport {
    private final ProjectDependencyAnalyzer analyzer;
    private final I18N i18n;
    @Parameter(property="ignoreNonCompile", defaultValue="false")
    private boolean ignoreNonCompile;
    @Parameter
    private String[] usedDependencies;
    @Parameter(property="mdep.analyze.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="mdep.analyze.excludedClasses")
    private Set<String> excludedClasses;

    @Inject
    public AnalyzeReport(ProjectDependencyAnalyzer analyzer, I18N i18n) {
        this.analyzer = analyzer;
        this.i18n = i18n;
    }

    public void executeReport(Locale locale) throws MavenReportException {
        ProjectDependencyAnalysis analysis;
        try {
            analysis = this.analyzer.analyze(this.project, this.excludedClasses);
            if (this.usedDependencies != null) {
                analysis = analysis.forceDeclaredDependenciesUsage(this.usedDependencies);
            }
        }
        catch (ProjectDependencyAnalyzerException exception) {
            throw new MavenReportException("Cannot analyze dependencies", (Exception)((Object)exception));
        }
        if (this.ignoreNonCompile) {
            analysis = analysis.ignoreNonCompile();
        }
        AnalyzeReportRenderer r = new AnalyzeReportRenderer(this.getSink(), this.i18n, locale, analysis);
        r.render();
    }

    public boolean canGenerateReport() {
        if (this.skip) {
            return false;
        }
        return !"pom".equals(this.project.getPackaging());
    }

    public String getOutputName() {
        return "dependency-analysis";
    }

    public String getName(Locale locale) {
        return this.getI18nString(locale, "name");
    }

    public String getDescription(Locale locale) {
        return this.getI18nString(locale, "description");
    }

    protected String getI18nString(Locale locale, String key) {
        return this.i18n.getString("analyze-report", locale, "report.analyze." + key);
    }
}

