/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ant;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class AntCleanMojo
extends AbstractMojo {
    private MavenProject project;
    private boolean deleteCustomFiles;

    public void execute() throws MojoExecutionException {
        File mavenBuildXml;
        File buildXml = new File(this.project.getBasedir(), "build.xml");
        if (buildXml.exists()) {
            if (this.deleteCustomFiles) {
                if (!buildXml.delete()) {
                    throw new MojoExecutionException("Cannot delete " + buildXml.getAbsolutePath());
                }
            } else if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("Not deleting custom " + buildXml.getName() + ", use -DdeleteCustomFiles=true to force its deletion"));
            }
        }
        if ((mavenBuildXml = new File(this.project.getBasedir(), "maven-build.xml")).exists() && !mavenBuildXml.delete()) {
            throw new MojoExecutionException("Cannot delete " + mavenBuildXml.getAbsolutePath());
        }
        File mavenBuildProperties = new File(this.project.getBasedir(), "maven-build.properties");
        if (mavenBuildProperties.exists() && !mavenBuildProperties.delete()) {
            throw new MojoExecutionException("Cannot delete " + mavenBuildProperties.getAbsolutePath());
        }
        this.getLog().info((CharSequence)("Deleted Ant build files for project " + this.project.getArtifactId() + " in " + this.project.getBasedir().getAbsolutePath()));
    }
}

