/*
 * $Id$
 */

package org.apache.maven.model;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * This element describes all of the classpath resources associated
 * with a project
 *         or unit tests.
 * 
 * @version $Revision$ $Date$
 */
public class Resource extends FileSet 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             
     *             Describe the resource target path. The path is
     * relative to the target/classes
     *             directory (i.e.
     * <code>${project.build.outputDirectory}</code>).
     *             For example, if you want that resource to appear
     * in a specific package
     *             (<code>org.apache.maven.messages</code>), you
     * must specify this
     *             element with this value:
     * <code>org/apache/maven/messages</code>.
     *             This is not required if you simply put the
     * resources in that directory
     *             structure at the source, however.
     *             
     *           
     */
    private String targetPath;

    /**
     * 
     *             
     *             Whether resources are filtered to replace tokens
     * with parameterised values or not.
     *             The values are taken from the
     * <code>properties</code> element and from the
     *             properties in the files listed in the
     * <code>filters</code> element.
     *             
     *           
     */
    private boolean filtering = false;

    /**
     * 
     *             
     *             FOR INTERNAL USE ONLY. This is a unique
     * identifier assigned to each
     *             resource to allow Maven to merge changes to this
     * resource that take
     *             place during the execution of a plugin. This
     * field must be managed
     *             by the generated parser and formatter classes in
     * order to allow it
     *             to survive model interpolation.
     *             
     *           
     */
    private String mergeId;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *             
     *             FOR INTERNAL USE ONLY. This is a unique
     * identifier assigned to each
     *             resource to allow Maven to merge changes to this
     * resource that take
     *             place during the execution of a plugin. This
     * field must be managed
     *             by the generated parser and formatter classes in
     * order to allow it
     *             to survive model interpolation.
     *             
     *           
     * 
     * @return String
     */
    public String getMergeId()
    {
        return this.mergeId;
    } //-- String getMergeId() 

    /**
     * Get 
     *             
     *             Describe the resource target path. The path is
     * relative to the target/classes
     *             directory (i.e.
     * <code>${project.build.outputDirectory}</code>).
     *             For example, if you want that resource to appear
     * in a specific package
     *             (<code>org.apache.maven.messages</code>), you
     * must specify this
     *             element with this value:
     * <code>org/apache/maven/messages</code>.
     *             This is not required if you simply put the
     * resources in that directory
     *             structure at the source, however.
     *             
     *           
     * 
     * @return String
     */
    public String getTargetPath()
    {
        return this.targetPath;
    } //-- String getTargetPath() 

    /**
     * Get 
     *             
     *             Whether resources are filtered to replace tokens
     * with parameterised values or not.
     *             The values are taken from the
     * <code>properties</code> element and from the
     *             properties in the files listed in the
     * <code>filters</code> element.
     *             
     *           
     * 
     * @return boolean
     */
    public boolean isFiltering()
    {
        return this.filtering;
    } //-- boolean isFiltering() 

    /**
     * Set 
     *             
     *             Whether resources are filtered to replace tokens
     * with parameterised values or not.
     *             The values are taken from the
     * <code>properties</code> element and from the
     *             properties in the files listed in the
     * <code>filters</code> element.
     *             
     *           
     * 
     * @param filtering
     */
    public void setFiltering( boolean filtering )
    {
        this.filtering = filtering;
    } //-- void setFiltering( boolean ) 

    /**
     * Set 
     *             
     *             FOR INTERNAL USE ONLY. This is a unique
     * identifier assigned to each
     *             resource to allow Maven to merge changes to this
     * resource that take
     *             place during the execution of a plugin. This
     * field must be managed
     *             by the generated parser and formatter classes in
     * order to allow it
     *             to survive model interpolation.
     *             
     *           
     * 
     * @param mergeId
     */
    public void setMergeId( String mergeId )
    {
        this.mergeId = mergeId;
    } //-- void setMergeId( String ) 

    /**
     * Set 
     *             
     *             Describe the resource target path. The path is
     * relative to the target/classes
     *             directory (i.e.
     * <code>${project.build.outputDirectory}</code>).
     *             For example, if you want that resource to appear
     * in a specific package
     *             (<code>org.apache.maven.messages</code>), you
     * must specify this
     *             element with this value:
     * <code>org/apache/maven/messages</code>.
     *             This is not required if you simply put the
     * resources in that directory
     *             structure at the source, however.
     *             
     *           
     * 
     * @param targetPath
     */
    public void setTargetPath( String targetPath )
    {
        this.targetPath = targetPath;
    } //-- void setTargetPath( String ) 


            
    private static int mergeIdCounter = 0;

    public void initMergeId()
    {
        if ( getMergeId() == null )
        {
            setMergeId( "resource-" + (mergeIdCounter++) );
        }
    }

    /**
     * @see java.lang.Object#toString()
     */
    public String toString()
    {
        return "Resource {targetPath: " + getTargetPath() + ", filtering: " + isFiltering() + ", " + super.toString() + "}";
    }
            
          
    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
