/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.site;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.doxia.site.LinkItem;

public class MenuItem
extends LinkItem
implements Serializable,
Cloneable {
    private String description;
    private boolean collapse = false;
    private String ref;
    private List<MenuItem> items;

    public void addItem(MenuItem menuItem) {
        this.getItems().add(menuItem);
    }

    @Override
    public MenuItem clone() {
        try {
            MenuItem copy = (MenuItem)super.clone();
            if (this.items != null) {
                copy.items = new ArrayList<MenuItem>();
                for (MenuItem item : this.items) {
                    copy.items.add(item.clone());
                }
            }
            return copy;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MenuItem)) {
            return false;
        }
        MenuItem that = (MenuItem)other;
        boolean result = true;
        result = result && (this.getDescription() == null ? that.getDescription() == null : this.getDescription().equals(that.getDescription()));
        boolean bl = result = result && this.collapse == that.collapse;
        boolean bl2 = result && (this.getRef() == null ? that.getRef() == null : this.getRef().equals(that.getRef())) ? true : (result = false);
        result = result && (this.getItems() == null ? that.getItems() == null : this.getItems().equals(that.getItems()));
        result = result && super.equals(other);
        return result;
    }

    public String getDescription() {
        return this.description;
    }

    public List<MenuItem> getItems() {
        if (this.items == null) {
            this.items = new ArrayList<MenuItem>();
        }
        return this.items;
    }

    public String getRef() {
        return this.ref;
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 37 * result + (this.collapse ? 0 : 1);
        result = 37 * result + (this.ref != null ? this.ref.hashCode() : 0);
        result = 37 * result + (this.items != null ? this.items.hashCode() : 0);
        result = 37 * result + super.hashCode();
        return result;
    }

    public boolean isCollapse() {
        return this.collapse;
    }

    public void removeItem(MenuItem menuItem) {
        this.getItems().remove(menuItem);
    }

    public void setCollapse(boolean collapse) {
        this.collapse = collapse;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setItems(List<MenuItem> items) {
        this.items = items;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("description = '");
        buf.append(this.getDescription());
        buf.append("'");
        buf.append("\n");
        buf.append("collapse = '");
        buf.append(this.isCollapse());
        buf.append("'");
        buf.append("\n");
        buf.append("ref = '");
        buf.append(this.getRef());
        buf.append("'");
        buf.append("\n");
        buf.append("items = '");
        buf.append(this.getItems());
        buf.append("'");
        buf.append("\n");
        buf.append(super.toString());
        return buf.toString();
    }
}

