/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser.standard.builders;

import org.apache.lucene.queryParser.core.QueryNodeException;
import org.apache.lucene.queryParser.core.nodes.FieldQueryNode;
import org.apache.lucene.queryParser.core.nodes.QueryNode;
import org.apache.lucene.queryParser.core.util.StringUtils;
import org.apache.lucene.queryParser.standard.builders.StandardQueryBuilder;
import org.apache.lucene.queryParser.standard.nodes.TermRangeQueryNode;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.TermRangeQuery;

public class TermRangeQueryNodeBuilder
implements StandardQueryBuilder {
    public TermRangeQuery build(QueryNode queryNode) throws QueryNodeException {
        TermRangeQueryNode rangeNode = (TermRangeQueryNode)queryNode;
        FieldQueryNode upper = (FieldQueryNode)rangeNode.getUpperBound();
        FieldQueryNode lower = (FieldQueryNode)rangeNode.getLowerBound();
        String field = StringUtils.toString(rangeNode.getField());
        TermRangeQuery rangeQuery = new TermRangeQuery(field, lower.getTextAsString(), upper.getTextAsString(), rangeNode.isLowerInclusive(), rangeNode.isUpperInclusive());
        MultiTermQuery.RewriteMethod method = (MultiTermQuery.RewriteMethod)queryNode.getTag("MultiTermRewriteMethodConfiguration");
        if (method != null) {
            rangeQuery.setRewriteMethod(method);
        }
        return rangeQuery;
    }
}

