/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja;

import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ja.JapaneseKatakanaStemFilter;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class JapaneseKatakanaStemFilterFactory
extends TokenFilterFactory {
    private static final String MINIMUM_LENGTH_PARAM = "minimumLength";
    private int minimumLength;

    public void init(Map<String, String> args) {
        super.init(args);
        this.minimumLength = this.getInt(MINIMUM_LENGTH_PARAM, 4);
        if (this.minimumLength < 2) {
            throw new IllegalArgumentException("Illegal minimumLength " + this.minimumLength + " (must be 2 or greater)");
        }
    }

    public TokenStream create(TokenStream input) {
        return new JapaneseKatakanaStemFilter(input, this.minimumLength);
    }
}

