/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.StickyAssignor;
import org.apache.kafka.clients.consumer.internals.AbstractPartitionAssignorTest;
import org.apache.kafka.clients.consumer.internals.AbstractStickyAssignor;
import org.apache.kafka.clients.consumer.internals.AbstractStickyAssignorTest;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.utils.CollectionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;

public class StickyAssignorTest
extends AbstractStickyAssignorTest {
    @Override
    public AbstractStickyAssignor createAssignor() {
        return new StickyAssignor();
    }

    @Override
    public ConsumerPartitionAssignor.Subscription buildSubscriptionV0(List<String> topics, List<TopicPartition> partitions, int generationId, int consumerIndex) {
        return new ConsumerPartitionAssignor.Subscription(topics, StickyAssignor.serializeTopicPartitionAssignment((AbstractStickyAssignor.MemberData)new AbstractStickyAssignor.MemberData(partitions, Optional.of(generationId))), Collections.emptyList(), -1, this.consumerRackId(consumerIndex));
    }

    @Override
    public ConsumerPartitionAssignor.Subscription buildSubscriptionV1(List<String> topics, List<TopicPartition> partitions, int generationId, int consumerIndex) {
        return new ConsumerPartitionAssignor.Subscription(topics, StickyAssignor.serializeTopicPartitionAssignment((AbstractStickyAssignor.MemberData)new AbstractStickyAssignor.MemberData(partitions, Optional.of(generationId))), partitions, -1, Optional.empty());
    }

    @Override
    public ConsumerPartitionAssignor.Subscription buildSubscriptionV2Above(List<String> topics, List<TopicPartition> partitions, int generationId, int consumerIndex) {
        return new ConsumerPartitionAssignor.Subscription(topics, StickyAssignor.serializeTopicPartitionAssignment((AbstractStickyAssignor.MemberData)new AbstractStickyAssignor.MemberData(partitions, Optional.of(generationId))), partitions, generationId, Optional.empty());
    }

    @Override
    public ByteBuffer generateUserData(List<String> topics, List<TopicPartition> partitions, int generation) {
        return StickyAssignor.serializeTopicPartitionAssignment((AbstractStickyAssignor.MemberData)new AbstractStickyAssignor.MemberData(partitions, Optional.of(generation)));
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}")
    @EnumSource(value=AbstractPartitionAssignorTest.RackConfig.class)
    public void testAllConsumersHaveOwnedPartitionInvalidatedWhenClaimedByMultipleConsumersInSameGenerationWithEqualPartitionsPerConsumer(AbstractPartitionAssignorTest.RackConfig rackConfig) {
        this.initializeRacks(rackConfig);
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        partitionsPerTopic.put(this.topic, this.partitionInfos(this.topic, 3));
        this.subscriptions.put(this.consumer1, this.buildSubscriptionV2Above(StickyAssignorTest.topics(this.topic), StickyAssignorTest.partitions(StickyAssignorTest.tp(this.topic, 0), StickyAssignorTest.tp(this.topic, 1)), this.generationId, 0));
        this.subscriptions.put(this.consumer2, this.buildSubscriptionV2Above(StickyAssignorTest.topics(this.topic), StickyAssignorTest.partitions(StickyAssignorTest.tp(this.topic, 0), StickyAssignorTest.tp(this.topic, 2)), this.generationId, 1));
        this.subscriptions.put(this.consumer3, this.buildSubscriptionV2Above(StickyAssignorTest.topics(this.topic), Collections.emptyList(), this.generationId, 2));
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        Assertions.assertEquals(StickyAssignorTest.partitions(StickyAssignorTest.tp(this.topic, 1)), assignment.get(this.consumer1));
        Assertions.assertEquals(StickyAssignorTest.partitions(StickyAssignorTest.tp(this.topic, 2)), assignment.get(this.consumer2));
        Assertions.assertEquals(StickyAssignorTest.partitions(StickyAssignorTest.tp(this.topic, 0)), assignment.get(this.consumer3));
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)StickyAssignorTest.isFullyBalanced(assignment));
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}")
    @EnumSource(value=AbstractPartitionAssignorTest.RackConfig.class)
    public void testAllConsumersHaveOwnedPartitionInvalidatedWhenClaimedByMultipleConsumersInSameGenerationWithUnequalPartitionsPerConsumer(AbstractPartitionAssignorTest.RackConfig rackConfig) {
        this.initializeRacks(rackConfig);
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        partitionsPerTopic.put(this.topic, this.partitionInfos(this.topic, 4));
        this.subscriptions.put(this.consumer1, this.buildSubscriptionV2Above(StickyAssignorTest.topics(this.topic), StickyAssignorTest.partitions(StickyAssignorTest.tp(this.topic, 0), StickyAssignorTest.tp(this.topic, 1)), this.generationId, 0));
        this.subscriptions.put(this.consumer2, this.buildSubscriptionV2Above(StickyAssignorTest.topics(this.topic), StickyAssignorTest.partitions(StickyAssignorTest.tp(this.topic, 0), StickyAssignorTest.tp(this.topic, 2)), this.generationId, 1));
        this.subscriptions.put(this.consumer3, this.buildSubscriptionV2Above(StickyAssignorTest.topics(this.topic), Collections.emptyList(), this.generationId, 2));
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        Assertions.assertEquals(StickyAssignorTest.partitions(StickyAssignorTest.tp(this.topic, 1), StickyAssignorTest.tp(this.topic, 3)), assignment.get(this.consumer1));
        Assertions.assertEquals(StickyAssignorTest.partitions(StickyAssignorTest.tp(this.topic, 2)), assignment.get(this.consumer2));
        Assertions.assertEquals(StickyAssignorTest.partitions(StickyAssignorTest.tp(this.topic, 0)), assignment.get(this.consumer3));
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)StickyAssignorTest.isFullyBalanced(assignment));
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}, isAllSubscriptionsEqual = {1}")
    @MethodSource(value={"rackAndSubscriptionCombinations"})
    public void testAssignmentWithMultipleGenerations1(AbstractPartitionAssignorTest.RackConfig rackConfig, boolean isAllSubscriptionsEqual) {
        this.initializeRacks(rackConfig);
        List<String> allTopics = StickyAssignorTest.topics(this.topic, this.topic2);
        List<String> consumer2SubscribedTopics = isAllSubscriptionsEqual ? allTopics : StickyAssignorTest.topics(this.topic);
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        partitionsPerTopic.put(this.topic, this.partitionInfos(this.topic, 6));
        partitionsPerTopic.put(this.topic2, this.partitionInfos(this.topic2, 6));
        this.subscriptions.put(this.consumer1, this.subscription(allTopics, 0));
        this.subscriptions.put(this.consumer2, this.subscription(consumer2SubscribedTopics, 1));
        this.subscriptions.put(this.consumer3, this.subscription(allTopics, 2));
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        List r1partitions1 = (List)assignment.get(this.consumer1);
        List r1partitions2 = (List)assignment.get(this.consumer2);
        List r1partitions3 = (List)assignment.get(this.consumer3);
        Assertions.assertTrue((r1partitions1.size() == 4 && r1partitions2.size() == 4 && r1partitions3.size() == 4 ? 1 : 0) != 0);
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)StickyAssignorTest.isFullyBalanced(assignment));
        this.subscriptions.put(this.consumer1, this.buildSubscriptionV2Above(allTopics, r1partitions1, this.generationId, 0));
        this.subscriptions.put(this.consumer2, this.buildSubscriptionV2Above(consumer2SubscribedTopics, r1partitions2, this.generationId, 1));
        this.subscriptions.remove(this.consumer3);
        assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        List r2partitions1 = (List)assignment.get(this.consumer1);
        List r2partitions2 = (List)assignment.get(this.consumer2);
        Assertions.assertTrue((r2partitions1.size() == 6 && r2partitions2.size() == 6 ? 1 : 0) != 0);
        if (isAllSubscriptionsEqual) {
            Assertions.assertTrue((boolean)r2partitions1.containsAll(r1partitions1));
        }
        Assertions.assertTrue((boolean)r2partitions2.containsAll(r1partitions2));
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)StickyAssignorTest.isFullyBalanced(assignment));
        Assertions.assertFalse((boolean)Collections.disjoint(r2partitions2, r1partitions3));
        this.subscriptions.remove(this.consumer1);
        this.subscriptions.put(this.consumer2, this.buildSubscriptionV2Above(consumer2SubscribedTopics, r2partitions2, 2, 1));
        this.subscriptions.put(this.consumer3, this.buildSubscriptionV2Above(allTopics, r1partitions3, 1, 2));
        assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        List r3partitions2 = (List)assignment.get(this.consumer2);
        List r3partitions3 = (List)assignment.get(this.consumer3);
        Assertions.assertTrue((r3partitions2.size() == 6 && r3partitions3.size() == 6 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)Collections.disjoint(r3partitions2, r3partitions3));
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)StickyAssignorTest.isFullyBalanced(assignment));
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}, isAllSubscriptionsEqual = {1}")
    @MethodSource(value={"rackAndSubscriptionCombinations"})
    public void testAssignmentWithMultipleGenerations2(AbstractPartitionAssignorTest.RackConfig rackConfig, boolean isAllSubscriptionsEqual) {
        this.initializeRacks(rackConfig);
        List<String> allTopics = StickyAssignorTest.topics(this.topic, this.topic2, this.topic3);
        List<String> consumer1SubscribedTopics = isAllSubscriptionsEqual ? allTopics : StickyAssignorTest.topics(this.topic);
        List<String> consumer3SubscribedTopics = isAllSubscriptionsEqual ? allTopics : StickyAssignorTest.topics(this.topic, this.topic2);
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        partitionsPerTopic.put(this.topic, this.partitionInfos(this.topic, 4));
        partitionsPerTopic.put(this.topic2, this.partitionInfos(this.topic2, 4));
        partitionsPerTopic.put(this.topic3, this.partitionInfos(this.topic3, 4));
        this.subscriptions.put(this.consumer1, this.subscription(consumer1SubscribedTopics, 0));
        this.subscriptions.put(this.consumer2, this.subscription(allTopics, 1));
        this.subscriptions.put(this.consumer3, this.subscription(consumer3SubscribedTopics, 2));
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        List r1partitions1 = (List)assignment.get(this.consumer1);
        List r1partitions2 = (List)assignment.get(this.consumer2);
        List r1partitions3 = (List)assignment.get(this.consumer3);
        Assertions.assertTrue((r1partitions1.size() == 4 && r1partitions2.size() == 4 && r1partitions3.size() == 4 ? 1 : 0) != 0);
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)StickyAssignorTest.isFullyBalanced(assignment));
        this.subscriptions.remove(this.consumer1);
        this.subscriptions.put(this.consumer2, this.buildSubscriptionV2Above(allTopics, r1partitions2, 1, 1));
        this.subscriptions.remove(this.consumer3);
        assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        List r2partitions2 = (List)assignment.get(this.consumer2);
        Assertions.assertEquals((int)12, (int)r2partitions2.size());
        Assertions.assertTrue((boolean)r2partitions2.containsAll(r1partitions2));
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)StickyAssignorTest.isFullyBalanced(assignment));
        this.subscriptions.put(this.consumer1, this.buildSubscriptionV2Above(consumer1SubscribedTopics, r1partitions1, 1, 0));
        this.subscriptions.put(this.consumer2, this.buildSubscriptionV2Above(allTopics, r2partitions2, 2, 1));
        this.subscriptions.put(this.consumer3, this.buildSubscriptionV2Above(consumer3SubscribedTopics, r1partitions3, 1, 2));
        assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        List r3partitions1 = (List)assignment.get(this.consumer1);
        List r3partitions2 = (List)assignment.get(this.consumer2);
        List r3partitions3 = (List)assignment.get(this.consumer3);
        Assertions.assertTrue((r3partitions1.size() == 4 && r3partitions2.size() == 4 && r3partitions3.size() == 4 ? 1 : 0) != 0);
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)StickyAssignorTest.isFullyBalanced(assignment));
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}, isAllSubscriptionsEqual = {1}")
    @MethodSource(value={"rackAndSubscriptionCombinations"})
    public void testAssignmentWithConflictingPreviousGenerations(AbstractPartitionAssignorTest.RackConfig rackConfig, boolean isAllSubscriptionsEqual) {
        this.initializeRacks(rackConfig);
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        partitionsPerTopic.put(this.topic, this.partitionInfos(this.topic, 4));
        partitionsPerTopic.put(this.topic2, this.partitionInfos(this.topic2, 4));
        partitionsPerTopic.put(this.topic3, this.partitionInfos(this.topic3, 4));
        List<String> allTopics = StickyAssignorTest.topics(this.topic, this.topic2, this.topic3);
        List<String> consumer1SubscribedTopics = isAllSubscriptionsEqual ? allTopics : StickyAssignorTest.topics(this.topic);
        List<String> consumer2SubscribedTopics = isAllSubscriptionsEqual ? allTopics : StickyAssignorTest.topics(this.topic, this.topic2);
        this.subscriptions.put(this.consumer1, this.subscription(consumer1SubscribedTopics, 0));
        this.subscriptions.put(this.consumer2, this.subscription(consumer2SubscribedTopics, 1));
        this.subscriptions.put(this.consumer3, this.subscription(allTopics, 2));
        TopicPartition tp0 = new TopicPartition(this.topic, 0);
        TopicPartition tp1 = new TopicPartition(this.topic, 1);
        TopicPartition tp2 = new TopicPartition(this.topic, 2);
        TopicPartition tp3 = new TopicPartition(this.topic, 3);
        TopicPartition t2p0 = new TopicPartition(this.topic2, 0);
        TopicPartition t2p1 = new TopicPartition(this.topic2, 1);
        TopicPartition t2p2 = new TopicPartition(this.topic2, 2);
        TopicPartition t2p3 = new TopicPartition(this.topic2, 3);
        TopicPartition t3p0 = new TopicPartition(this.topic3, 0);
        TopicPartition t3p1 = new TopicPartition(this.topic3, 1);
        TopicPartition t3p2 = new TopicPartition(this.topic3, 2);
        TopicPartition t3p3 = new TopicPartition(this.topic3, 3);
        List<TopicPartition> c1partitions0 = isAllSubscriptionsEqual ? StickyAssignorTest.partitions(tp0, tp1, tp2, t2p2, t2p3, t3p0) : StickyAssignorTest.partitions(tp0, tp1, tp2, tp3);
        List<TopicPartition> c2partitions0 = StickyAssignorTest.partitions(tp0, tp1, t2p0, t2p1, t2p2, t2p3);
        List<TopicPartition> c3partitions0 = StickyAssignorTest.partitions(tp2, tp3, t3p0, t3p1, t3p2, t3p3);
        this.subscriptions.put(this.consumer1, this.buildSubscriptionV2Above(consumer1SubscribedTopics, c1partitions0, 1, 0));
        this.subscriptions.put(this.consumer2, this.buildSubscriptionV2Above(consumer2SubscribedTopics, c2partitions0, 2, 1));
        this.subscriptions.put(this.consumer3, this.buildSubscriptionV2Above(allTopics, c3partitions0, 2, 2));
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        List c1partitions = (List)assignment.get(this.consumer1);
        List c2partitions = (List)assignment.get(this.consumer2);
        List c3partitions = (List)assignment.get(this.consumer3);
        Assertions.assertTrue((c1partitions.size() == 4 && c2partitions.size() == 4 && c3partitions.size() == 4 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)c2partitions0.containsAll(c2partitions));
        Assertions.assertTrue((boolean)c3partitions0.containsAll(c3partitions));
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)StickyAssignorTest.isFullyBalanced(assignment));
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}")
    @EnumSource(value=AbstractPartitionAssignorTest.RackConfig.class)
    public void testSchemaBackwardCompatibility(AbstractPartitionAssignorTest.RackConfig rackConfig) {
        this.initializeRacks(rackConfig);
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        partitionsPerTopic.put(this.topic, this.partitionInfos(this.topic, 3));
        this.subscriptions.put(this.consumer1, this.subscription(StickyAssignorTest.topics(this.topic), 0));
        this.subscriptions.put(this.consumer2, this.subscription(StickyAssignorTest.topics(this.topic), 1));
        this.subscriptions.put(this.consumer3, this.subscription(StickyAssignorTest.topics(this.topic), 2));
        TopicPartition tp0 = new TopicPartition(this.topic, 0);
        TopicPartition tp1 = new TopicPartition(this.topic, 1);
        TopicPartition tp2 = new TopicPartition(this.topic, 2);
        List<TopicPartition> c1partitions0 = StickyAssignorTest.partitions(tp0, tp2);
        List<TopicPartition> c2partitions0 = StickyAssignorTest.partitions(tp1);
        this.subscriptions.put(this.consumer1, this.buildSubscriptionV2Above(StickyAssignorTest.topics(this.topic), c1partitions0, 1, 0));
        this.subscriptions.put(this.consumer2, this.buildSubscriptionWithOldSchema(StickyAssignorTest.topics(this.topic), c2partitions0, 1));
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        List c1partitions = (List)assignment.get(this.consumer1);
        List c2partitions = (List)assignment.get(this.consumer2);
        List c3partitions = (List)assignment.get(this.consumer3);
        Assertions.assertTrue((c1partitions.size() == 1 && c2partitions.size() == 1 && c3partitions.size() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)c1partitions0.containsAll(c1partitions));
        Assertions.assertTrue((boolean)c2partitions0.containsAll(c2partitions));
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)StickyAssignorTest.isFullyBalanced(assignment));
    }

    @ParameterizedTest(name="{displayName}.rackConfig = {0}")
    @EnumSource(value=AbstractPartitionAssignorTest.RackConfig.class)
    public void testMemberDataWithInconsistentData(AbstractPartitionAssignorTest.RackConfig rackConfig) {
        this.initializeRacks(rackConfig);
        List<TopicPartition> ownedPartitionsInUserdata = StickyAssignorTest.partitions(this.tp1);
        List<TopicPartition> ownedPartitionsInSubscription = StickyAssignorTest.partitions(this.tp0);
        this.assignor.onAssignment(new ConsumerPartitionAssignor.Assignment(ownedPartitionsInUserdata), new ConsumerGroupMetadata(this.groupId, this.generationId, this.consumer1, Optional.empty()));
        ByteBuffer userDataWithHigherGenerationId = this.assignor.subscriptionUserData(new HashSet<String>(StickyAssignorTest.topics(this.topic)));
        ConsumerPartitionAssignor.Subscription subscription = new ConsumerPartitionAssignor.Subscription(StickyAssignorTest.topics(this.topic), userDataWithHigherGenerationId, ownedPartitionsInSubscription);
        AbstractStickyAssignor.MemberData memberData = this.memberData(subscription);
        Assertions.assertEquals(ownedPartitionsInUserdata, (Object)memberData.partitions, (String)("subscription: " + subscription + " doesn't have expected owned partition"));
        Assertions.assertEquals((int)this.generationId, (Integer)memberData.generation.orElse(-1), (String)("subscription: " + subscription + " doesn't have expected generation id"));
    }

    @Test
    public void testMemberDataWillHonorUserData() {
        List<String> topics = StickyAssignorTest.topics(this.topic);
        List<TopicPartition> ownedPartitions = StickyAssignorTest.partitions(StickyAssignorTest.tp(this.topic1, 0), StickyAssignorTest.tp(this.topic2, 1));
        int generationIdInUserData = this.generationId - 1;
        ConsumerPartitionAssignor.Subscription subscription = new ConsumerPartitionAssignor.Subscription(topics, this.generateUserData(topics, ownedPartitions, generationIdInUserData), Collections.emptyList(), this.generationId, Optional.empty());
        AbstractStickyAssignor.MemberData memberData = this.memberData(subscription);
        Assertions.assertEquals(ownedPartitions, (Object)memberData.partitions, (String)("subscription: " + subscription + " doesn't have expected owned partition"));
        Assertions.assertEquals((int)generationIdInUserData, (Integer)memberData.generation.orElse(-1), (String)("subscription: " + subscription + " doesn't have expected generation id"));
    }

    @Test
    public void testAssignorWithOldVersionSubscriptions() {
        HashMap<String, List<PartitionInfo>> partitionsPerTopic = new HashMap<String, List<PartitionInfo>>();
        partitionsPerTopic.put(this.topic1, this.partitionInfos(this.topic1, 3));
        List<String> subscribedTopics = StickyAssignorTest.topics(this.topic1);
        this.subscriptions.put(this.consumer1, this.buildSubscriptionV0(subscribedTopics, StickyAssignorTest.partitions(StickyAssignorTest.tp(this.topic1, 0)), this.generationId, 0));
        this.subscriptions.put(this.consumer2, this.buildSubscriptionV1(subscribedTopics, StickyAssignorTest.partitions(StickyAssignorTest.tp(this.topic1, 1)), this.generationId, 1));
        this.subscriptions.put(this.consumer3, this.buildSubscriptionV2Above(subscribedTopics, Collections.emptyList(), this.generationId, 2));
        Map assignment = this.assignor.assignPartitions(partitionsPerTopic, this.subscriptions);
        Assertions.assertEquals(StickyAssignorTest.partitions(StickyAssignorTest.tp(this.topic1, 0)), assignment.get(this.consumer1));
        Assertions.assertEquals(StickyAssignorTest.partitions(StickyAssignorTest.tp(this.topic1, 1)), assignment.get(this.consumer2));
        Assertions.assertEquals(StickyAssignorTest.partitions(StickyAssignorTest.tp(this.topic1, 2)), assignment.get(this.consumer3));
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)StickyAssignorTest.isFullyBalanced(assignment));
    }

    private ConsumerPartitionAssignor.Subscription buildSubscriptionWithOldSchema(List<String> topics, List<TopicPartition> partitions, int consumerIndex) {
        Struct struct = new Struct(StickyAssignor.STICKY_ASSIGNOR_USER_DATA_V0);
        ArrayList<Struct> topicAssignments = new ArrayList<Struct>();
        for (Map.Entry topicEntry : CollectionUtils.groupPartitionsByTopic(partitions).entrySet()) {
            Struct topicAssignment = new Struct(StickyAssignor.TOPIC_ASSIGNMENT);
            topicAssignment.set("topic", topicEntry.getKey());
            topicAssignment.set("partitions", (Object)((List)topicEntry.getValue()).toArray());
            topicAssignments.add(topicAssignment);
        }
        struct.set("previous_assignment", (Object)topicAssignments.toArray());
        ByteBuffer buffer = ByteBuffer.allocate(StickyAssignor.STICKY_ASSIGNOR_USER_DATA_V0.sizeOf((Object)struct));
        StickyAssignor.STICKY_ASSIGNOR_USER_DATA_V0.write(buffer, (Object)struct);
        buffer.flip();
        return new ConsumerPartitionAssignor.Subscription(topics, buffer, Collections.emptyList(), -1, this.consumerRackId(consumerIndex));
    }

    public static Collection<Arguments> rackAndSubscriptionCombinations() {
        return Arrays.asList(Arguments.of((Object[])new Object[]{AbstractPartitionAssignorTest.RackConfig.NO_BROKER_RACK, true}), Arguments.of((Object[])new Object[]{AbstractPartitionAssignorTest.RackConfig.NO_CONSUMER_RACK, true}), Arguments.of((Object[])new Object[]{AbstractPartitionAssignorTest.RackConfig.BROKER_AND_CONSUMER_RACK, true}), Arguments.of((Object[])new Object[]{AbstractPartitionAssignorTest.RackConfig.NO_BROKER_RACK, false}), Arguments.of((Object[])new Object[]{AbstractPartitionAssignorTest.RackConfig.NO_CONSUMER_RACK, false}), Arguments.of((Object[])new Object[]{AbstractPartitionAssignorTest.RackConfig.BROKER_AND_CONSUMER_RACK, false}));
    }
}

