/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import org.apache.poi.hssf.record.HyperlinkRecord;

public class HSSFHyperlink {
    public static final int LINK_URL = 1;
    public static final int LINK_DOCUMENT = 2;
    public static final int LINK_EMAIL = 3;
    public static final int LINK_FILE = 4;
    protected HyperlinkRecord record = null;
    protected int link_type;

    public HSSFHyperlink(int type) {
        this.link_type = type;
        this.record = new HyperlinkRecord();
        switch (type) {
            case 1: 
            case 3: {
                this.record.newUrlLink();
                break;
            }
            case 4: {
                this.record.newFileLink();
                break;
            }
            case 2: {
                this.record.newDocumentLink();
            }
        }
    }

    protected HSSFHyperlink(HyperlinkRecord record) {
        this.record = record;
    }

    public int getFirstRow() {
        return this.record.getFirstRow();
    }

    public void setFirstRow(int row) {
        this.record.setFirstRow(row);
    }

    public int getLastRow() {
        return this.record.getLastRow();
    }

    public void setLastRow(int row) {
        this.record.setLastRow(row);
    }

    public short getFirstColumn() {
        return this.record.getFirstColumn();
    }

    public void setFirstColumn(short col) {
        this.record.setFirstColumn(col);
    }

    public short getLastColumn() {
        return this.record.getLastColumn();
    }

    public void setLastColumn(short col) {
        this.record.setLastColumn(col);
    }

    public String getAddress() {
        return this.record.getAddress();
    }

    public void setAddress(String address) {
        this.record.setAddress(address);
    }

    public String getLabel() {
        return this.record.getLabel();
    }

    public void setLabel(String label) {
        this.record.setLabel(label);
    }

    protected int getType() {
        return this.link_type;
    }
}

