/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public final class BoolErrRecord
extends Record
implements CellValueRecordInterface {
    public static final short sid = 517;
    private int field_1_row;
    private short field_2_column;
    private short field_3_xf_index;
    private byte field_4_bBoolErr;
    private byte field_5_fError;

    public BoolErrRecord() {
    }

    public BoolErrRecord(RecordInputStream in) {
        this.field_1_row = in.readUShort();
        this.field_2_column = in.readShort();
        this.field_3_xf_index = in.readShort();
        this.field_4_bBoolErr = in.readByte();
        this.field_5_fError = in.readByte();
    }

    public void setRow(int row) {
        this.field_1_row = row;
    }

    public void setColumn(short col) {
        this.field_2_column = col;
    }

    public void setXFIndex(short xf) {
        this.field_3_xf_index = xf;
    }

    public void setValue(boolean value) {
        this.field_4_bBoolErr = value ? (byte)1 : 0;
        this.field_5_fError = 0;
    }

    public void setValue(byte value) {
        if (value != 0 && value != 7 && value != 15 && value != 23 && value != 29 && value != 36 && value != 42) {
            throw new RuntimeException("Error Value can only be 0,7,15,23,29,36 or 42. It cannot be " + value);
        }
        this.field_4_bBoolErr = value;
        this.field_5_fError = 1;
    }

    public int getRow() {
        return this.field_1_row;
    }

    public short getColumn() {
        return this.field_2_column;
    }

    public short getXFIndex() {
        return this.field_3_xf_index;
    }

    public boolean getBooleanValue() {
        return this.field_4_bBoolErr != 0;
    }

    public byte getErrorValue() {
        return this.field_4_bBoolErr;
    }

    public boolean isBoolean() {
        return this.field_5_fError == 0;
    }

    public void setError(boolean val) {
        this.field_5_fError = (byte)(val ? 1 : 0);
    }

    public boolean isError() {
        return this.field_5_fError != 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[BOOLERR]\n");
        sb.append("    .row    = ").append(HexDump.shortToHex(this.getRow())).append("\n");
        sb.append("    .col    = ").append(HexDump.shortToHex(this.getColumn())).append("\n");
        sb.append("    .xfindex= ").append(HexDump.shortToHex(this.getXFIndex())).append("\n");
        if (this.isBoolean()) {
            sb.append("    .booleanValue   = ").append(this.getBooleanValue()).append("\n");
        } else {
            sb.append("    .errorValue     = ").append(this.getErrorValue()).append("\n");
        }
        sb.append("[/BOOLERR]\n");
        return sb.toString();
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putUShort(data, 0 + offset, 517);
        LittleEndian.putUShort(data, 2 + offset, 8);
        LittleEndian.putUShort(data, 4 + offset, this.getRow());
        LittleEndian.putUShort(data, 6 + offset, this.getColumn());
        LittleEndian.putUShort(data, 8 + offset, this.getXFIndex());
        data[10 + offset] = this.field_4_bBoolErr;
        data[11 + offset] = this.field_5_fError;
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 12;
    }

    public short getSid() {
        return 517;
    }

    public Object clone() {
        BoolErrRecord rec = new BoolErrRecord();
        rec.field_1_row = this.field_1_row;
        rec.field_2_column = this.field_2_column;
        rec.field_3_xf_index = this.field_3_xf_index;
        rec.field_4_bBoolErr = this.field_4_bBoolErr;
        rec.field_5_fError = this.field_5_fError;
        return rec;
    }
}

