/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.ReferentialIntegrityException;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.iterators.FilterIterator;
import org.apache.jackrabbit.core.InternalXAResource;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.TransactionContext;
import org.apache.jackrabbit.core.TransactionException;
import org.apache.jackrabbit.core.observation.EventStateCollectionFactory;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateCacheFactory;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.LocalItemStateManager;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeReferencesId;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.state.SharedItemStateManager;
import org.apache.jackrabbit.core.state.StaleItemStateException;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.virtual.VirtualItemStateProvider;
import org.apache.jackrabbit.uuid.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XAItemStateManager
extends LocalItemStateManager
implements InternalXAResource {
    private static Logger log = LoggerFactory.getLogger(XAItemStateManager.class);
    private static final String DEFAULT_ATTRIBUTE_NAME = "ChangeLog";
    private final Map commitLogs = Collections.synchronizedMap(new IdentityHashMap());
    private transient ChangeLog txLog;
    private transient SharedItemStateManager.Update update;
    private final String attributeName;
    private VirtualItemStateProvider virtualProvider;

    private XAItemStateManager(SharedItemStateManager sharedStateMgr, EventStateCollectionFactory factory, String attributeName, ItemStateCacheFactory cacheFactory) {
        super(sharedStateMgr, factory, cacheFactory);
        this.attributeName = attributeName != null ? attributeName : DEFAULT_ATTRIBUTE_NAME;
    }

    public static XAItemStateManager createInstance(SharedItemStateManager sharedStateMgr, EventStateCollectionFactory factory, String attributeName, ItemStateCacheFactory cacheFactory) {
        XAItemStateManager mgr = new XAItemStateManager(sharedStateMgr, factory, attributeName, cacheFactory);
        sharedStateMgr.addListener(mgr);
        return mgr;
    }

    public void setVirtualProvider(VirtualItemStateProvider virtualProvider) {
        this.virtualProvider = virtualProvider;
    }

    public void associate(TransactionContext tx) {
        ChangeLog txLog = null;
        if (tx != null && (txLog = (ChangeLog)tx.getAttribute(this.attributeName)) == null) {
            txLog = new ChangeLog();
            tx.setAttribute(this.attributeName, txLog);
        }
        this.txLog = txLog;
    }

    public void beforeOperation(TransactionContext tx) {
        ChangeLog txLog = (ChangeLog)tx.getAttribute(this.attributeName);
        if (txLog != null) {
            this.commitLogs.put(Thread.currentThread(), txLog);
        }
    }

    public void prepare(TransactionContext tx) throws TransactionException {
        ChangeLog txLog = (ChangeLog)tx.getAttribute(this.attributeName);
        if (txLog != null && txLog.hasUpdates()) {
            try {
                if (this.virtualProvider != null) {
                    this.updateVirtualReferences(txLog);
                }
                this.update = this.sharedStateMgr.beginUpdate(txLog, this.factory, this.virtualProvider);
            }
            catch (ReferentialIntegrityException rie) {
                txLog.undo(this.sharedStateMgr);
                throw new TransactionException("Unable to prepare transaction.", rie);
            }
            catch (ItemStateException ise) {
                txLog.undo(this.sharedStateMgr);
                throw new TransactionException("Unable to prepare transaction.", ise);
            }
        }
    }

    public void commit(TransactionContext tx) throws TransactionException {
        ChangeLog txLog = (ChangeLog)tx.getAttribute(this.attributeName);
        if (txLog != null && txLog.hasUpdates()) {
            try {
                this.update.end();
            }
            catch (ItemStateException ise) {
                txLog.undo(this.sharedStateMgr);
                throw new TransactionException("Unable to commit transaction.", ise);
            }
            txLog.reset();
        }
    }

    public void rollback(TransactionContext tx) {
        ChangeLog txLog = (ChangeLog)tx.getAttribute(this.attributeName);
        if (txLog != null && txLog.hasUpdates()) {
            if (this.update != null) {
                this.update.cancel();
            }
            txLog.undo(this.sharedStateMgr);
        }
    }

    public void afterOperation(TransactionContext tx) {
        this.commitLogs.remove(Thread.currentThread());
    }

    public ChangeLog getChangeLog() {
        ChangeLog changeLog = (ChangeLog)this.commitLogs.get(Thread.currentThread());
        if (changeLog == null) {
            changeLog = this.txLog;
        }
        return changeLog;
    }

    protected ChangeLog getChanges() {
        throw new UnsupportedOperationException("getChanges");
    }

    public ItemState getItemState(ItemId id) throws NoSuchItemStateException, ItemStateException {
        if (this.virtualProvider != null && this.virtualProvider.hasItemState(id)) {
            return this.virtualProvider.getItemState(id);
        }
        ChangeLog changeLog = super.getChanges();
        ItemState state = changeLog.get(id);
        if (state != null) {
            return state;
        }
        changeLog = this.getChangeLog();
        if (changeLog != null && (state = changeLog.get(id)) != null) {
            return state;
        }
        return super.getItemState(id);
    }

    public boolean hasItemState(ItemId id) {
        ItemState state;
        if (this.virtualProvider != null && this.virtualProvider.hasItemState(id)) {
            return true;
        }
        ChangeLog changeLog = super.getChanges();
        try {
            state = changeLog.get(id);
            if (state != null) {
                return true;
            }
        }
        catch (NoSuchItemStateException e) {
            return false;
        }
        changeLog = this.getChangeLog();
        if (changeLog != null) {
            try {
                state = changeLog.get(id);
                if (state != null) {
                    return true;
                }
            }
            catch (NoSuchItemStateException e) {
                return false;
            }
        }
        return this.sharedStateMgr.hasItemState(id);
    }

    public NodeReferences getNodeReferences(NodeReferencesId id) throws NoSuchItemStateException, ItemStateException {
        if (this.virtualProvider != null && this.virtualProvider.hasNodeReferences(id)) {
            return this.virtualProvider.getNodeReferences(id);
        }
        return this.getReferences(id);
    }

    public boolean hasNodeReferences(NodeReferencesId id) {
        if (this.virtualProvider != null && this.virtualProvider.hasNodeReferences(id)) {
            return true;
        }
        try {
            return this.getReferences(id).hasReferences();
        }
        catch (ItemStateException e) {
            return false;
        }
    }

    protected void update(ChangeLog changeLog) throws ReferentialIntegrityException, StaleItemStateException, ItemStateException {
        if (this.txLog != null) {
            this.txLog.merge(changeLog);
        } else {
            super.update(changeLog);
        }
    }

    private NodeReferences getReferences(NodeReferencesId id) throws ItemStateException {
        NodeReferences refs;
        try {
            refs = super.getNodeReferences(id);
        }
        catch (NoSuchItemStateException e) {
            refs = new NodeReferences(id);
        }
        ChangeLog changes = this.getChangeLog();
        if (changes != null) {
            int i;
            InternalValue[] values;
            PropertyState prop;
            UUID uuid = id.getTargetId().getUUID();
            Iterator it = this.filterReferenceProperties(changes.deletedStates());
            block4: while (it.hasNext()) {
                prop = (PropertyState)it.next();
                values = prop.getValues();
                for (i = 0; i < values.length; ++i) {
                    if (!values[i].getUUID().equals(uuid)) continue;
                    refs.removeReference(prop.getPropertyId());
                    continue block4;
                }
            }
            it = this.filterReferenceProperties(changes.addedStates());
            block6: while (it.hasNext()) {
                prop = (PropertyState)it.next();
                values = prop.getValues();
                for (i = 0; i < values.length; ++i) {
                    if (!values[i].getUUID().equals(uuid)) continue;
                    refs.addReference(prop.getPropertyId());
                    continue block6;
                }
            }
            it = changes.modifiedStates();
            block8: while (it.hasNext()) {
                PropertyState prop2;
                int i2;
                InternalValue[] values2;
                ItemState state;
                block12: {
                    state = (ItemState)it.next();
                    if (state.isNode()) continue;
                    try {
                        PropertyState old = (PropertyState)this.sharedStateMgr.getItemState(state.getId());
                        if (old.getType() != 9) break block12;
                        values2 = old.getValues();
                        for (i2 = 0; i2 < values2.length; ++i2) {
                            if (!values2[i2].getUUID().equals(uuid)) continue;
                            refs.removeReference(old.getPropertyId());
                            break;
                        }
                    }
                    catch (NoSuchItemStateException e) {
                        // empty catch block
                    }
                }
                if ((prop2 = (PropertyState)state).getType() != 9) continue;
                values2 = prop2.getValues();
                for (i2 = 0; i2 < values2.length; ++i2) {
                    if (!values2[i2].getUUID().equals(uuid)) continue;
                    refs.addReference(prop2.getPropertyId());
                    continue block8;
                }
            }
        }
        return refs;
    }

    private Iterator filterReferenceProperties(Iterator itemStates) {
        return new FilterIterator(itemStates, new Predicate(){

            public boolean evaluate(Object object) {
                ItemState state = (ItemState)object;
                if (!state.isNode()) {
                    PropertyState prop = (PropertyState)state;
                    return prop.getType() == 9;
                }
                return false;
            }
        });
    }

    private void updateVirtualReferences(ChangeLog changes) throws ItemStateException {
        NodeReferencesId refsId;
        InternalValue[] vals;
        PropertyState prop;
        ItemState state;
        ChangeLog references = new ChangeLog();
        Iterator iter = changes.addedStates();
        while (iter.hasNext()) {
            state = (ItemState)iter.next();
            if (state.isNode() || (prop = (PropertyState)state).getType() != 9) continue;
            vals = prop.getValues();
            for (int i = 0; vals != null && i < vals.length; ++i) {
                UUID uuid = vals[i].getUUID();
                refsId = new NodeReferencesId(uuid);
                this.addVirtualReference(references, prop.getPropertyId(), refsId);
            }
        }
        iter = changes.modifiedStates();
        while (iter.hasNext()) {
            NodeReferencesId refsId2;
            UUID uuid;
            int i;
            InternalValue[] vals2;
            state = (ItemState)iter.next();
            if (state.isNode()) continue;
            PropertyState newProp = (PropertyState)state;
            PropertyState oldProp = (PropertyState)this.getItemState(state.getId());
            if (oldProp.getType() == 9) {
                vals2 = oldProp.getValues();
                for (i = 0; vals2 != null && i < vals2.length; ++i) {
                    uuid = vals2[i].getUUID();
                    refsId2 = new NodeReferencesId(uuid);
                    this.removeVirtualReference(references, oldProp.getPropertyId(), refsId2);
                }
            }
            if (newProp.getType() != 9) continue;
            vals2 = newProp.getValues();
            for (i = 0; vals2 != null && i < vals2.length; ++i) {
                uuid = vals2[i].getUUID();
                refsId2 = new NodeReferencesId(uuid);
                this.addVirtualReference(references, newProp.getPropertyId(), refsId2);
            }
        }
        iter = changes.deletedStates();
        while (iter.hasNext()) {
            state = (ItemState)iter.next();
            if (state.isNode() || (prop = (PropertyState)state).getType() != 9) continue;
            vals = prop.getValues();
            for (int i = 0; vals != null && i < vals.length; ++i) {
                UUID uuid = vals[i].getUUID();
                refsId = new NodeReferencesId(uuid);
                this.removeVirtualReference(references, prop.getPropertyId(), refsId);
            }
        }
        this.virtualProvider.setNodeReferences(references);
    }

    private void addVirtualReference(ChangeLog references, PropertyId sourceId, NodeReferencesId refsId) throws NoSuchItemStateException, ItemStateException {
        NodeReferences refs = references.get(refsId);
        if (refs == null) {
            refs = this.virtualProvider.getNodeReferences(refsId);
        }
        if (refs == null && this.virtualProvider.hasItemState(refsId.getTargetId())) {
            refs = new NodeReferences(refsId);
        }
        if (refs != null) {
            refs.addReference(sourceId);
            references.modified(refs);
        }
    }

    private void removeVirtualReference(ChangeLog references, PropertyId sourceId, NodeReferencesId refsId) throws NoSuchItemStateException, ItemStateException {
        NodeReferences refs = references.get(refsId);
        if (refs == null) {
            refs = this.virtualProvider.getNodeReferences(refsId);
        }
        if (refs == null && this.virtualProvider.hasItemState(refsId.getTargetId())) {
            refs = new NodeReferences(refsId);
        }
        if (refs != null) {
            refs.removeReference(sourceId);
            references.modified(refs);
        }
    }

    public void stateModified(ItemState modified) {
        ChangeLog changeLog = (ChangeLog)this.commitLogs.get(Thread.currentThread());
        if (changeLog != null && modified.getContainer() != this) {
            try {
                ItemState local = changeLog.get(modified.getId());
                if (local != null && local.isConnected()) {
                    local.pull();
                }
            }
            catch (NoSuchItemStateException e) {
                log.warn("Modified state marked for deletion: " + modified.getId());
            }
        }
        super.stateModified(modified);
    }
}

