/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization;

import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.api.jsr283.security.AccessControlException;
import org.apache.jackrabbit.api.jsr283.security.Privilege;
import org.apache.jackrabbit.core.security.authorization.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.core.security.authorization.PrivilegeRegistry;
import org.apache.jackrabbit.value.StringValue;
import org.apache.jackrabbit.value.ValueHelper;

public abstract class AccessControlEntryImpl
implements JackrabbitAccessControlEntry {
    private final Privilege[] privileges;
    private final int privilegeBits;
    private final Principal principal;
    private final boolean allow;
    private final Map restrictions;
    private final ValueFactory valueFactory;
    private int hashCode = -1;

    protected AccessControlEntryImpl(Principal principal, Privilege[] privileges) throws AccessControlException {
        this(principal, privileges, true, null, null);
    }

    protected AccessControlEntryImpl(Principal principal, Privilege[] privileges, boolean isAllow, Map restrictions, ValueFactory valueFactory) throws AccessControlException {
        if (principal == null) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < privileges.length; ++i) {
            if (!privileges[i].isAbstract()) continue;
            throw new AccessControlException("Privilege " + privileges[i] + " is abstract.");
        }
        this.principal = principal;
        this.privileges = privileges;
        this.privilegeBits = PrivilegeRegistry.getBits(privileges);
        this.allow = isAllow;
        this.valueFactory = valueFactory;
        if (restrictions == null) {
            this.restrictions = Collections.EMPTY_MAP;
        } else {
            this.restrictions = new HashMap(restrictions.size());
            Iterator it = restrictions.keySet().iterator();
            while (it.hasNext()) {
                Object key = it.next();
                Object v = restrictions.get(key);
                Value value = v instanceof Value ? ValueHelper.copy((Value)v, valueFactory) : new StringValue(v.toString());
                this.restrictions.put(key.toString(), value);
            }
        }
    }

    public int getPrivilegeBits() {
        return this.privilegeBits;
    }

    protected int buildHashCode() {
        int h = 17;
        h = 37 * h + this.principal.getName().hashCode();
        h = 37 * h + this.privilegeBits;
        h = 37 * h + Boolean.valueOf(this.allow).hashCode();
        h = 37 * h + ((Object)this.restrictions).hashCode();
        return h;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public Privilege[] getPrivileges() {
        return this.privileges;
    }

    public boolean isAllow() {
        return this.allow;
    }

    public String[] getRestrictionNames() {
        return this.restrictions.keySet().toArray(new String[this.restrictions.size()]);
    }

    public Value getRestriction(String restrictionName) {
        if (this.restrictions.containsKey(restrictionName)) {
            return ValueHelper.copy((Value)this.restrictions.get(restrictionName), this.valueFactory);
        }
        return null;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = this.buildHashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AccessControlEntryImpl) {
            AccessControlEntryImpl tmpl = (AccessControlEntryImpl)obj;
            return this.principal.getName().equals(tmpl.principal.getName()) && this.privilegeBits == tmpl.privilegeBits && this.allow == tmpl.allow && ((Object)this.restrictions).equals(tmpl.restrictions);
        }
        return false;
    }
}

