/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.http.annotation.NotThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class URICollection
implements Iterable<URI> {
    private final Set<URI> unique = new HashSet<URI>();
    private final List<URI> all = new ArrayList<URI>();

    public boolean contains(URI uri) {
        return this.unique.contains(uri);
    }

    public void add(URI uri) {
        this.unique.add(uri);
        this.all.add(uri);
    }

    public boolean remove(URI uri) {
        boolean removed = this.unique.remove(uri);
        if (removed) {
            Iterator<URI> it = this.all.iterator();
            while (it.hasNext()) {
                URI current = it.next();
                if (!current.equals(uri)) continue;
                it.remove();
            }
        }
        return removed;
    }

    public List<URI> getAll() {
        return new ArrayList<URI>(this.all);
    }

    public Set<URI> getUnique() {
        return new HashSet<URI>(this.unique);
    }

    @Override
    public Iterator<URI> iterator() {
        return this.getAll().iterator();
    }

    public int getCount() {
        return this.all.size();
    }

    public boolean isEmpty() {
        return this.all.isEmpty();
    }

    public void clear() {
        this.all.clear();
        this.unique.clear();
    }
}

