/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.io.File;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class FairSchedulerConfiguration
extends Configuration {
    public static final Log LOG = LogFactory.getLog((String)FairSchedulerConfiguration.class.getName());
    public static final String RM_SCHEDULER_INCREMENT_ALLOCATION_MB = "yarn.scheduler.increment-allocation-mb";
    public static final int DEFAULT_RM_SCHEDULER_INCREMENT_ALLOCATION_MB = 1024;
    public static final String RM_SCHEDULER_INCREMENT_ALLOCATION_VCORES = "yarn.scheduler.increment-allocation-vcores";
    public static final int DEFAULT_RM_SCHEDULER_INCREMENT_ALLOCATION_VCORES = 1;
    private static final String CONF_PREFIX = "yarn.scheduler.fair.";
    protected static final String ALLOCATION_FILE = "yarn.scheduler.fair.allocation.file";
    protected static final String DEFAULT_ALLOCATION_FILE = "fair-scheduler.xml";
    protected static final String EVENT_LOG_DIR = "eventlog.dir";
    protected static final String ALLOW_UNDECLARED_POOLS = "yarn.scheduler.fair.allow-undeclared-pools";
    protected static final boolean DEFAULT_ALLOW_UNDECLARED_POOLS = true;
    protected static final String USER_AS_DEFAULT_QUEUE = "yarn.scheduler.fair.user-as-default-queue";
    protected static final boolean DEFAULT_USER_AS_DEFAULT_QUEUE = true;
    protected static final float DEFAULT_LOCALITY_THRESHOLD = -1.0f;
    protected static final String LOCALITY_THRESHOLD_NODE = "yarn.scheduler.fair.locality.threshold.node";
    protected static final float DEFAULT_LOCALITY_THRESHOLD_NODE = -1.0f;
    protected static final String LOCALITY_THRESHOLD_RACK = "yarn.scheduler.fair.locality.threshold.rack";
    protected static final float DEFAULT_LOCALITY_THRESHOLD_RACK = -1.0f;
    protected static final String PREEMPTION = "yarn.scheduler.fair.preemption";
    protected static final boolean DEFAULT_PREEMPTION = false;
    protected static final String PREEMPTION_INTERVAL = "yarn.scheduler.fair.preemptionInterval";
    protected static final int DEFAULT_PREEMPTION_INTERVAL = 5000;
    protected static final String WAIT_TIME_BEFORE_KILL = "yarn.scheduler.fair.waitTimeBeforeKill";
    protected static final int DEFAULT_WAIT_TIME_BEFORE_KILL = 15000;
    protected static final String ASSIGN_MULTIPLE = "yarn.scheduler.fair.assignmultiple";
    protected static final boolean DEFAULT_ASSIGN_MULTIPLE = false;
    protected static final String SIZE_BASED_WEIGHT = "yarn.scheduler.fair.sizebasedweight";
    protected static final boolean DEFAULT_SIZE_BASED_WEIGHT = false;
    protected static final String MAX_ASSIGN = "yarn.scheduler.fair.max.assign";
    protected static final int DEFAULT_MAX_ASSIGN = -1;

    public FairSchedulerConfiguration(Configuration conf) {
        super(conf);
    }

    public Resource getMinimumAllocation() {
        int mem = this.getInt("yarn.scheduler.minimum-allocation-mb", 1024);
        int cpu = this.getInt("yarn.scheduler.minimum-allocation-vcores", 1);
        return Resources.createResource((int)mem, (int)cpu);
    }

    public Resource getMaximumAllocation() {
        int mem = this.getInt("yarn.scheduler.maximum-allocation-mb", 8192);
        int cpu = this.getInt("yarn.scheduler.maximum-allocation-vcores", 4);
        return Resources.createResource((int)mem, (int)cpu);
    }

    public Resource getIncrementAllocation() {
        int incrementMemory = this.getInt(RM_SCHEDULER_INCREMENT_ALLOCATION_MB, 1024);
        int incrementCores = this.getInt(RM_SCHEDULER_INCREMENT_ALLOCATION_VCORES, 1);
        return Resources.createResource((int)incrementMemory, (int)incrementCores);
    }

    public boolean getAllowUndeclaredPools() {
        return this.getBoolean(ALLOW_UNDECLARED_POOLS, true);
    }

    public boolean getUserAsDefaultQueue() {
        return this.getBoolean(USER_AS_DEFAULT_QUEUE, true);
    }

    public float getLocalityThresholdNode() {
        return this.getFloat(LOCALITY_THRESHOLD_NODE, -1.0f);
    }

    public float getLocalityThresholdRack() {
        return this.getFloat(LOCALITY_THRESHOLD_RACK, -1.0f);
    }

    public boolean getPreemptionEnabled() {
        return this.getBoolean(PREEMPTION, false);
    }

    public boolean getAssignMultiple() {
        return this.getBoolean(ASSIGN_MULTIPLE, false);
    }

    public int getMaxAssign() {
        return this.getInt(MAX_ASSIGN, -1);
    }

    public boolean getSizeBasedWeight() {
        return this.getBoolean(SIZE_BASED_WEIGHT, false);
    }

    public File getAllocationFile() {
        String allocFilePath = this.get(ALLOCATION_FILE, DEFAULT_ALLOCATION_FILE);
        File allocFile = new File(allocFilePath);
        if (!allocFile.isAbsolute()) {
            URL url = Thread.currentThread().getContextClassLoader().getResource(allocFilePath);
            if (url == null) {
                LOG.warn((Object)(allocFilePath + " not found on the classpath."));
                allocFile = null;
            } else {
                if (!url.getProtocol().equalsIgnoreCase("file")) {
                    throw new RuntimeException("Allocation file " + url + " found on the classpath is not on the local filesystem.");
                }
                allocFile = new File(url.getPath());
            }
        }
        return allocFile;
    }

    public String getEventlogDir() {
        return this.get(EVENT_LOG_DIR, new File(System.getProperty("hadoop.log.dir", "/tmp/")).getAbsolutePath() + File.separator + "fairscheduler");
    }

    public int getPreemptionInterval() {
        return this.getInt(PREEMPTION_INTERVAL, 5000);
    }

    public int getWaitTimeBeforeKill() {
        return this.getInt(WAIT_TIME_BEFORE_KILL, 15000);
    }

    public boolean getUsePortForNodeName() {
        return this.getBoolean("yarn.scheduler.include-port-in-node-name", false);
    }

    public static Resource parseResourceConfigValue(String val) throws AllocationConfigurationException {
        try {
            int memory = FairSchedulerConfiguration.findResource(val, "mb");
            int vcores = FairSchedulerConfiguration.findResource(val, "vcores");
            return BuilderUtils.newResource((int)memory, (int)vcores);
        }
        catch (AllocationConfigurationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new AllocationConfigurationException("Error reading resource config", ex);
        }
    }

    private static int findResource(String val, String units) throws AllocationConfigurationException {
        Pattern pattern = Pattern.compile("(\\d+) ?" + units);
        Matcher matcher = pattern.matcher(val);
        if (!matcher.find()) {
            throw new AllocationConfigurationException("Missing resource: " + units);
        }
        return Integer.parseInt(matcher.group(1));
    }
}

