/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.search.controls;

import javax.naming.InvalidNameException;
import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IAction;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.util.IntegerDecoder;
import org.apache.directory.shared.asn1.util.IntegerDecoderException;
import org.apache.directory.shared.ldap.codec.search.controls.ChangeType;
import org.apache.directory.shared.ldap.codec.search.controls.EntryChangeControl;
import org.apache.directory.shared.ldap.codec.search.controls.EntryChangeControlContainer;
import org.apache.directory.shared.ldap.codec.search.controls.EntryChangeControlStatesEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryChangeControlGrammar
extends AbstractGrammar
implements IGrammar {
    private static final Logger log = LoggerFactory.getLogger((Class)EntryChangeControlGrammar.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    private static IGrammar instance = new EntryChangeControlGrammar();

    private EntryChangeControlGrammar() {
        this.name = EntryChangeControlGrammar.class.getName();
        this.statesEnum = EntryChangeControlStatesEnum.getInstance();
        this.transitions = new GrammarTransition[EntryChangeControlStatesEnum.LAST_EC_STATE][256];
        this.transitions[EntryChangeControlStatesEnum.START_STATE][48] = new GrammarTransition(EntryChangeControlStatesEnum.START_STATE, EntryChangeControlStatesEnum.EC_SEQUENCE_STATE, 48, (IAction)new GrammarAction("Init EntryChangeControl"){

            public void action(IAsn1Container container) {
                EntryChangeControlContainer entryChangeContainer = (EntryChangeControlContainer)container;
                EntryChangeControl control = new EntryChangeControl();
                entryChangeContainer.setEntryChangeControl(control);
            }
        });
        this.transitions[EntryChangeControlStatesEnum.EC_SEQUENCE_STATE][10] = new GrammarTransition(EntryChangeControlStatesEnum.EC_SEQUENCE_STATE, EntryChangeControlStatesEnum.CHANGE_TYPE_STATE, 10, (IAction)new GrammarAction("Set EntryChangeControl changeType"){

            public void action(IAsn1Container container) throws DecoderException {
                EntryChangeControlContainer entryChangeContainer = (EntryChangeControlContainer)container;
                Value value = entryChangeContainer.getCurrentTLV().getValue();
                try {
                    int change = IntegerDecoder.parse((Value)value, (int)1, (int)8);
                    switch (change) {
                        case 1: 
                        case 2: 
                        case 4: 
                        case 8: {
                            ChangeType changeType = ChangeType.getChangeType(change);
                            if (IS_DEBUG) {
                                log.debug("changeType = " + changeType);
                            }
                            entryChangeContainer.getEntryChangeControl().setChangeType(changeType);
                            break;
                        }
                        default: {
                            String msg = "failed to decode the changeType for EntryChangeControl";
                            log.error(msg);
                            throw new DecoderException(msg);
                        }
                    }
                    entryChangeContainer.grammarEndAllowed(true);
                }
                catch (IntegerDecoderException e) {
                    String msg = "failed to decode the changeType for EntryChangeControl";
                    log.error(msg, (Throwable)e);
                    throw new DecoderException(msg);
                }
            }
        });
        this.transitions[EntryChangeControlStatesEnum.CHANGE_TYPE_STATE][4] = new GrammarTransition(EntryChangeControlStatesEnum.CHANGE_TYPE_STATE, EntryChangeControlStatesEnum.PREVIOUS_DN_STATE, 4, (IAction)new GrammarAction("Set EntryChangeControl previousDN"){

            public void action(IAsn1Container container) throws DecoderException {
                EntryChangeControlContainer entryChangeContainer = (EntryChangeControlContainer)container;
                ChangeType changeType = entryChangeContainer.getEntryChangeControl().getChangeType();
                if (changeType != ChangeType.MODDN) {
                    log.error("The previousDN field should not contain anything if the changeType is not MODDN");
                    throw new DecoderException("Previous DN is not allowed for this change type");
                }
                Value value = entryChangeContainer.getCurrentTLV().getValue();
                LdapDN previousDn = null;
                try {
                    previousDn = new LdapDN(StringTools.utf8ToString(value.getData()));
                }
                catch (InvalidNameException ine) {
                    log.error("Bad Previous DN : '" + StringTools.dumpBytes(value.getData()));
                    throw new DecoderException("failed to decode the previous DN");
                }
                if (IS_DEBUG) {
                    log.debug("previousDN = " + previousDn);
                }
                entryChangeContainer.getEntryChangeControl().setPreviousDn(previousDn);
                entryChangeContainer.grammarEndAllowed(true);
            }
        });
        GrammarAction setChangeNumberAction = new GrammarAction("Set EntryChangeControl changeNumber"){

            public void action(IAsn1Container container) throws DecoderException {
                EntryChangeControlContainer entryChangeContainer = (EntryChangeControlContainer)container;
                Value value = entryChangeContainer.getCurrentTLV().getValue();
                try {
                    int changeNumber = IntegerDecoder.parse((Value)value);
                    if (IS_DEBUG) {
                        log.debug("changeNumber = " + changeNumber);
                    }
                    entryChangeContainer.getEntryChangeControl().setChangeNumber(changeNumber);
                    entryChangeContainer.grammarEndAllowed(true);
                }
                catch (IntegerDecoderException e) {
                    String msg = "failed to decode the changeNumber for EntryChangeControl";
                    log.error(msg, (Throwable)e);
                    throw new DecoderException(msg);
                }
            }
        };
        this.transitions[EntryChangeControlStatesEnum.PREVIOUS_DN_STATE][2] = new GrammarTransition(EntryChangeControlStatesEnum.PREVIOUS_DN_STATE, EntryChangeControlStatesEnum.CHANGE_NUMBER_STATE, 2, (IAction)setChangeNumberAction);
        this.transitions[EntryChangeControlStatesEnum.CHANGE_TYPE_STATE][2] = new GrammarTransition(EntryChangeControlStatesEnum.CHANGE_TYPE_STATE, EntryChangeControlStatesEnum.CHANGE_NUMBER_STATE, 2, (IAction)setChangeNumberAction);
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

