/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.name;

import antlr.LLkParser;
import antlr.NoViableAltException;
import antlr.ParserSharedInputState;
import antlr.RecognitionException;
import antlr.SemanticException;
import antlr.Token;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.collections.impl.BitSet;
import java.util.List;
import javax.naming.InvalidNameException;
import org.apache.directory.shared.ldap.entry.client.ClientBinaryValue;
import org.apache.directory.shared.ldap.entry.client.ClientStringValue;
import org.apache.directory.shared.ldap.name.AVA;
import org.apache.directory.shared.ldap.name.AntlrDnTokenTypes;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.name.RDN;
import org.apache.directory.shared.ldap.schema.parsers.ParserMonitor;
import org.apache.directory.shared.ldap.util.ByteBuffer;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntlrDnParser
extends LLkParser
implements AntlrDnTokenTypes {
    private ParserMonitor monitor = null;
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "COMMA", "EQUALS", "PLUS", "HYPHEN", "DQUOTE", "SEMI", "LANGLE", "RANGLE", "SPACE", "NUMERICOID_OR_ALPHA_OR_DIGIT", "NUMERICOID", "DOT", "NUMBER", "LDIGIT", "DIGIT", "ALPHA", "HEXPAIR_OR_ESCESC_ESCSHARP_OR_ESC", "HEXPAIR", "ESC", "ESCESC", "ESCSHARP", "HEX", "HEXVALUE_OR_SHARP", "HEXVALUE", "SHARP", "UTFMB", "LUTF1_REST"};
    public static final BitSet _tokenSet_0 = new BitSet(AntlrDnParser.mk_tokenSet_0());

    public void setParserMonitor(ParserMonitor monitor) {
        this.monitor = monitor;
    }

    private void matchedProduction(String msg) {
        if (null != this.monitor) {
            this.monitor.matchedProduction(msg);
        }
    }

    protected AntlrDnParser(TokenBuffer tokenBuf, int k) {
        super(tokenBuf, k);
        this.tokenNames = _tokenNames;
    }

    public AntlrDnParser(TokenBuffer tokenBuf) {
        this(tokenBuf, 3);
    }

    protected AntlrDnParser(TokenStream lexer, int k) {
        super(lexer, k);
        this.tokenNames = _tokenNames;
    }

    public AntlrDnParser(TokenStream lexer) {
        this(lexer, 3);
    }

    public AntlrDnParser(ParserSharedInputState state) {
        super(state, 3);
        this.tokenNames = _tokenNames;
    }

    public final void distinguishedName(DN dn) throws RecognitionException, TokenStreamException {
        this.matchedProduction("distinguishedName()");
        RDN rdn = null;
        switch (this.LA(1)) {
            case 12: 
            case 14: 
            case 19: {
                rdn = this.relativeDistinguishedName(new RDN());
                dn.add(rdn);
                rdn = null;
                while (this.LA(1) == 4 || this.LA(1) == 9) {
                    switch (this.LA(1)) {
                        case 4: {
                            this.match(4);
                            break;
                        }
                        case 9: {
                            this.match(9);
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    rdn = this.relativeDistinguishedName(new RDN());
                    dn.add(rdn);
                    rdn = null;
                }
                this.match(1);
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final RDN relativeDistinguishedName(RDN initialRdn) throws RecognitionException, TokenStreamException {
        this.matchedProduction("relativeDistinguishedName()");
        RDN rdn = initialRdn;
        String upName = "";
        String tmp = this.attributeTypeAndValue(rdn);
        upName = upName + tmp;
        while (this.LA(1) == 6) {
            this.match(6);
            upName = upName + "+";
            tmp = this.attributeTypeAndValue(rdn);
            upName = upName + tmp;
        }
        rdn.normalize();
        rdn.setUpName(upName);
        return rdn;
    }

    public final void relativeDistinguishedNames(List<RDN> rdns) throws RecognitionException, TokenStreamException {
        this.matchedProduction("relativeDistinguishedNames()");
        RDN rdn = null;
        switch (this.LA(1)) {
            case 12: 
            case 14: 
            case 19: {
                rdn = this.relativeDistinguishedName(new RDN());
                rdns.add(rdn);
                while (this.LA(1) == 4 || this.LA(1) == 9) {
                    switch (this.LA(1)) {
                        case 4: {
                            this.match(4);
                            break;
                        }
                        case 9: {
                            this.match(9);
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    rdn = this.relativeDistinguishedName(new RDN());
                    rdns.add(rdn);
                }
                this.match(1);
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final String attributeTypeAndValue(RDN rdn) throws RecognitionException, TokenStreamException {
        String upName = "";
        this.matchedProduction("attributeTypeAndValue()");
        String type = null;
        UpAndNormValue value = new UpAndNormValue();
        while (this.LA(1) == 12) {
            this.match(12);
            upName = upName + " ";
        }
        type = this.attributeType();
        upName = upName + type;
        while (this.LA(1) == 12) {
            this.match(12);
            upName = upName + " ";
        }
        this.match(5);
        upName = upName + "=";
        while (this.LA(1) == 12) {
            this.match(12);
            upName = upName + " ";
        }
        this.attributeValue(value);
        try {
            upName = upName + value.rawValue;
            AVA ava = null;
            ava = value.value instanceof String ? new AVA(type, type, new ClientStringValue((String)value.value), new ClientStringValue((String)value.value), upName) : new AVA(type, type, new ClientBinaryValue((byte[])value.value), new ClientBinaryValue((byte[])value.value), upName);
            rdn.addAttributeTypeAndValue(ava);
        }
        catch (InvalidNameException e) {
            throw new SemanticException(e.getMessage());
        }
        return upName;
    }

    public final String attributeType() throws RecognitionException, TokenStreamException {
        String attributeType;
        this.matchedProduction("attributeType()");
        switch (this.LA(1)) {
            case 19: {
                attributeType = this.descr();
                break;
            }
            case 14: {
                attributeType = this.numericoid();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return attributeType;
    }

    public final void attributeValue(UpAndNormValue value) throws RecognitionException, TokenStreamException {
        this.matchedProduction("attributeValue()");
        switch (this.LA(1)) {
            case 8: {
                this.quotestring(value);
                while (this.LA(1) == 12) {
                    this.match(12);
                    value.rawValue = value.rawValue + " ";
                }
                break;
            }
            case 5: 
            case 7: 
            case 14: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 29: 
            case 30: {
                this.string(value);
                break;
            }
            case 27: {
                this.hexstring(value);
                while (this.LA(1) == 12) {
                    this.match(12);
                    value.rawValue = value.rawValue + " ";
                }
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final String descr() throws RecognitionException, TokenStreamException {
        Token leadkeychar = null;
        Token alpha = null;
        Token digit = null;
        Token hyphen = null;
        this.matchedProduction("descr()");
        leadkeychar = this.LT(1);
        this.match(19);
        String descr = leadkeychar.getText();
        block5: while (true) {
            switch (this.LA(1)) {
                case 19: {
                    alpha = this.LT(1);
                    this.match(19);
                    descr = descr + alpha.getText();
                    continue block5;
                }
                case 18: {
                    digit = this.LT(1);
                    this.match(18);
                    descr = descr + digit.getText();
                    continue block5;
                }
                case 7: {
                    hyphen = this.LT(1);
                    this.match(7);
                    descr = descr + hyphen.getText();
                    continue block5;
                }
            }
            break;
        }
        return descr;
    }

    public final String numericoid() throws RecognitionException, TokenStreamException {
        String numericoid = "";
        Token noid = null;
        this.matchedProduction("numericoid()");
        noid = this.LT(1);
        this.match(14);
        numericoid = numericoid + noid.getText();
        return numericoid;
    }

    public final void quotestring(UpAndNormValue value) throws RecognitionException, TokenStreamException {
        Token dq1 = null;
        Token s = null;
        Token dq2 = null;
        this.matchedProduction("quotestring()");
        ByteBuffer bb = new ByteBuffer();
        dq1 = this.LT(1);
        this.match(8);
        value.rawValue = value.rawValue + dq1.getText();
        block4: while (true) {
            switch (this.LA(1)) {
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: {
                    s = this.LT(1);
                    this.match(_tokenSet_0);
                    value.rawValue = value.rawValue + s.getText();
                    bb.append(StringTools.getBytesUtf8(s.getText()));
                    continue block4;
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    byte[] bytes = this.pair(value);
                    bb.append(bytes);
                    continue block4;
                }
            }
            break;
        }
        dq2 = this.LT(1);
        this.match(8);
        value.rawValue = value.rawValue + dq2.getText();
        String string = StringTools.utf8ToString(bb.copyOfUsedBytes());
        value.value = string;
    }

    public final void string(UpAndNormValue value) throws RecognitionException, TokenStreamException {
        byte[] bytes;
        String tmp;
        this.matchedProduction("string()");
        ByteBuffer bb = new ByteBuffer();
        switch (this.LA(1)) {
            case 5: 
            case 7: 
            case 14: 
            case 18: 
            case 19: 
            case 30: {
                tmp = this.lutf1();
                value.rawValue = value.rawValue + tmp;
                bb.append(StringTools.getBytesUtf8(tmp));
                break;
            }
            case 29: {
                tmp = this.utfmb();
                value.rawValue = value.rawValue + tmp;
                bb.append(StringTools.getBytesUtf8(tmp));
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                bytes = this.pair(value);
                bb.append(bytes);
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        block10: while (true) {
            switch (this.LA(1)) {
                case 5: 
                case 7: 
                case 12: 
                case 14: 
                case 18: 
                case 19: 
                case 28: 
                case 30: {
                    tmp = this.sutf1();
                    value.rawValue = value.rawValue + tmp;
                    bb.append(StringTools.getBytesUtf8(tmp));
                    continue block10;
                }
                case 29: {
                    tmp = this.utfmb();
                    value.rawValue = value.rawValue + tmp;
                    bb.append(StringTools.getBytesUtf8(tmp));
                    continue block10;
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    bytes = this.pair(value);
                    bb.append(bytes);
                    continue block10;
                }
            }
            break;
        }
        String string = StringTools.utf8ToString(bb.copyOfUsedBytes());
        for (int rawIndex = value.rawValue.length(); string.length() > 0 && rawIndex > 1 && value.rawValue.charAt(rawIndex - 1) == ' ' && value.rawValue.charAt(rawIndex - 2) != '\\'; --rawIndex) {
            string = string.substring(0, string.length() - 1);
        }
        value.value = string;
    }

    public final void hexstring(UpAndNormValue value) throws RecognitionException, TokenStreamException {
        Token hexValue = null;
        this.matchedProduction("hexstring()");
        hexValue = this.LT(1);
        this.match(27);
        value.rawValue = "#" + hexValue.getText();
        value.value = StringTools.toByteArray(hexValue.getText());
    }

    public final byte[] pair(UpAndNormValue value) throws RecognitionException, TokenStreamException {
        byte[] pair;
        Token hexpair = null;
        this.matchedProduction("pair()");
        switch (this.LA(1)) {
            case 23: {
                this.match(23);
                value.rawValue = value.rawValue + "\\\\";
                pair = StringTools.getBytesUtf8("\\");
                break;
            }
            case 24: {
                this.match(24);
                value.rawValue = value.rawValue + "\\#";
                pair = StringTools.getBytesUtf8("#");
                break;
            }
            case 22: {
                this.match(22);
                String tmp = this.special();
                value.rawValue = value.rawValue + "\\" + tmp;
                pair = StringTools.getBytesUtf8(tmp);
                break;
            }
            case 21: {
                hexpair = this.LT(1);
                this.match(21);
                value.rawValue = value.rawValue + "\\" + hexpair.getText();
                pair = StringTools.toByteArray(hexpair.getText());
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return pair;
    }

    public final String lutf1() throws RecognitionException, TokenStreamException {
        String lutf1 = "";
        Token rest = null;
        Token equals = null;
        Token hyphen = null;
        Token digit = null;
        Token alpha = null;
        Token numericoid = null;
        this.matchedProduction("lutf1()");
        switch (this.LA(1)) {
            case 30: {
                rest = this.LT(1);
                this.match(30);
                lutf1 = rest.getText();
                break;
            }
            case 5: {
                equals = this.LT(1);
                this.match(5);
                lutf1 = equals.getText();
                break;
            }
            case 7: {
                hyphen = this.LT(1);
                this.match(7);
                lutf1 = hyphen.getText();
                break;
            }
            case 18: {
                digit = this.LT(1);
                this.match(18);
                lutf1 = digit.getText();
                break;
            }
            case 19: {
                alpha = this.LT(1);
                this.match(19);
                lutf1 = alpha.getText();
                break;
            }
            case 14: {
                numericoid = this.LT(1);
                this.match(14);
                lutf1 = numericoid.getText();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return lutf1;
    }

    public final String utfmb() throws RecognitionException, TokenStreamException {
        Token s = null;
        this.matchedProduction("utfmb()");
        s = this.LT(1);
        this.match(29);
        String utfmb = s.getText();
        return utfmb;
    }

    public final String sutf1() throws RecognitionException, TokenStreamException {
        String sutf1 = "";
        Token rest = null;
        Token equals = null;
        Token hyphen = null;
        Token digit = null;
        Token alpha = null;
        Token sharp = null;
        Token space = null;
        Token numericoid = null;
        this.matchedProduction("sutf1()");
        switch (this.LA(1)) {
            case 30: {
                rest = this.LT(1);
                this.match(30);
                sutf1 = rest.getText();
                break;
            }
            case 5: {
                equals = this.LT(1);
                this.match(5);
                sutf1 = equals.getText();
                break;
            }
            case 7: {
                hyphen = this.LT(1);
                this.match(7);
                sutf1 = hyphen.getText();
                break;
            }
            case 18: {
                digit = this.LT(1);
                this.match(18);
                sutf1 = digit.getText();
                break;
            }
            case 19: {
                alpha = this.LT(1);
                this.match(19);
                sutf1 = alpha.getText();
                break;
            }
            case 28: {
                sharp = this.LT(1);
                this.match(28);
                sutf1 = sharp.getText();
                break;
            }
            case 12: {
                space = this.LT(1);
                this.match(12);
                sutf1 = space.getText();
                break;
            }
            case 14: {
                numericoid = this.LT(1);
                this.match(14);
                sutf1 = numericoid.getText();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return sutf1;
    }

    public final String special() throws RecognitionException, TokenStreamException {
        String special;
        Token dquote = null;
        Token plus = null;
        Token comma = null;
        Token semi = null;
        Token langle = null;
        Token rangle = null;
        Token space = null;
        Token sharp = null;
        Token equals = null;
        this.matchedProduction("special()");
        switch (this.LA(1)) {
            case 8: {
                dquote = this.LT(1);
                this.match(8);
                special = dquote.getText();
                break;
            }
            case 6: {
                plus = this.LT(1);
                this.match(6);
                special = plus.getText();
                break;
            }
            case 4: {
                comma = this.LT(1);
                this.match(4);
                special = comma.getText();
                break;
            }
            case 9: {
                semi = this.LT(1);
                this.match(9);
                special = semi.getText();
                break;
            }
            case 10: {
                langle = this.LT(1);
                this.match(10);
                special = langle.getText();
                break;
            }
            case 11: {
                rangle = this.LT(1);
                this.match(11);
                special = rangle.getText();
                break;
            }
            case 12: {
                space = this.LT(1);
                this.match(12);
                special = space.getText();
                break;
            }
            case 28: {
                sharp = this.LT(1);
                this.match(28);
                special = sharp.getText();
                break;
            }
            case 5: {
                equals = this.LT(1);
                this.match(5);
                special = equals.getText();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return special;
    }

    private static final long[] mk_tokenSet_0() {
        long[] data = new long[]{2116026096L, 0L, 0L, 0L};
        return data;
    }

    static class UpAndNormValue {
        Object value = "";
        String rawValue = "";

        UpAndNormValue() {
        }
    }
}

