/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.comparators;

import java.text.ParseException;
import java.util.Comparator;
import org.apache.directory.shared.ldap.schema.parsers.AbstractSchemaDescription;
import org.apache.directory.shared.ldap.schema.parsers.SyntaxCheckerDescriptionSchemaParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntaxCheckerComparator
implements Comparator<String> {
    public static final Comparator<String> INSTANCE = new SyntaxCheckerComparator();
    private static final SyntaxCheckerDescriptionSchemaParser syntaxCheckerParser = new SyntaxCheckerDescriptionSchemaParser();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int compare(String s1, String s2) {
        if (s1 == null) {
            return s2 == null ? 0 : -1;
        }
        if (s2 == null) {
            return -1;
        }
        if (s1.equals(s2)) {
            return 0;
        }
        SyntaxCheckerDescriptionSchemaParser syntaxCheckerDescriptionSchemaParser = syntaxCheckerParser;
        synchronized (syntaxCheckerDescriptionSchemaParser) {
            AbstractSchemaDescription sc1 = null;
            AbstractSchemaDescription sc2 = null;
            try {
                sc1 = syntaxCheckerParser.parse(s1);
            }
            catch (ParseException pe) {
                return 1;
            }
            try {
                sc2 = syntaxCheckerParser.parse(s2);
            }
            catch (ParseException pe) {
                return 1;
            }
            return sc1.getNumericOid().compareTo(sc2.getNumericOid());
        }
    }
}

