/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.derby.client.ClientXid;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.SqlCode;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Utils;
import org.apache.derby.client.am.XaException;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetConnection;
import org.apache.derby.client.net.NetXACallInfo;
import org.apache.derby.client.net.NetXAConnection;

public class NetXAResource
implements XAResource {
    public static final int TMTIMEOUT = 256;
    public static final int ACTIVE_ONLY = -1;
    public static final int XA_NULL_XID = -1;
    public static final int INITIAL_CALLINFO_ELEMENTS = 1;
    public static final int RECOVER_XID_ARRAY_LENGTH = 10;
    public static final ClientXid nullXid = new ClientXid();
    public static final int XAFUNC_NONE = 0;
    public static final int XAFUNC_COMMIT = 1;
    public static final int XAFUNC_END = 2;
    public static final int XAFUNC_FORGET = 3;
    public static final int XAFUNC_PREPARE = 4;
    public static final int XAFUNC_RECOVER = 5;
    public static final int XAFUNC_ROLLBACK = 6;
    public static final int XAFUNC_START = 7;
    public static final String XAFUNCSTR_NONE = "No XA Function";
    public static final String XAFUNCSTR_COMMIT = "XAResource.commit()";
    public static final String XAFUNCSTR_END = "XAResource.end()";
    public static final String XAFUNCSTR_FORGET = "XAResource.forget()";
    public static final String XAFUNCSTR_PREPARE = "XAResource.prepare()";
    public static final String XAFUNCSTR_RECOVER = "XAResource.recover()";
    public static final String XAFUNCSTR_ROLLBACK = "XAResource.rollback()";
    public static final String XAFUNCSTR_START = "XAResource.start()";
    public SqlException exceptionsOnXA = null;
    XAConnection xaconn_;
    NetXAConnection netXAConn_;
    NetConnection conn_;
    private boolean keepIsolationLevel;
    int rmId_;
    NetXACallInfo[] callInfoArray_ = new NetXACallInfo[1];
    int numXACallInfo_ = 1;
    int connectionCount_ = 1;
    int activeXATransCount_ = 0;
    String rmIdx_;
    String rmIdy_;
    int port_;
    String ipaddr_;
    private List specialRegisters_ = Collections.synchronizedList(new LinkedList());
    private int timeoutSeconds = 0;

    public NetXAResource(XAConnection xAConnection, int n, String string, String string2, NetXAConnection netXAConnection) {
        this.xaconn_ = xAConnection;
        this.rmId_ = n;
        this.conn_ = netXAConnection.getNetConnection();
        this.netXAConn_ = netXAConnection;
        this.rmIdx_ = string;
        this.rmIdy_ = string2;
        this.port_ = this.conn_.netAgent_.getPort();
        this.ipaddr_ = this.conn_.netAgent_.socket_.getLocalAddress().getHostAddress();
        netXAConnection.setNetXAResource(this);
        this.conn_.currXACallInfoOffset_ = 0;
        for (int i = 0; i < 1; ++i) {
            this.callInfoArray_[i] = new NetXACallInfo(null, 0, this, null);
        }
        this.callInfoArray_[0].actualConn_ = netXAConnection;
        this.callInfoArray_[0].currConnection_ = true;
        this.callInfoArray_[0].freeEntry_ = false;
        this.callInfoArray_[0].saveConnectionVariables();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Xid xid, boolean bl) throws XAException {
        NetAgent netAgent = this.conn_.netAgent_;
        int n = 0;
        this.exceptionsOnXA = null;
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceEntry((Object)this, "commit", (Object)xid, bl);
        }
        if (this.conn_.isPhysicalConnClosed()) {
            this.connectionClosedFailure();
        }
        NetXACallInfo netXACallInfo = this.callInfoArray_[this.conn_.currXACallInfoOffset_];
        netXACallInfo.xaFlags_ = bl ? 0x40000000 : 0;
        netXACallInfo.xid_ = xid;
        netXACallInfo.xaResource_ = this;
        netXACallInfo.xaRetVal_ = 0;
        try {
            netAgent.beginWriteChainOutsideUOW();
            netAgent.netConnectionRequest_.writeXaCommit(this.conn_, xid);
            netAgent.flowOutsideUOW();
            netAgent.netConnectionReply_.readXaCommit(this.conn_);
            if (netXACallInfo.xaRetVal_ != 0) {
                netXACallInfo.xaFunction_ = 1;
                n = this.xaRetValErrorAccumSQL(netXACallInfo, n);
                netXACallInfo.xaRetVal_ = 0;
            }
            netAgent.endReadChain();
        }
        catch (SqlException sqlException) {
            n = this.getSqlExceptionXAErrorCode(sqlException);
            this.exceptionsOnXA = Utils.accumulateSQLException(sqlException, this.exceptionsOnXA);
        }
        finally {
            this.conn_.pendingEndXACallinfoOffset_ = -1;
        }
        if (n != 0) {
            this.throwXAException(n, false);
        }
    }

    private int getSqlExceptionXAErrorCode(SqlException sqlException) {
        int n = sqlException.getErrorCode();
        return n == 40000 ? -7 : -3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(Xid xid, int n) throws XAException {
        NetAgent netAgent = this.conn_.netAgent_;
        int n2 = 0;
        this.exceptionsOnXA = null;
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceEntry((Object)this, "end", (Object)xid, n);
        }
        if (this.conn_.isPhysicalConnClosed()) {
            this.connectionClosedFailure();
        }
        NetXACallInfo netXACallInfo = this.callInfoArray_[this.conn_.currXACallInfoOffset_];
        netXACallInfo.setReadOnlyTransactionFlag(this.conn_.readOnlyTransaction_);
        netXACallInfo.xaFlags_ = n;
        netXACallInfo.xid_ = xid;
        netXACallInfo.xaResource_ = this;
        netXACallInfo.xaRetVal_ = 0;
        try {
            netAgent.beginWriteChainOutsideUOW();
            netAgent.netConnectionRequest_.writeXaEndUnitOfWork(this.conn_);
            netAgent.flowOutsideUOW();
            n2 = netAgent.netConnectionReply_.readXaEndUnitOfWork(this.conn_);
            this.conn_.pendingEndXACallinfoOffset_ = -1;
            if (netXACallInfo.xaRetVal_ != 0) {
                netXACallInfo.xaFunction_ = 2;
                n2 = this.xaRetValErrorAccumSQL(netXACallInfo, n2);
                netXACallInfo.xaRetVal_ = 0;
            }
            netAgent.endReadChain();
        }
        catch (SqlException sqlException) {
            n2 = this.getSqlExceptionXAErrorCode(sqlException);
            this.exceptionsOnXA = Utils.accumulateSQLException(sqlException, this.exceptionsOnXA);
        }
        finally {
            this.conn_.pendingEndXACallinfoOffset_ = -1;
        }
        if (n2 != 0) {
            this.throwXAException(n2, false);
        } else {
            this.conn_.setXAState(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget(Xid xid) throws XAException {
        NetAgent netAgent = this.conn_.netAgent_;
        int n = 0;
        this.exceptionsOnXA = null;
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceEntry((Object)this, "forget", xid);
        }
        if (this.conn_.isPhysicalConnClosed()) {
            this.connectionClosedFailure();
        }
        NetXACallInfo netXACallInfo = this.callInfoArray_[this.conn_.currXACallInfoOffset_];
        netXACallInfo.xid_ = xid;
        netXACallInfo.xaResource_ = this;
        netXACallInfo.xaRetVal_ = 0;
        try {
            netAgent.beginWriteChainOutsideUOW();
            netAgent.netConnectionRequest_.writeXaForget(netAgent.netConnection_, xid);
            netAgent.flowOutsideUOW();
            netAgent.netConnectionReply_.readXaForget(netAgent.netConnection_);
            netAgent.endReadChain();
            if (netXACallInfo.xaRetVal_ != 0) {
                netXACallInfo.xaFunction_ = 3;
                n = this.xaRetValErrorAccumSQL(netXACallInfo, n);
                netXACallInfo.xaRetVal_ = 0;
            }
        }
        catch (SqlException sqlException) {
            this.exceptionsOnXA = Utils.accumulateSQLException(sqlException, this.exceptionsOnXA);
            this.throwXAException(this.getSqlExceptionXAErrorCode(sqlException));
        }
        finally {
            this.conn_.pendingEndXACallinfoOffset_ = -1;
        }
        if (n != 0) {
            this.throwXAException(n, false);
        }
    }

    public int getTransactionTimeout() throws XAException {
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceEntry(this, "getTransactionTimeout");
        }
        this.exceptionsOnXA = null;
        if (this.conn_.isPhysicalConnClosed()) {
            this.connectionClosedFailure();
        }
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceExit((Object)this, "getTransactionTimeout", this.timeoutSeconds);
        }
        return this.timeoutSeconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prepare(Xid xid) throws XAException {
        this.exceptionsOnXA = null;
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceEntry((Object)this, "prepare", xid);
        }
        if (this.conn_.isPhysicalConnClosed()) {
            this.connectionClosedFailure();
        }
        NetAgent netAgent = this.conn_.netAgent_;
        int n = 0;
        NetXACallInfo netXACallInfo = this.callInfoArray_[this.conn_.currXACallInfoOffset_];
        netXACallInfo.xid_ = xid;
        netXACallInfo.xaResource_ = this;
        netXACallInfo.xaRetVal_ = 0;
        try {
            netAgent.beginWriteChainOutsideUOW();
            netAgent.netConnectionRequest_.writeXaPrepare(this.conn_);
            netAgent.flowOutsideUOW();
            n = netAgent.netConnectionReply_.readXaPrepare(this.conn_);
            if (netXACallInfo.xaRetVal_ != 0 && netXACallInfo.xaRetVal_ != 3) {
                netXACallInfo.xaFunction_ = 4;
                n = this.xaRetValErrorAccumSQL(netXACallInfo, n);
                netXACallInfo.xaRetVal_ = 0;
            }
            netAgent.endReadChain();
        }
        catch (SqlException sqlException) {
            n = this.getSqlExceptionXAErrorCode(sqlException);
            this.exceptionsOnXA = Utils.accumulateSQLException(sqlException, this.exceptionsOnXA);
        }
        finally {
            this.conn_.pendingEndXACallinfoOffset_ = -1;
        }
        if (n != 0 && n != 3) {
            this.throwXAException(n, false);
        }
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceExit((Object)this, "prepare", n);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Xid[] recover(int n) throws XAException {
        int n2 = 0;
        NetAgent netAgent = this.conn_.netAgent_;
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceEntry((Object)this, "recover", n);
        }
        this.exceptionsOnXA = null;
        if (this.conn_.isPhysicalConnClosed()) {
            this.connectionClosedFailure();
        }
        Xid[] xidArray = null;
        int n3 = 0;
        NetXACallInfo netXACallInfo = this.callInfoArray_[this.conn_.currXACallInfoOffset_];
        netXACallInfo.xaFlags_ = n;
        netXACallInfo.xaResource_ = this;
        netXACallInfo.xaRetVal_ = 0;
        try {
            netAgent.beginWriteChainOutsideUOW();
            netAgent.netConnectionRequest_.writeXaRecover(this.conn_, n);
            netAgent.flowOutsideUOW();
            netAgent.netConnectionReply_.readXaRecover(this.conn_);
            if (netXACallInfo.xaRetVal_ != 0) {
                netXACallInfo.xaFunction_ = 5;
                n2 = this.xaRetValErrorAccumSQL(netXACallInfo, n2);
                netXACallInfo.xaRetVal_ = 0;
            }
            netAgent.endReadChain();
            if (this.conn_.indoubtTransactions_ != null) {
                n3 = this.conn_.indoubtTransactions_.size();
                xidArray = new Xid[n3];
                int n4 = 0;
                Enumeration enumeration = this.conn_.indoubtTransactions_.keys();
                while (enumeration.hasMoreElements()) {
                    xidArray[n4] = (Xid)enumeration.nextElement();
                    ++n4;
                }
            }
        }
        catch (SqlException sqlException) {
            n2 = this.getSqlExceptionXAErrorCode(sqlException);
            this.exceptionsOnXA = Utils.accumulateSQLException(sqlException, this.exceptionsOnXA);
        }
        finally {
            this.conn_.pendingEndXACallinfoOffset_ = -1;
        }
        if (n2 != 0) {
            this.throwXAException(n2, false);
        }
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceExit((Object)this, "recover", xidArray);
        }
        return xidArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Xid xid) throws XAException {
        NetAgent netAgent = this.conn_.netAgent_;
        int n = 0;
        this.exceptionsOnXA = null;
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceEntry((Object)this, "rollback", xid);
        }
        if (this.conn_.isPhysicalConnClosed()) {
            this.connectionClosedFailure();
        }
        NetXACallInfo netXACallInfo = this.callInfoArray_[this.conn_.currXACallInfoOffset_];
        netXACallInfo.xid_ = xid;
        netXACallInfo.xaResource_ = this;
        netXACallInfo.xaRetVal_ = 0;
        try {
            netAgent.beginWriteChainOutsideUOW();
            netAgent.netConnectionRequest_.writeXaRollback(this.conn_, xid);
            netAgent.flowOutsideUOW();
            n = netAgent.netConnectionReply_.readXaRollback(this.conn_);
            netAgent.endReadChain();
            if (netXACallInfo.xaRetVal_ != 0) {
                netXACallInfo.xaFunction_ = 2;
                n = this.xaRetValErrorAccumSQL(netXACallInfo, n);
                netXACallInfo.xaRetVal_ = 0;
            }
        }
        catch (SqlException sqlException) {
            n = this.getSqlExceptionXAErrorCode(sqlException);
            this.exceptionsOnXA = Utils.accumulateSQLException(sqlException, this.exceptionsOnXA);
        }
        finally {
            this.conn_.pendingEndXACallinfoOffset_ = -1;
        }
        if (n != 0) {
            this.throwXAException(n, false);
        }
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceEntry(this, "setTransactionTimeout");
        }
        if (n < 0) {
            throw new XAException(-5);
        }
        this.exceptionsOnXA = null;
        this.timeoutSeconds = n;
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceExit((Object)this, "setTransactionTimeout", true);
        }
        return true;
    }

    public void setKeepCurrentIsolationLevel(boolean bl) {
        this.keepIsolationLevel = bl;
    }

    public boolean keepCurrentIsolationLevel() {
        return this.keepIsolationLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(Xid xid, int n) throws XAException {
        NetAgent netAgent = this.conn_.netAgent_;
        int n2 = 0;
        this.exceptionsOnXA = null;
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceEntry((Object)this, "start", (Object)xid, n);
        }
        if (this.conn_.isPhysicalConnClosed()) {
            this.connectionClosedFailure();
        }
        try {
            if (this.conn_.autoCommit_) {
                this.conn_.flowAutoCommit();
            }
        }
        catch (SqlException sqlException) {
            n2 = this.getSqlExceptionXAErrorCode(sqlException);
            this.exceptionsOnXA = Utils.accumulateSQLException(sqlException, this.exceptionsOnXA);
        }
        NetXACallInfo netXACallInfo = this.callInfoArray_[this.conn_.currXACallInfoOffset_];
        netXACallInfo.xaFlags_ = n;
        netXACallInfo.xaInProgress_ = true;
        netXACallInfo.xid_ = xid;
        netXACallInfo.xaResource_ = this;
        netXACallInfo.xaRetVal_ = 0;
        if (n == 0) {
            if (this.timeoutSeconds == Integer.MAX_VALUE) {
                netXACallInfo.xaTimeoutMillis_ = 0L;
            } else if (this.timeoutSeconds > 0) {
                netXACallInfo.xaTimeoutMillis_ = 1000 * this.timeoutSeconds;
            } else if (this.timeoutSeconds == 0) {
                netXACallInfo.xaTimeoutMillis_ = -1L;
            } else {
                this.throwXAException(-3);
            }
        }
        try {
            netAgent.beginWriteChainOutsideUOW();
            netAgent.netConnectionRequest_.writeXaStartUnitOfWork(this.conn_);
            netAgent.flowOutsideUOW();
            netAgent.netConnectionReply_.readXaStartUnitOfWork(this.conn_);
            if (netXACallInfo.xaRetVal_ != 0) {
                netXACallInfo.xaFunction_ = 7;
                n2 = this.xaRetValErrorAccumSQL(netXACallInfo, n2);
                netXACallInfo.xaRetVal_ = 0;
            }
            if (n2 == 0) {
                this.conn_.setXAState(1);
            }
        }
        catch (SqlException sqlException) {
            n2 = this.getSqlExceptionXAErrorCode(sqlException);
            this.exceptionsOnXA = Utils.accumulateSQLException(sqlException, this.exceptionsOnXA);
        }
        finally {
            this.conn_.pendingEndXACallinfoOffset_ = -1;
        }
        if (n2 != 0) {
            this.throwXAException(n2, false);
        }
    }

    protected void throwXAException(int n) throws XAException {
        this.throwXAException(n, n != -4);
    }

    private String getXAExceptionText(int n) {
        String string;
        switch (n) {
            case 100: {
                string = "XA_RBROLLBACK";
                break;
            }
            case 101: {
                string = "XA_RBCOMMFAIL";
                break;
            }
            case 102: {
                string = "XA_RBDEADLOCK";
                break;
            }
            case 103: {
                string = "XA_RBINTEGRITY";
                break;
            }
            case 104: {
                string = "XA_RBOTHER";
                break;
            }
            case 105: {
                string = "XA_RBPROTO";
                break;
            }
            case 106: {
                string = "XA_RBTIMEOUT";
                break;
            }
            case 107: {
                string = "XA_RBTRANSIENT";
                break;
            }
            case 9: {
                string = "XA_NOMIGRATE";
                break;
            }
            case 8: {
                string = "XA_HEURHAZ";
                break;
            }
            case 7: {
                string = "XA_HEURCOM";
                break;
            }
            case 6: {
                string = "XA_HEURRB";
                break;
            }
            case 5: {
                string = "XA_HEURMIX";
                break;
            }
            case 4: {
                string = "XA_RETRY";
                break;
            }
            case 3: {
                string = "XA_RDONLY";
                break;
            }
            case -2: {
                string = "XAER_ASYNC";
                break;
            }
            case -3: {
                string = "XAER_RMERR";
                break;
            }
            case -4: {
                string = "XAER_NOTA";
                break;
            }
            case -5: {
                string = "XAER_INVAL";
                break;
            }
            case -6: {
                string = "XAER_PROTO";
                break;
            }
            case -7: {
                string = "XAER_RMFAIL";
                break;
            }
            case -8: {
                string = "XAER_DUPID";
                break;
            }
            case -9: {
                string = "XAER_OUTSIDE";
                break;
            }
            case 0: {
                string = "XA_OK";
                break;
            }
            default: {
                string = "Unknown Error";
            }
        }
        return string;
    }

    protected void throwXAException(int n, boolean bl) throws XAException {
        Object object;
        if (bl) {
            object = this.callInfoArray_[this.conn_.currXACallInfoOffset_];
            ((NetXACallInfo)object).xaInProgress_ = false;
            ((NetXACallInfo)object).xaWasSuspended = false;
        }
        String string = this.getXAExceptionText(n);
        object = this.exceptionsOnXA;
        while (this.exceptionsOnXA != null) {
            string = string + " : " + this.exceptionsOnXA.getMessage();
            this.exceptionsOnXA = this.exceptionsOnXA.getNextException();
        }
        XaException xaException = new XaException(this.conn_.agent_.logWriter_, (Throwable)object, string);
        xaException.errorCode = n;
        this.setXaStateForXAException(n);
        throw xaException;
    }

    private void setXaStateForXAException(int n) {
        switch (n) {
            case -7: 
            case -3: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                this.conn_.setXAState(0);
                break;
            }
            default: {
                return;
            }
        }
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        boolean bl = false;
        this.exceptionsOnXA = null;
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceEntry((Object)this, "isSameRM", xAResource);
        }
        if (this.conn_.isPhysicalConnClosed()) {
            this.connectionClosedFailure();
        }
        if (xAResource instanceof NetXAResource) {
            NetXAResource netXAResource = (NetXAResource)xAResource;
            if (this.conn_.databaseName_.equalsIgnoreCase(netXAResource.conn_.databaseName_)) {
                if (!this.conn_.netAgent_.server_.equalsIgnoreCase(netXAResource.conn_.netAgent_.server_)) {
                    try {
                        String string = this.processLocalHost(this.conn_.netAgent_.server_);
                        String string2 = this.processLocalHost(netXAResource.conn_.netAgent_.server_);
                        InetAddress inetAddress = InetAddress.getByName(string);
                        InetAddress inetAddress2 = InetAddress.getByName(string2);
                        if (!inetAddress.equals(inetAddress2)) {
                        }
                    }
                    catch (UnknownHostException unknownHostException) {}
                } else if (this.conn_.netAgent_.port_ == netXAResource.conn_.netAgent_.port_) {
                    bl = true;
                }
            }
        }
        if (this.conn_.agent_.loggingEnabled()) {
            this.conn_.agent_.logWriter_.traceExit((Object)this, "isSameRM", bl);
        }
        return bl;
    }

    public static boolean xidsEqual(Xid xid, Xid xid2) {
        int n;
        if (xid.getFormatId() != xid2.getFormatId()) {
            return false;
        }
        int n2 = xid.getGlobalTransactionId().length;
        if (n2 != xid2.getGlobalTransactionId().length) {
            return false;
        }
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid2.getGlobalTransactionId();
        for (n = 0; n < n2; ++n) {
            if (byArray[n] == byArray2[n]) continue;
            return false;
        }
        n2 = xid.getBranchQualifier().length;
        if (n2 != xid2.getBranchQualifier().length) {
            return false;
        }
        byArray = xid.getBranchQualifier();
        byArray2 = xid2.getBranchQualifier();
        for (n = 0; n < n2; ++n) {
            if (byArray[n] == byArray2[n]) continue;
            return false;
        }
        return true;
    }

    public List getSpecialRegisters() {
        return this.specialRegisters_;
    }

    public void addSpecialRegisters(String string) {
        if (string.substring(0, 1).equals("@")) {
            if (this.specialRegisters_.remove(string.substring(1))) {
                this.specialRegisters_.remove(string);
                this.specialRegisters_.add(string.substring(1));
            } else {
                this.specialRegisters_.remove(string);
                this.specialRegisters_.add(string);
            }
        } else {
            this.specialRegisters_.remove(string);
            this.specialRegisters_.add(string);
        }
    }

    private void connectionClosedFailure() throws XAException {
        this.exceptionsOnXA = Utils.accumulateSQLException(new SqlException(null, new ClientMessageId("08003")), this.exceptionsOnXA);
        this.throwXAException(-7);
    }

    private String getXAFuncStr(int n) {
        switch (n) {
            case 1: {
                return XAFUNCSTR_COMMIT;
            }
            case 2: {
                return XAFUNCSTR_END;
            }
            case 3: {
                return XAFUNCSTR_FORGET;
            }
            case 4: {
                return XAFUNCSTR_PREPARE;
            }
            case 5: {
                return XAFUNCSTR_RECOVER;
            }
            case 6: {
                return XAFUNCSTR_ROLLBACK;
            }
            case 7: {
                return XAFUNCSTR_START;
            }
        }
        return XAFUNCSTR_NONE;
    }

    protected int xaRetValErrorAccumSQL(NetXACallInfo netXACallInfo, int n) {
        int n2 = netXACallInfo.xaRetVal_;
        if (n2 != 0) {
            SqlException sqlException = new SqlException(this.conn_.netAgent_.logWriter_, new ClientMessageId("XN019.S"), (Object)this.getXAFuncStr(netXACallInfo.xaFunction_), (Object)this.getXAExceptionText(n2), SqlCode.queuedXAError);
            this.exceptionsOnXA = Utils.accumulateSQLException(sqlException, this.exceptionsOnXA);
            if (n != 0 && n < 0) {
                return n;
            }
        }
        return n2;
    }

    private String processLocalHost(String string) {
        if (string.equalsIgnoreCase("localhost")) {
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                String string2 = inetAddress.getHostName();
                return string2;
            }
            catch (SecurityException securityException) {
                return string;
            }
            catch (UnknownHostException unknownHostException) {
                return string;
            }
        }
        return string;
    }
}

