/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Utils;

public class ColumnMetaData
implements ResultSetMetaData {
    public int columns_;
    public boolean[] nullable_;
    public transient int[] singleMixedByteOrDouble_;
    public short sqldHold_;
    public short sqldReturn_;
    public short sqldScroll_;
    public short sqldSensitive_;
    public short sqldFcode_;
    public short sqldKeytype_;
    public String sqldRdbnam_;
    public String sqldSchema_;
    public int[] sqlPrecision_;
    public int[] sqlScale_;
    public long[] sqlLength_;
    public int[] sqlType_;
    public int[] sqlCcsid_;
    public String[] sqlName_;
    public String[] sqlLabel_;
    public short[] sqlUnnamed_;
    public String[] sqlComment_;
    public String[] sqlUDTname_;
    public String[] sqlUDTclassName_;
    public short[] sqlxKeymem_;
    public short[] sqlxGenerated_;
    public short[] sqlxParmmode_;
    public String[] sqlxCorname_;
    public String[] sqlxName_;
    public String[] sqlxBasename_;
    public int[] sqlxUpdatable_;
    public String[] sqlxSchema_;
    public String[] sqlxRdbnam_;
    public transient int[][] protocolTypesCache_ = null;
    public transient Hashtable protocolTypeToOverrideLidMapping_ = null;
    public transient ArrayList mddOverrideArray_ = null;
    public transient int[] types_;
    public transient int[] clientParamtertype_;
    public transient LogWriter logWriter_;
    public transient int resultSetConcurrency_;
    private transient Hashtable columnNameToIndexCache_ = null;
    private transient boolean statementClosed_ = false;

    void markClosed() {
        this.statementClosed_ = true;
        this.nullDataForGC();
    }

    void checkForClosedStatement() throws SqlException {
        if (this.statementClosed_) {
            throw new SqlException(this.logWriter_, new ClientMessageId("XCL31.S"));
        }
    }

    public ColumnMetaData(LogWriter logWriter) {
        this.logWriter_ = logWriter;
    }

    public ColumnMetaData(LogWriter logWriter, int n) {
        this.logWriter_ = logWriter;
        this.initializeCache(n);
    }

    public void initializeCache(int n) {
        this.columns_ = n;
        this.nullable_ = new boolean[n];
        this.types_ = new int[n];
        this.clientParamtertype_ = new int[n];
        this.singleMixedByteOrDouble_ = new int[n];
        this.sqlPrecision_ = new int[n];
        this.sqlScale_ = new int[n];
        this.sqlLength_ = new long[n];
        this.sqlType_ = new int[n];
        this.sqlCcsid_ = new int[n];
        this.sqlName_ = new String[n];
        this.sqlxParmmode_ = new short[n];
        this.sqlUDTname_ = new String[n];
        this.sqlUDTclassName_ = new String[n];
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public int getColumnCount() throws SQLException {
        try {
            this.checkForClosedStatement();
            return this.columns_;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(n);
            return this.sqlxGenerated_[n - 1] == 2;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(n);
            int n2 = this.types_[n - 1];
            return n2 == 1 || n2 == 12 || n2 == -1 || n2 == 2005;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public boolean isSearchable(int n) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(n);
            return true;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public boolean isCurrency(int n) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(n);
            return false;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public int isNullable(int n) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(n);
            if (this.nullable_[n - 1]) {
                return 1;
            }
            return 0;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public boolean isSigned(int n) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(n);
            int n2 = this.types_[n - 1];
            return n2 == 5 || n2 == 4 || n2 == -5 || n2 == 6 || n2 == 7 || n2 == 8 || n2 == 2 || n2 == 3;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(n);
            int n2 = this.types_[n - 1];
            switch (n2) {
                case 16: {
                    return 5;
                }
                case 4: {
                    return 11;
                }
                case 5: {
                    return 6;
                }
                case -5: {
                    return 20;
                }
                case 7: {
                    return 13;
                }
                case 6: 
                case 8: {
                    return 22;
                }
                case 2: 
                case 3: {
                    int n3 = this.getScale(n);
                    int n4 = this.getPrecision(n);
                    return n3 == 0 ? n4 + 1 : (n3 == n4 ? n4 + 3 : n4 + 2);
                }
                case -1: 
                case 1: 
                case 12: 
                case 2005: {
                    return (int)this.sqlLength_[n - 1];
                }
                case 91: {
                    return 10;
                }
                case 92: {
                    return 8;
                }
                case 93: {
                    return 26;
                }
                case 2000: {
                    return 15;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    int n5 = (int)(2L * this.sqlLength_[n - 1]);
                    if (n5 < 0) {
                        n5 = Integer.MAX_VALUE;
                    }
                    return n5;
                }
            }
            throw new SqlException(this.logWriter_, new ClientMessageId("XJ021.S"));
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public String getColumnLabel(int n) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(n);
            if (this.sqlLabel_ != null && this.sqlLabel_[n - 1] != null) {
                return this.sqlLabel_[n - 1];
            }
            if (this.sqlName_ == null || this.sqlName_[n - 1] == null) {
                this.assignColumnName(n);
            }
            return this.sqlName_[n - 1];
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public String getColumnName(int n) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(n);
            if (this.sqlName_ == null || this.sqlName_[n - 1] == null) {
                this.assignColumnName(n);
            }
            return this.sqlName_[n - 1];
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public String getSchemaName(int n) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(n);
            if (this.sqlxSchema_ == null || this.sqlxSchema_[n - 1] == null) {
                return "";
            }
            return this.sqlxSchema_[n - 1];
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public int getPrecision(int n) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(n);
            int n2 = this.types_[n - 1];
            switch (n2) {
                case 16: {
                    return 1;
                }
                case 2: 
                case 3: {
                    return this.sqlPrecision_[n - 1];
                }
                case 5: {
                    return 5;
                }
                case 4: {
                    return 10;
                }
                case -5: {
                    return 19;
                }
                case 6: {
                    return 15;
                }
                case 7: {
                    return 7;
                }
                case 8: {
                    return 15;
                }
                case -4: 
                case -3: 
                case -2: 
                case -1: 
                case 1: 
                case 12: 
                case 2004: 
                case 2005: {
                    return (int)this.sqlLength_[n - 1];
                }
                case 91: {
                    return 10;
                }
                case 92: {
                    return 8;
                }
                case 93: {
                    return 26;
                }
                case 2000: {
                    return 0;
                }
            }
            throw new SqlException(this.logWriter_, new ClientMessageId("XJ021.S"));
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public int getScale(int n) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(n);
            if (this.types_[n - 1] == 93) {
                return 6;
            }
            return this.sqlScale_[n - 1];
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public String getTableName(int n) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(n);
            if (this.sqlxBasename_ == null || this.sqlxBasename_[n - 1] == null) {
                return "";
            }
            return this.sqlxBasename_[n - 1];
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public String getCatalogName(int n) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(n);
            return "";
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public int getColumnType(int n) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(n);
            return this.types_[n - 1];
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public String getColumnTypeName(int n) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(n);
            int n2 = this.types_[n - 1];
            int n3 = this.sqlType_[n - 1];
            switch (n3) {
                case 2436: 
                case 2437: {
                    return "BOOLEAN";
                }
                case 384: 
                case 385: {
                    return "DATE";
                }
                case 388: 
                case 389: {
                    return "TIME";
                }
                case 392: 
                case 393: {
                    return "TIMESTAMP";
                }
                case 404: 
                case 405: {
                    return "BLOB";
                }
                case 408: 
                case 409: {
                    return "CLOB";
                }
                case 448: 
                case 449: {
                    if (n2 == -3) {
                        return "VARCHAR FOR BIT DATA";
                    }
                    return "VARCHAR";
                }
                case 452: 
                case 453: {
                    if (n2 == -2) {
                        return "CHAR FOR BIT DATA";
                    }
                    return "CHAR";
                }
                case 456: 
                case 457: {
                    if (n2 == -4) {
                        return "LONG VARCHAR FOR BIT DATA";
                    }
                    return "LONG VARCHAR";
                }
                case 460: 
                case 461: {
                    return "SBCS";
                }
                case 480: 
                case 481: {
                    if (n2 == 8) {
                        return "DOUBLE";
                    }
                    if (n2 == 7) {
                        return "REAL";
                    }
                }
                case 484: 
                case 485: {
                    return "DECIMAL";
                }
                case 492: 
                case 493: {
                    return "BIGINT";
                }
                case 496: 
                case 497: {
                    return "INTEGER";
                }
                case 500: 
                case 501: {
                    return "SMALLINT";
                }
                case 504: 
                case 505: {
                    return "NUMERIC";
                }
                case 2000: 
                case 2001: {
                    return this.sqlUDTname_[n - 1];
                }
            }
            throw new SqlException(this.logWriter_, new ClientMessageId("XJ021.S"));
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public boolean isReadOnly(int n) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(n);
            if (this.sqlxUpdatable_ == null) {
                return this.resultSetConcurrency_ == 1007;
            }
            return this.sqlxUpdatable_[n - 1] == 0;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public boolean isWritable(int n) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(n);
            if (this.sqlxUpdatable_ == null) {
                return this.resultSetConcurrency_ == 1008;
            }
            return this.sqlxUpdatable_[n - 1] == 1;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(n);
            if (this.sqlxUpdatable_ == null) {
                return false;
            }
            return this.sqlxUpdatable_[n - 1] == 1;
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public String getColumnClassName(int n) throws SQLException {
        try {
            this.checkForClosedStatement();
            this.checkForValidColumnIndex(n);
            int n2 = this.types_[n - 1];
            switch (n2) {
                case 16: {
                    return "java.lang.Boolean";
                }
                case -7: {
                    return "java.lang.Boolean";
                }
                case -6: {
                    return "java.lang.Integer";
                }
                case 5: {
                    return "java.lang.Integer";
                }
                case 4: {
                    return "java.lang.Integer";
                }
                case -5: {
                    return "java.lang.Long";
                }
                case 6: {
                    return "java.lang.Double";
                }
                case 7: {
                    return "java.lang.Float";
                }
                case 8: {
                    return "java.lang.Double";
                }
                case 2: 
                case 3: {
                    return "java.math.BigDecimal";
                }
                case -1: 
                case 1: 
                case 12: {
                    return "java.lang.String";
                }
                case 91: {
                    return "java.sql.Date";
                }
                case 92: {
                    return "java.sql.Time";
                }
                case 93: {
                    return "java.sql.Timestamp";
                }
                case -4: 
                case -3: 
                case -2: {
                    return "byte[]";
                }
                case 2002: {
                    return "java.sql.Struct";
                }
                case 2003: {
                    return "java.sql.Array";
                }
                case 2004: {
                    return "java.sql.Blob";
                }
                case 2005: {
                    return "java.sql.Clob";
                }
                case 2006: {
                    return "java.sql.Ref";
                }
                case 2000: {
                    return this.sqlUDTclassName_[n - 1];
                }
            }
            throw new SqlException(this.logWriter_, new ClientMessageId("XJ021.S"));
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    void checkForValidColumnIndex(int n) throws SqlException {
        if (n < 1 || n > this.columns_) {
            throw new SqlException(this.logWriter_, new ClientMessageId("XCL14.S"), (Object)new Integer(n), new Integer(this.columns_));
        }
    }

    private boolean isParameterModeGuessedAsAnInput(int n) {
        return this.sqlxParmmode_[n - 1] == 1 || this.sqlxParmmode_[n - 1] == 2;
    }

    public boolean isParameterModeGuessedAsOutput(int n) {
        return this.sqlxParmmode_[n - 1] >= 2;
    }

    private void setParmModeForInputParameter(int n) {
        if (this.sqlxParmmode_[n - 1] == 4) {
            this.sqlxParmmode_[n - 1] = 2;
        } else if (this.sqlxParmmode_[n - 1] == 0) {
            this.sqlxParmmode_[n - 1] = 1;
        }
    }

    private void setParmModeForOutputParameter(int n) {
        if (this.sqlxParmmode_[n - 1] == 1) {
            this.sqlxParmmode_[n - 1] = 2;
        } else if (this.sqlxParmmode_[n - 1] == 0) {
            this.sqlxParmmode_[n - 1] = 4;
        }
    }

    private boolean isCompatibleDriverTypes(int n, int n2) {
        switch (n) {
            case -1: 
            case 1: 
            case 12: {
                return n2 == 1 || n2 == 12 || n2 == -1;
            }
            case -4: 
            case -3: 
            case -2: {
                return n2 == -2 || n2 == -3 || n2 == -4;
            }
        }
        return n == n2;
    }

    private int getInternalTypeForGuessedOrRegisteredJdbcType(int n) throws SqlException {
        switch (n) {
            case 16: {
                return 16;
            }
            case -7: 
            case -6: 
            case 5: {
                return 5;
            }
            case 4: {
                return 4;
            }
            case -5: {
                return -5;
            }
            case 7: {
                return 7;
            }
            case 6: 
            case 8: {
                return 8;
            }
            case 2: 
            case 3: {
                return 3;
            }
            case 91: {
                return 91;
            }
            case 92: {
                return 92;
            }
            case 93: {
                return 93;
            }
            case 1: {
                return 1;
            }
            case 12: {
                return 12;
            }
            case -1: {
                return -1;
            }
            case -2: {
                return -2;
            }
            case -3: {
                return -3;
            }
            case -4: {
                return -4;
            }
            case 2004: {
                return 2004;
            }
            case 2005: {
                return 2005;
            }
            case 2000: {
                return 2000;
            }
            case 0: 
            case 1111: {
                throw new SqlException(this.logWriter_, new ClientMessageId("XJ021.S"));
            }
        }
        throw new SqlException(this.logWriter_, new ClientMessageId("XJ021.S"));
    }

    public void setLogWriter(LogWriter logWriter) {
        this.logWriter_ = logWriter;
    }

    private void nullDataForGC() {
        this.columns_ = 0;
        this.nullable_ = null;
        this.types_ = null;
        this.singleMixedByteOrDouble_ = null;
        this.sqldRdbnam_ = null;
        this.sqldSchema_ = null;
        this.sqlPrecision_ = null;
        this.sqlScale_ = null;
        this.sqlLength_ = null;
        this.sqlType_ = null;
        this.sqlCcsid_ = null;
        this.sqlName_ = null;
        this.sqlLabel_ = null;
        this.sqlUnnamed_ = null;
        this.sqlComment_ = null;
        this.sqlUDTname_ = null;
        this.sqlUDTclassName_ = null;
        this.sqlxKeymem_ = null;
        this.sqlxGenerated_ = null;
        this.sqlxParmmode_ = null;
        this.sqlxCorname_ = null;
        this.sqlxName_ = null;
        this.sqlxBasename_ = null;
        this.sqlxUpdatable_ = null;
        this.sqlxSchema_ = null;
        this.sqlxRdbnam_ = null;
        this.clientParamtertype_ = null;
        this.types_ = null;
    }

    public boolean hasLobColumns() {
        for (int i = 0; i < this.columns_; ++i) {
            switch (Utils.getNonNullableSqlType(this.sqlType_[i])) {
                case 404: 
                case 408: {
                    return true;
                }
            }
        }
        return false;
    }

    int findColumnX(String string) throws SqlException {
        if (this.columnNameToIndexCache_ == null) {
            this.columnNameToIndexCache_ = new Hashtable();
        } else {
            Integer n = (Integer)this.columnNameToIndexCache_.get(string);
            if (n != null) {
                return n;
            }
        }
        for (int i = 0; i < this.columns_; ++i) {
            if (this.sqlName_ == null || this.sqlName_[i] == null || !this.sqlName_[i].equalsIgnoreCase(string)) continue;
            this.columnNameToIndexCache_.put(string, new Integer(i + 1));
            return i + 1;
        }
        throw new SqlException(this.logWriter_, new ClientMessageId("XIE08.S"), string);
    }

    void assignColumnName(int n) {
        if (this.columnNameToIndexCache_ == null) {
            this.columnNameToIndexCache_ = new Hashtable();
        }
        String string = new Integer(n).toString();
        this.columnNameToIndexCache_.put(string, new Integer(n));
        this.sqlName_[n - 1] = string;
    }

    public boolean columnIsNotInUnicode(int n) {
        return this.sqlCcsid_[n] != 1208;
    }
}

