/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.misc.processor;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.misc.processor.AbstractWSDLToProcessor;
import org.apache.cxf.tools.misc.processor.address.Address;
import org.apache.cxf.tools.misc.processor.address.AddressFactory;
import org.apache.cxf.wsdl.WSDLExtensibilityPlugin;

public class WSDLToXMLProcessor
extends AbstractWSDLToProcessor {
    private static final String NEW_FILE_NAME_MODIFIER = "-xmlbinding";
    private Map services;
    private Service service;
    private Map ports;
    private Port port;
    private Map portTypes;
    private PortType portType;
    private Binding binding;

    public void process() throws ToolException {
        this.init();
        if (this.isBindingExisted()) {
            Message msg = new Message("BINDING_ALREADY_EXIST", LOG, new Object[0]);
            throw new ToolException(msg);
        }
        if (!this.isPortTypeExisted()) {
            Message msg = new Message("PORTTYPE_NOT_EXIST", LOG, new Object[0]);
            throw new ToolException(msg);
        }
        if (this.isServicePortExisted()) {
            Message msg = new Message("SERVICE_PORT_EXIST", LOG, new Object[0]);
            throw new ToolException(msg);
        }
        this.doAppendBinding();
        this.doAppendService();
        this.writeToWSDL();
    }

    private boolean isServicePortExisted() {
        return this.isServiceExisted() && this.isPortExisted();
    }

    private boolean isServiceExisted() {
        this.services = this.wsdlDefinition.getServices();
        if (this.services == null) {
            return false;
        }
        for (QName serviceQName : this.services.keySet()) {
            String serviceName = serviceQName.getLocalPart();
            if (!serviceName.equals(this.env.get("service"))) continue;
            this.service = (Service)this.services.get(serviceQName);
            break;
        }
        return this.service != null;
    }

    private boolean isPortExisted() {
        this.ports = this.service.getPorts();
        if (this.ports == null) {
            return false;
        }
        for (String portName : this.ports.keySet()) {
            if (!portName.equals(this.env.get("port"))) continue;
            this.port = (Port)this.ports.get(portName);
            break;
        }
        return this.port != null;
    }

    private boolean isPortTypeExisted() {
        this.portTypes = this.wsdlDefinition.getPortTypes();
        if (this.portTypes == null) {
            return false;
        }
        for (QName existPortQName : this.portTypes.keySet()) {
            String existPortName = existPortQName.getLocalPart();
            if (!existPortName.equals(this.env.get("porttype"))) continue;
            this.portType = (PortType)this.portTypes.get(existPortQName);
            break;
        }
        return this.portType != null;
    }

    private boolean isBindingExisted() {
        Map bindings = this.wsdlDefinition.getBindings();
        if (bindings == null) {
            return false;
        }
        for (QName existBindingQName : bindings.keySet()) {
            String existBindingName = existBindingQName.getLocalPart();
            String bindingName = (String)this.env.get("binding");
            if (!bindingName.equals(existBindingName)) continue;
            this.binding = (Binding)bindings.get(existBindingQName);
        }
        return this.binding != null;
    }

    protected void init() throws ToolException {
        this.parseWSDL((String)this.env.get("wsdlurl"));
        if (this.wsdlDefinition.getNamespace("xformat") == null) {
            this.wsdlDefinition.addNamespace("xformat", "http://cxf.apache.org/bindings/xformat");
        }
        if (this.wsdlDefinition.getNamespace("http") == null) {
            this.wsdlDefinition.addNamespace("http", "http://schemas.xmlsoap.org/wsdl/http/");
        }
    }

    private void doAppendBinding() throws ToolException {
        if (this.binding == null) {
            this.binding = this.wsdlDefinition.createBinding();
            this.binding.setQName(new QName(this.wsdlDefinition.getTargetNamespace(), (String)this.env.get("binding")));
            this.binding.setUndefined(false);
            this.binding.setPortType(this.portType);
        }
        this.setXMLBindingExtElement();
        this.addBindingOperation();
        this.wsdlDefinition.addBinding(this.binding);
    }

    private void setXMLBindingExtElement() throws ToolException {
        if (this.extReg == null) {
            this.extReg = this.wsdlFactory.newPopulatedExtensionRegistry();
        }
        try {
            this.binding.addExtensibilityElement(this.getWSDLPlugin("xml", Binding.class).createExtension(null));
        }
        catch (WSDLException wse) {
            Message msg = new Message("FAIL_TO_CREATE_XMLBINDING", LOG, new Object[0]);
            throw new ToolException(msg);
        }
    }

    private void addBindingOperation() throws ToolException {
        List ops = this.portType.getOperations();
        for (Operation op : ops) {
            BindingOperation bindingOperation = this.wsdlDefinition.createBindingOperation();
            bindingOperation.setName(op.getName());
            if (op.getInput() != null) {
                bindingOperation.setBindingInput(this.getBindingInput(op.getInput(), op.getName()));
            }
            if (op.getOutput() != null) {
                bindingOperation.setBindingOutput(this.getBindingOutput(op.getOutput(), op.getName()));
            }
            if (op.getFaults() != null && op.getFaults().size() > 0) {
                this.addXMLFaults(op, bindingOperation);
            }
            bindingOperation.setOperation(op);
            this.binding.addBindingOperation(bindingOperation);
        }
    }

    private BindingInput getBindingInput(Input input, String operationName) throws ToolException {
        BindingInput bi = this.wsdlDefinition.createBindingInput();
        bi.setName(input.getName());
        bi.addExtensibilityElement(this.getXMLBody(BindingInput.class, operationName));
        return bi;
    }

    private BindingOutput getBindingOutput(Output output, String operationName) throws ToolException {
        BindingOutput bo = this.wsdlDefinition.createBindingOutput();
        bo.setName(output.getName());
        bo.addExtensibilityElement(this.getXMLBody(BindingOutput.class, operationName));
        return bo;
    }

    private void addXMLFaults(Operation op, BindingOperation bo) {
    }

    private ExtensibilityElement getXMLBody(Class clz, String operationName) throws ToolException {
        if (this.extReg == null) {
            this.extReg = this.wsdlFactory.newPopulatedExtensionRegistry();
        }
        HashMap<String, Serializable> args = new HashMap<String, Serializable>();
        args.put(QName.class.getName(), new QName(this.wsdlDefinition.getTargetNamespace(), operationName));
        args.put(Class.class.getName(), clz);
        try {
            return this.getWSDLPlugin("xml", clz).createExtension(args);
        }
        catch (WSDLException wse) {
            Message msg = new Message("FAIL_TO_CREATE_XMLBINDING", LOG, new Object[0]);
            throw new ToolException(msg);
        }
    }

    private void doAppendService() throws ToolException {
        if (this.service == null) {
            this.service = this.wsdlDefinition.createService();
            this.service.setQName(new QName("wsdl", (String)this.env.get("service")));
        }
        if (this.port == null) {
            this.port = this.wsdlDefinition.createPort();
            this.port.setName((String)this.env.get("port"));
            this.port.setBinding(this.binding);
        }
        this.setAddrElement();
        this.service.addPort(this.port);
        this.wsdlDefinition.addService(this.service);
    }

    private void setAddrElement() throws ToolException {
        Address address = AddressFactory.getInstance().getAddresser("xml");
        for (String key : address.getNamespaces(this.env).keySet()) {
            this.wsdlDefinition.addNamespace(key, address.getNamespaces(this.env).get(key));
        }
        WSDLExtensibilityPlugin generator = this.getWSDLPlugin("xml", Port.class);
        try {
            ExtensibilityElement extElement = generator.createExtension(address.buildAddressArguments(this.env));
            this.port.addExtensibilityElement(extElement);
        }
        catch (WSDLException wse) {
            Message msg = new Message("FAIL_TO_CREATE_SOAPADDRESS", LOG, new Object[0]);
            throw new ToolException(msg);
        }
    }

    private void writeToWSDL() throws ToolException {
        WSDLWriter wsdlWriter = this.wsdlFactory.newWSDLWriter();
        Writer outputWriter = this.getOutputWriter(NEW_FILE_NAME_MODIFIER);
        try {
            wsdlWriter.writeWSDL(this.wsdlDefinition, outputWriter);
        }
        catch (WSDLException wse) {
            Message msg = new Message("FAIL_TO_WRITE_WSDL", LOG, new Object[0]);
            throw new ToolException(msg);
        }
        try {
            outputWriter.close();
        }
        catch (IOException ioe) {
            Message msg = new Message("FAIL_TO_CLOSE_WSDL_FILE", LOG, new Object[0]);
            throw new ToolException(msg);
        }
    }
}

