/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.wss4j.StaxSecurityContextInInterceptor;
import org.apache.wss4j.policy.model.AlgorithmSuite;
import org.apache.wss4j.stax.securityEvent.OperationSecurityEvent;
import org.apache.wss4j.stax.securityEvent.WSSecurityEventConstants;
import org.apache.xml.security.stax.securityEvent.SecurityEvent;
import org.apache.xml.security.stax.securityEvent.SecurityEventConstants;

public class PolicyStaxActionInInterceptor
extends AbstractPhaseInterceptor<SoapMessage> {
    private static final Logger LOG = LogUtils.getL7dLogger(PolicyStaxActionInInterceptor.class);

    public PolicyStaxActionInInterceptor() {
        super("pre-protocol");
        this.getBefore().add(StaxSecurityContextInInterceptor.class.getName());
    }

    public void handleMessage(SoapMessage soapMessage) throws Fault {
        OperationSecurityEvent securityEvent;
        AssertionInfoMap aim = (AssertionInfoMap)soapMessage.get(AssertionInfoMap.class);
        List incomingSecurityEventList = (List)soapMessage.get((Object)(SecurityEvent.class.getName() + ".in"));
        if (aim == null || incomingSecurityEventList == null) {
            return;
        }
        if (MessageUtils.isRequestor((Message)soapMessage) && incomingSecurityEventList.contains(WSSecurityEventConstants.NoSecurity) && (securityEvent = (OperationSecurityEvent)this.findEvent(WSSecurityEventConstants.Operation, incomingSecurityEventList)) != null && soapMessage.getVersion().getFault().equals(securityEvent.getOperation())) {
            LOG.warning("Request does not contain Security header, but it's a fault.");
            return;
        }
        this.assertAllSecurityAssertions(aim);
    }

    private SecurityEvent findEvent(SecurityEventConstants.Event event, List<SecurityEvent> incomingSecurityEventList) {
        for (SecurityEvent incomingEvent : incomingSecurityEventList) {
            if (event != incomingEvent.getSecurityEventType()) continue;
            return incomingEvent;
        }
        return null;
    }

    private void assertAllSecurityAssertions(AssertionInfoMap aim) {
        for (Map.Entry entry : aim.entrySet()) {
            Collection ais;
            String namespace = ((QName)entry.getKey()).getNamespaceURI();
            if (!"http://schemas.xmlsoap.org/ws/2005/07/securitypolicy".equals(namespace) && !"http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702".equals(namespace) && !"http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200802".equals(namespace) || (ais = (Collection)entry.getValue()) == null || ais.isEmpty()) continue;
            if ("AlgorithmSuite".equals(((QName)entry.getKey()).getLocalPart())) {
                this.assertAlgorithmSuites(ais, aim);
                continue;
            }
            for (AssertionInfo ai : ais) {
                ai.setAsserted(true);
            }
        }
    }

    private void assertAlgorithmSuites(Collection<AssertionInfo> ais, AssertionInfoMap aim) {
        for (AssertionInfo ai : ais) {
            Collection algAis;
            ai.setAsserted(true);
            AlgorithmSuite algorithmSuite = (AlgorithmSuite)ai.getAssertion();
            AlgorithmSuite.AlgorithmSuiteType algorithmSuiteType = algorithmSuite.getAlgorithmSuiteType();
            String namespace = algorithmSuiteType.getNamespace();
            if (namespace == null || namespace.equals(algorithmSuite.getName().getNamespaceURI()) || (algAis = (Collection)aim.get((Object)new QName(namespace, algorithmSuiteType.getName()))) == null || algAis.isEmpty()) continue;
            for (AssertionInfo algAi : algAis) {
                algAi.setAsserted(true);
            }
        }
    }
}

