/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.policy.AssertionBuilder;
import org.apache.cxf.ws.policy.PolicyAssertion;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.UsernameToken;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsernameTokenBuilder
implements AssertionBuilder {
    private static final List<QName> KNOWN_ELEMENTS = Arrays.asList(SP11Constants.USERNAME_TOKEN, SP12Constants.USERNAME_TOKEN);
    PolicyBuilder builder;

    public UsernameTokenBuilder(PolicyBuilder b) {
        this.builder = b;
    }

    public PolicyAssertion build(Element element) {
        Element policyElement;
        SPConstants consts = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy".equals(element.getNamespaceURI()) ? SP11Constants.INSTANCE : SP12Constants.INSTANCE;
        UsernameToken usernameToken = new UsernameToken(consts);
        String attribute = DOMUtils.getAttribute((Element)element, (QName)SP11Constants.INCLUDE_TOKEN);
        if (attribute != null) {
            usernameToken.setInclusion(consts.getInclusionFromAttributeValue(attribute));
        }
        if ((policyElement = DOMUtils.getFirstElement((Node)element)) != null) {
            Policy policy = this.builder.getPolicy(policyElement);
            Iterator iterator = (policy = (Policy)policy.normalize(false)).getAlternatives();
            if (iterator.hasNext()) {
                this.processAlternative((List)iterator.next(), usernameToken, consts);
            }
        }
        return usernameToken;
    }

    public List<QName> getKnownElements() {
        return KNOWN_ELEMENTS;
    }

    private void processAlternative(List assertions, UsernameToken parent, SPConstants consts) {
        for (Assertion assertion : assertions) {
            QName qname = assertion.getName();
            if (!consts.getNamespace().equals(qname.getNamespaceURI())) continue;
            if ("WssUsernameToken10".equals(qname.getLocalPart())) {
                parent.setUseUTProfile10(true);
                continue;
            }
            if ("WssUsernameToken11".equals(qname.getLocalPart())) {
                parent.setUseUTProfile11(true);
                continue;
            }
            if (SP12Constants.NO_PASSWORD.equals(qname)) {
                parent.setNoPassword(true);
                continue;
            }
            if (SP12Constants.HASH_PASSWORD.equals(qname)) {
                parent.setHashPassword(true);
                continue;
            }
            if (SP12Constants.REQUIRE_DERIVED_KEYS.equals(qname)) {
                parent.setDerivedKeys(true);
                continue;
            }
            if (SP12Constants.REQUIRE_EXPLICIT_DERIVED_KEYS.equals(qname)) {
                parent.setExplicitDerivedKeys(true);
                continue;
            }
            if (!SP12Constants.REQUIRE_IMPLIED_DERIVED_KEYS.equals(qname)) continue;
            parent.setImpliedDerivedKeys(true);
        }
    }

    public PolicyAssertion buildCompatible(PolicyAssertion a, PolicyAssertion b) {
        return null;
    }
}

