/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.osgi;

import java.util.Dictionary;
import java.util.Properties;
import javax.servlet.Servlet;
import org.apache.cxf.bus.blueprint.BlueprintNameSpaceHandlerFactory;
import org.apache.cxf.bus.blueprint.NamespaceHandlerRegisterer;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http.DestinationRegistryImpl;
import org.apache.cxf.transport.http.HTTPConduitConfigurer;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.apache.cxf.transport.http.blueprint.HttpBPHandler;
import org.apache.cxf.transport.http.osgi.ConfigAdminHttpConduitConfigurer;
import org.apache.cxf.transport.servlet.CXFNonSpringServlet;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.cm.ManagedServiceFactory;

public class HTTPTransportActivator
implements BundleActivator {
    private static final String CXF_CONFIG_SCOPE = "org.apache.cxf.osgi";
    private static final String DISABLE_DEFAULT_HTTP_TRANSPORT = "org.apache.cxf.osgi.http.transport.disable";

    public void start(BundleContext context) throws Exception {
        ConfigAdminHttpConduitConfigurer conduitConfigurer = new ConfigAdminHttpConduitConfigurer();
        this.registerService(context, ManagedServiceFactory.class, conduitConfigurer, "org.apache.cxf.http.conduits");
        this.registerService(context, HTTPConduitConfigurer.class, conduitConfigurer, "org.apache.cxf.http.conduit-configurer");
        if (PropertyUtils.isTrue((Object)context.getProperty(DISABLE_DEFAULT_HTTP_TRANSPORT))) {
            return;
        }
        DestinationRegistryImpl destinationRegistry = new DestinationRegistryImpl();
        HTTPTransportFactory transportFactory = new HTTPTransportFactory(destinationRegistry);
        CXFNonSpringServlet servlet = new CXFNonSpringServlet(destinationRegistry, false);
        ServletConfigurer servletConfig = new ServletConfigurer(context, (Servlet)servlet);
        context.registerService(DestinationRegistry.class.getName(), (Object)destinationRegistry, null);
        context.registerService(HTTPTransportFactory.class.getName(), (Object)transportFactory, null);
        this.registerService(context, ManagedService.class, servletConfig, CXF_CONFIG_SCOPE);
        BlueprintNameSpaceHandlerFactory factory = new BlueprintNameSpaceHandlerFactory(){

            public Object createNamespaceHandler() {
                return new HttpBPHandler();
            }
        };
        NamespaceHandlerRegisterer.register((BundleContext)context, (BlueprintNameSpaceHandlerFactory)factory, (String[])new String[]{"http://cxf.apache.org/transports/http/configuration"});
    }

    private void registerService(BundleContext context, Class<?> serviceInterface, Object serviceObject, String servicePid) {
        Properties servProps = new Properties();
        servProps.put("service.pid", servicePid);
        context.registerService(serviceInterface.getName(), serviceObject, (Dictionary)servProps);
    }

    public void stop(BundleContext context) throws Exception {
    }

    class ServletConfigurer
    implements ManagedService {
        private ServiceRegistration reg;
        private BundleContext context;
        private Servlet servlet;

        public ServletConfigurer(BundleContext context, Servlet servlet) {
            this.servlet = servlet;
            this.context = context;
        }

        public void updated(Dictionary properties) throws ConfigurationException {
            if (this.reg != null) {
                this.reg.unregister();
            }
            if (properties == null) {
                properties = new Properties();
            }
            Properties sprops = new Properties();
            sprops.put("alias", this.getProp(properties, "org.apache.cxf.servlet.context", "/cxf"));
            sprops.put("servlet-name", this.getProp(properties, "org.apache.cxf.servlet.name", "cxf-osgi-transport-servlet"));
            sprops.put("hide-service-list-page", this.getProp(properties, "org.apache.cxf.servlet.hide-service-list-page", "false"));
            sprops.put("disable-address-updates", this.getProp(properties, "org.apache.cxf.servlet.disable-address-updates", "true"));
            sprops.put("base-address", this.getProp(properties, "org.apache.cxf.servlet.base-address", ""));
            sprops.put("service-list-path", this.getProp(properties, "org.apache.cxf.servlet.service-list-path", ""));
            sprops.put("static-resources-list", this.getProp(properties, "org.apache.cxf.servlet.static-resources-list", ""));
            sprops.put("redirects-list", this.getProp(properties, "org.apache.cxf.servlet.redirects-list", ""));
            sprops.put("redirect-servlet-name", this.getProp(properties, "org.apache.cxf.servlet.redirect-servlet-name", ""));
            sprops.put("redirect-servlet-path", this.getProp(properties, "org.apache.cxf.servlet.redirect-servlet-path", ""));
            sprops.put("service-list-all-contexts", this.getProp(properties, "org.apache.cxf.servlet.service-list-all-contexts", ""));
            sprops.put("service-list-page-authenticate", this.getProp(properties, "org.apache.cxf.servlet.service-list-page-authenticate", "false"));
            sprops.put("service-list-page-authenticate-realm", this.getProp(properties, "org.apache.cxf.servlet.service-list-page-authenticate-realm", "karaf"));
            this.context.registerService(Servlet.class.getName(), (Object)this.servlet, (Dictionary)sprops);
        }

        private Object getProp(Dictionary properties, String key, Object defaultValue) {
            Object value = properties.get(key);
            return value == null ? defaultValue : value;
        }
    }
}

