/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.Authenticator;
import java.net.PasswordAuthentication;

public class ReferencingAuthenticator
extends Authenticator {
    SoftReference<Authenticator> auth;
    Authenticator wrapped;

    public ReferencingAuthenticator(Authenticator cxfauth, Authenticator wrapped) {
        this.auth = new SoftReference<Authenticator>(cxfauth);
        this.wrapped = wrapped;
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        Authenticator cxfauth;
        PasswordAuthentication pauth = null;
        if (this.wrapped != null) {
            try {
                pauth = this.tryWith(this.wrapped);
                if (pauth != null) {
                    return pauth;
                }
            }
            catch (Exception e) {
                pauth = null;
            }
        }
        if ((cxfauth = this.auth.get()) == null) {
            try {
                Authenticator.setDefault(this.wrapped);
            }
            catch (Throwable t) {}
        } else {
            try {
                pauth = this.tryWith(cxfauth);
            }
            catch (Exception e1) {
                pauth = null;
            }
        }
        return pauth;
    }

    PasswordAuthentication tryWith(Authenticator a) throws Exception {
        if (a == null) {
            return null;
        }
        for (Field f : Authenticator.class.getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers())) continue;
            f.setAccessible(true);
            Object o = f.get(this);
            f.set(a, o);
        }
        Method m = Authenticator.class.getDeclaredMethod("getPasswordAuthentication", new Class[0]);
        m.setAccessible(true);
        return (PasswordAuthentication)m.invoke((Object)a, new Object[0]);
    }
}

