/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.validation.Schema;
import org.apache.cxf.databinding.AbstractDataBinding;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.invoker.MethodDispatcher;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXRSDataBinding
extends AbstractDataBinding {
    private static final Class<?>[] SUPPORTED_READER_FORMATS = new Class[]{XMLStreamReader.class};
    private static final Class<?>[] SUPPORTED_WRITER_FORMATS = new Class[]{XMLStreamWriter.class};
    private MessageBodyReader<?> xmlReader;
    private MessageBodyWriter<Object> xmlWriter;

    public void setProvider(Object provider) {
        if (!(provider instanceof MessageBodyWriter)) {
            throw new IllegalArgumentException("The provider must implement javax.ws.rs.ext.MessageBodyWriter");
        }
        this.xmlWriter = (MessageBodyWriter)provider;
        if (provider instanceof MessageBodyReader) {
            this.xmlReader = (MessageBodyReader)provider;
        }
    }

    public <T> DataReader<T> createReader(Class<T> cls) {
        if (this.xmlReader == null) {
            throw new IllegalStateException("javax.ws.rs.ext.MessageBodyReader reference is uninitialized");
        }
        return new MessageBodyDataReader();
    }

    public <T> DataWriter<T> createWriter(Class<T> cls) {
        return new MessageBodyDataWriter();
    }

    public Class<?>[] getSupportedReaderFormats() {
        return SUPPORTED_READER_FORMATS;
    }

    public Class<?>[] getSupportedWriterFormats() {
        return SUPPORTED_WRITER_FORMATS;
    }

    public void initialize(Service service) {
    }

    protected Method getTargetMethod(Message m) {
        BindingOperationInfo bop = (BindingOperationInfo)m.getExchange().get(BindingOperationInfo.class);
        MethodDispatcher md = (MethodDispatcher)((Service)m.getExchange().get(Service.class)).get((Object)MethodDispatcher.class.getName());
        return md.getMethod(bop);
    }

    private MultivaluedMap<String, String> getHeaders(Message message) {
        return new MetadataMap<String, String>((Map)message.get((Object)Message.PROTOCOL_HEADERS), true, true);
    }

    private MultivaluedMap<String, Object> getWriteHeaders(Message message) {
        return new MetadataMap<String, Object>((Map)message.get((Object)Message.PROTOCOL_HEADERS), true, true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MessageBodyDataReader
    implements DataReader<XMLStreamReader> {
        private MessageBodyDataReader() {
        }

        public Object read(XMLStreamReader input) {
            throw new UnsupportedOperationException();
        }

        public Object read(MessagePartInfo part, XMLStreamReader input) {
            return this.doRead(part.getTypeClass(), input);
        }

        public Object read(QName elementQName, XMLStreamReader input, Class<?> type) {
            return this.doRead(type, input);
        }

        private <T> T read(Class<T> cls) throws WebApplicationException, IOException {
            Message message = PhaseInterceptorChain.getCurrentMessage();
            Method method = JAXRSDataBinding.this.getTargetMethod(message);
            MessageBodyReader reader = JAXRSDataBinding.this.xmlReader;
            return (T)reader.readFrom(cls, method.getGenericParameterTypes()[0], method.getParameterTypes()[0].getAnnotations(), MediaType.APPLICATION_ATOM_XML_TYPE, JAXRSDataBinding.this.getHeaders(message), null);
        }

        private Object doRead(Class<?> cls, XMLStreamReader input) {
            try {
                return this.read(cls);
            }
            catch (Exception ex) {
                return null;
            }
        }

        public void setAttachments(Collection<Attachment> attachments) {
        }

        public void setProperty(String prop, Object value) {
        }

        public void setSchema(Schema s) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MessageBodyDataWriter
    implements DataWriter<XMLStreamWriter> {
        private MessageBodyDataWriter() {
        }

        public void write(Object obj, XMLStreamWriter output) {
            this.write(obj, null, output);
        }

        public void write(Object obj, MessagePartInfo part, XMLStreamWriter output) {
            try {
                Message message = PhaseInterceptorChain.getCurrentMessage();
                Method method = JAXRSDataBinding.this.getTargetMethod(message);
                MultivaluedMap headers = JAXRSDataBinding.this.getWriteHeaders(message);
                JAXRSDataBinding.this.xmlWriter.writeTo(obj, method.getReturnType(), method.getGenericReturnType(), method.getAnnotations(), MediaType.APPLICATION_XML_TYPE, headers, null);
                message.put((Object)Message.PROTOCOL_HEADERS, (Object)headers);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }

        public void setAttachments(Collection<Attachment> attachments) {
        }

        public void setProperty(String key, Object value) {
        }

        public void setSchema(Schema s) {
        }
    }
}

