/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.databinding;

import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor;
import org.apache.cxf.binding.soap.interceptor.StartBodyInterceptor;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.StaxValidationManager;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.ServiceInfo;

public class AegisSchemaValidationInInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(AegisSchemaValidationInInterceptor.class);
    private ServiceInfo service;
    private Bus bus;

    public AegisSchemaValidationInInterceptor(Bus bus, ServiceInfo service) {
        super("read");
        this.bus = bus;
        this.service = service;
        this.addBefore(StartBodyInterceptor.class.getName());
        this.addAfter(ReadHeadersInterceptor.class.getName());
    }

    public void handleMessage(Message message) throws Fault {
        XMLStreamReader xmlReader = (XMLStreamReader)message.getContent(XMLStreamReader.class);
        try {
            this.setSchemaInMessage(message, xmlReader);
        }
        catch (XMLStreamException e) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("SCHEMA_ERROR", LOG, new Object[0]), (Throwable)e);
        }
    }

    private void setSchemaInMessage(Message message, XMLStreamReader reader) throws XMLStreamException {
        StaxValidationManager mgr;
        Object en = message.getContextualProperty("schema-validation-enabled");
        if ((Boolean.TRUE.equals(en) || "true".equals(en)) && (mgr = (StaxValidationManager)this.bus.getExtension(StaxValidationManager.class)) != null) {
            mgr.setupValidation(reader, this.service);
        }
    }
}

