/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import org.apache.cassandra.db.SnapshotCommand;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.tracing.Tracing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotVerbHandler
implements IVerbHandler<SnapshotCommand> {
    private static final Logger logger = LoggerFactory.getLogger(SnapshotVerbHandler.class);

    @Override
    public void doVerb(MessageIn<SnapshotCommand> message, String id) {
        SnapshotCommand command = (SnapshotCommand)message.payload;
        if (command.clear_snapshot) {
            Table.open(command.keyspace).clearSnapshot(command.snapshot_name);
        } else {
            Table.open(command.keyspace).getColumnFamilyStore(command.column_family).snapshot(command.snapshot_name);
        }
        Tracing.trace("Enqueuing response to snapshot request {} to {}", command.snapshot_name, message.from);
        MessagingService.instance().sendReply(new MessageOut(MessagingService.Verb.REQUEST_RESPONSE), id, message.from);
    }
}

