/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Collection;
import org.apache.cassandra.db.DefsTable;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.net.IAsyncCallback;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.utils.WrappedRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MigrationTask
extends WrappedRunnable {
    private static final Logger logger = LoggerFactory.getLogger(MigrationTask.class);
    private final InetAddress endpoint;

    MigrationTask(InetAddress endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public void runMayThrow() throws Exception {
        MessageOut<Collection<RowMutation>> message = new MessageOut<Collection<RowMutation>>(MessagingService.Verb.MIGRATION_REQUEST, null, MigrationManager.MigrationsSerializer.instance);
        if (!FailureDetector.instance.isAlive(this.endpoint)) {
            logger.error("Can't send migration request: node {} is down.", (Object)this.endpoint);
            return;
        }
        IAsyncCallback<Collection<RowMutation>> cb = new IAsyncCallback<Collection<RowMutation>>(){

            @Override
            public void response(MessageIn<Collection<RowMutation>> message) {
                try {
                    DefsTable.mergeSchema((Collection)message.payload);
                }
                catch (IOException e) {
                    logger.error("IOException merging remote schema", (Throwable)e);
                }
                catch (ConfigurationException e) {
                    logger.error("Configuration exception merging remote schema", (Throwable)e);
                }
            }

            @Override
            public boolean isLatencyForSnitch() {
                return false;
            }
        };
        MessagingService.instance().sendRR(message, this.endpoint, cb);
    }
}

