/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.google.common.collect.AbstractIterator;
import java.io.File;
import java.io.IOException;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.CloseableIterator;

public class KeyIterator
extends AbstractIterator<DecoratedKey>
implements CloseableIterator<DecoratedKey> {
    private final RandomAccessReader in;
    private final Descriptor desc;

    public KeyIterator(Descriptor desc) {
        this.desc = desc;
        File path = new File(desc.filenameFor(SSTable.COMPONENT_INDEX));
        this.in = RandomAccessReader.open(path, true);
    }

    protected DecoratedKey computeNext() {
        try {
            if (this.in.isEOF()) {
                return (DecoratedKey)this.endOfData();
            }
            DecoratedKey key = SSTableReader.decodeKey(StorageService.getPartitioner(), this.desc, ByteBufferUtil.readWithShortLength(this.in));
            RowIndexEntry.serializer.skip(this.in, this.desc.version);
            return key;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        this.in.close();
    }

    public long getBytesRead() {
        return this.in.getFilePointer();
    }

    public long getTotalBytes() {
        return this.in.length();
    }
}

