/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.utils.BoundedStatsDeque;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ArrivalWindow {
    private static final Logger logger = LoggerFactory.getLogger(ArrivalWindow.class);
    private double tLast = 0.0;
    private final BoundedStatsDeque arrivalIntervals;
    private final double PHI_FACTOR = 1.0 / Math.log(10.0);
    private final double MAX_INTERVAL_IN_MS = DatabaseDescriptor.getRpcTimeout();

    ArrivalWindow(int size) {
        this.arrivalIntervals = new BoundedStatsDeque(size);
    }

    synchronized void add(double value) {
        double interArrivalTime = this.tLast > 0.0 ? value - this.tLast : 500.0;
        if (interArrivalTime <= this.MAX_INTERVAL_IN_MS) {
            this.arrivalIntervals.add(interArrivalTime);
        } else {
            logger.debug("Ignoring interval time of {}", (Object)interArrivalTime);
        }
        this.tLast = value;
    }

    double mean() {
        return this.arrivalIntervals.mean();
    }

    void clear() {
        this.arrivalIntervals.clear();
    }

    double phi(long tnow) {
        int size = this.arrivalIntervals.size();
        double t = (double)tnow - this.tLast;
        return size > 0 ? this.PHI_FACTOR * t / this.mean() : 0.0;
    }

    public String toString() {
        return StringUtils.join(this.arrivalIntervals.iterator(), (String)" ");
    }
}

