/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.TruncateResponse;
import org.apache.cassandra.db.Truncation;
import org.apache.cassandra.io.FSError;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.tracing.Tracing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TruncateVerbHandler
implements IVerbHandler<Truncation> {
    private static final Logger logger = LoggerFactory.getLogger(TruncateVerbHandler.class);

    @Override
    public void doVerb(MessageIn<Truncation> message, String id) {
        Truncation t;
        block2: {
            t = (Truncation)message.payload;
            Tracing.trace("Applying truncation of {}.{}", t.keyspace, t.columnFamily);
            try {
                ColumnFamilyStore cfs = Table.open(t.keyspace).getColumnFamilyStore(t.columnFamily);
                cfs.truncate().get();
            }
            catch (Exception e) {
                logger.error("Error in truncation", (Throwable)e);
                TruncateVerbHandler.respondError(t, message);
                if (FSError.findNested(e) == null) break block2;
                throw FSError.findNested(e);
            }
        }
        Tracing.trace("Enqueuing response to truncate operation to {}", message.from);
        TruncateResponse response = new TruncateResponse(t.keyspace, t.columnFamily, true);
        logger.trace("{} applied.  Enqueuing response to {}@{} ", new Object[]{t, id, message.from});
        MessagingService.instance().sendReply(response.createMessage(), id, message.from);
    }

    private static void respondError(Truncation t, MessageIn truncateRequestMessage) {
        TruncateResponse response = new TruncateResponse(t.keyspace, t.columnFamily, false);
        MessagingService.instance().sendOneWay(response.createMessage(), truncateRequestMessage.from);
    }
}

