/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.collect.AbstractIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Memtable;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.columniterator.IColumnIterator;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.SSTableScanner;
import org.apache.cassandra.utils.CloseableIterator;
import org.apache.cassandra.utils.MergeIterator;

public class RowIteratorFactory {
    private static final Comparator<IColumnIterator> COMPARE_BY_KEY = new Comparator<IColumnIterator>(){

        @Override
        public int compare(IColumnIterator o1, IColumnIterator o2) {
            return DecoratedKey.comparator.compare(o1.getKey(), o2.getKey());
        }
    };

    public static CloseableIterator<Row> getIterator(Iterable<Memtable> memtables, Collection<SSTableReader> sstables, RowPosition startWith, RowPosition stopAt, final QueryFilter filter, final ColumnFamilyStore cfs) {
        ArrayList<CloseableIterator<IColumnIterator>> iterators = new ArrayList<CloseableIterator<IColumnIterator>>();
        for (Memtable memtable : memtables) {
            iterators.add(new ConvertToColumnIterator(filter, memtable.getEntryIterator(startWith, stopAt)));
        }
        for (SSTableReader sstable : sstables) {
            SSTableScanner scanner = sstable.getScanner(filter);
            scanner.seekTo(startWith);
            iterators.add(scanner);
        }
        return MergeIterator.get(iterators, COMPARE_BY_KEY, new MergeIterator.Reducer<IColumnIterator, Row>(){
            private final int gcBefore;
            private final List<IColumnIterator> colIters;
            private DecoratedKey key;
            private ColumnFamily returnCF;
            {
                this.gcBefore = (int)(System.currentTimeMillis() / 1000L) - cfs.metadata.getGcGraceSeconds();
                this.colIters = new ArrayList<IColumnIterator>();
            }

            @Override
            protected void onKeyChange() {
                this.returnCF = ColumnFamily.create(cfs.metadata);
            }

            @Override
            public void reduce(IColumnIterator current) {
                this.colIters.add(current);
                this.key = current.getKey();
                this.returnCF.delete(current.getColumnFamily());
            }

            @Override
            protected Row getReduced() {
                ColumnFamily cached = cfs.getRawCachedRow(this.key);
                if (cached == null) {
                    filter.collateColumns(this.returnCF, this.colIters, this.gcBefore);
                } else {
                    QueryFilter keyFilter = new QueryFilter(this.key, filter.path, filter.filter);
                    this.returnCF = cfs.filterColumnFamily(cached, keyFilter, this.gcBefore);
                }
                Row rv = new Row(this.key, this.returnCF);
                this.colIters.clear();
                this.key = null;
                return rv;
            }
        });
    }

    private static class ConvertToColumnIterator
    extends AbstractIterator<IColumnIterator>
    implements CloseableIterator<IColumnIterator> {
        private final QueryFilter filter;
        private final Iterator<Map.Entry<DecoratedKey, ColumnFamily>> iter;

        public ConvertToColumnIterator(QueryFilter filter, Iterator<Map.Entry<DecoratedKey, ColumnFamily>> iter) {
            this.filter = filter;
            this.iter = iter;
        }

        public IColumnIterator computeNext() {
            if (this.iter.hasNext()) {
                Map.Entry<DecoratedKey, ColumnFamily> entry = this.iter.next();
                return this.filter.getMemtableColumnIterator(entry.getValue(), entry.getKey());
            }
            return (IColumnIterator)this.endOfData();
        }

        @Override
        public void close() {
        }
    }
}

