/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import java.io.DataInputStream;
import java.io.IOError;
import java.io.IOException;
import org.apache.cassandra.io.util.FastByteArrayInputStream;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.streaming.StreamOutSession;
import org.apache.cassandra.streaming.StreamReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamReplyVerbHandler
implements IVerbHandler {
    private static Logger logger = LoggerFactory.getLogger(StreamReplyVerbHandler.class);

    @Override
    public void doVerb(Message message, String id) {
        byte[] body = message.getMessageBody();
        FastByteArrayInputStream bufIn = new FastByteArrayInputStream(body);
        try {
            StreamReply reply = StreamReply.serializer.deserialize(new DataInputStream(bufIn), message.getVersion());
            logger.debug("Received StreamReply {}", (Object)reply);
            StreamOutSession session = StreamOutSession.get(message.getFrom(), reply.sessionId);
            if (session == null) {
                logger.debug("Received stream action " + (Object)((Object)reply.action) + " for an unknown session from " + message.getFrom());
                return;
            }
            switch (reply.action) {
                case FILE_FINISHED: {
                    session.validateCurrentFile(reply.file);
                    session.startNext();
                    break;
                }
                case FILE_RETRY: {
                    session.validateCurrentFile(reply.file);
                    logger.info("Need to re-stream file {} to {}", (Object)reply.file, (Object)message.getFrom());
                    session.retry();
                    break;
                }
                case SESSION_FINISHED: {
                    session.close();
                    break;
                }
                default: {
                    throw new RuntimeException("Cannot handle FileStatus.Action: " + (Object)((Object)reply.action));
                }
            }
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }
}

