/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.messaging.core.DestinationResolutionException;
import org.springframework.messaging.core.DestinationResolver;
import org.springframework.util.Assert;

public class CachingDestinationResolverProxy<D>
implements DestinationResolver<D>,
InitializingBean {
    private final Map<String, D> resolvedDestinationCache = new ConcurrentHashMap<String, D>();
    private DestinationResolver<D> targetDestinationResolver;

    public CachingDestinationResolverProxy() {
    }

    public CachingDestinationResolverProxy(DestinationResolver<D> targetDestinationResolver) {
        Assert.notNull(targetDestinationResolver, "Target DestinationResolver must not be null");
        this.targetDestinationResolver = targetDestinationResolver;
    }

    public void setTargetDestinationResolver(DestinationResolver<D> targetDestinationResolver) {
        this.targetDestinationResolver = targetDestinationResolver;
    }

    @Override
    public void afterPropertiesSet() {
        if (this.targetDestinationResolver == null) {
            throw new IllegalArgumentException("Property 'targetDestinationResolver' is required");
        }
    }

    @Override
    public D resolveDestination(String name) throws DestinationResolutionException {
        D destination = this.resolvedDestinationCache.get(name);
        if (destination == null) {
            destination = this.targetDestinationResolver.resolveDestination(name);
            this.resolvedDestinationCache.put(name, destination);
        }
        return destination;
    }
}

