/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.validation;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.ExpectedBodyTypeException;
import org.apache.camel.RuntimeTransformException;
import org.apache.camel.TypeConverter;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.processor.validation.DefaultValidationErrorHandler;
import org.apache.camel.processor.validation.NoXmlBodyValidationException;
import org.apache.camel.processor.validation.NoXmlHeaderValidationException;
import org.apache.camel.processor.validation.SchemaReader;
import org.apache.camel.processor.validation.SchemaValidationException;
import org.apache.camel.processor.validation.ValidatorErrorHandler;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ValidatingProcessor
implements AsyncProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ValidatingProcessor.class);
    private final SchemaReader schemaReader;
    private ValidatorErrorHandler errorHandler = new DefaultValidationErrorHandler();
    private final XmlConverter converter = new XmlConverter();
    private boolean useDom;
    private boolean useSharedSchema = true;
    private boolean failOnNullBody = true;
    private boolean failOnNullHeader = true;
    private String headerName;

    public ValidatingProcessor() {
        this.schemaReader = new SchemaReader();
    }

    public ValidatingProcessor(SchemaReader schemaReader) {
        this.schemaReader = schemaReader;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            this.doProcess(exchange);
        }
        catch (Exception e) {
            exchange.setException(e);
        }
        callback.done(true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doProcess(Exchange exchange) throws Exception {
        InputStream is;
        block20: {
            Schema schema = this.isUseSharedSchema() ? this.getSchema() : this.createSchema();
            Validator validator = schema.newValidator();
            if (!Boolean.parseBoolean(exchange.getContext().getGlobalOptions().get("CamelXmlValidatorAccessExternalDTD"))) {
                try {
                    LOG.debug("Configuring Validator to not allow access to external DTD/Schema");
                    validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                    validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
                }
                catch (SAXException e) {
                    LOG.warn(e.getMessage(), e);
                }
            }
            Source source = null;
            is = null;
            try {
                Result result = null;
                if (this.isInputStreamNeeded(exchange)) {
                    is = this.getContentToValidate(exchange, InputStream.class);
                    if (is != null) {
                        source = this.getSource(exchange, is);
                    }
                } else {
                    Object content = this.getContentToValidate(exchange);
                    if (content != null) {
                        source = this.getSource(exchange, content);
                    }
                }
                if (this.shouldUseHeader()) {
                    if (source == null && this.isFailOnNullHeader()) {
                        throw new NoXmlHeaderValidationException(exchange, this.headerName);
                    }
                } else if (source == null && this.isFailOnNullBody()) {
                    throw new NoXmlBodyValidationException(exchange);
                }
                if (source instanceof DOMSource) {
                    result = new DOMResult();
                } else if (source instanceof SAXSource) {
                    result = new SAXResult();
                } else if (source instanceof StAXSource || source instanceof StreamSource) {
                    result = null;
                }
                if (source == null) break block20;
                ValidatorErrorHandler handler = (ValidatorErrorHandler)this.errorHandler.getClass().newInstance();
                validator.setErrorHandler(handler);
                try {
                    LOG.trace("Validating {}", (Object)source);
                    validator.validate(source, result);
                    handler.handleErrors(exchange, schema, result);
                }
                catch (SAXParseException e) {
                    throw new SchemaValidationException(exchange, schema, Collections.singletonList(e), Collections.emptyList(), Collections.emptyList());
                }
            }
            catch (Throwable throwable) {
                IOHelper.close(is);
                throw throwable;
            }
        }
        IOHelper.close((Closeable)is);
    }

    private Object getContentToValidate(Exchange exchange) {
        if (this.shouldUseHeader()) {
            return exchange.getIn().getHeader(this.headerName);
        }
        return exchange.getIn().getBody();
    }

    private <T> T getContentToValidate(Exchange exchange, Class<T> clazz) {
        if (this.shouldUseHeader()) {
            return exchange.getIn().getHeader(this.headerName, clazz);
        }
        return exchange.getIn().getBody(clazz);
    }

    private boolean shouldUseHeader() {
        return this.headerName != null;
    }

    public void loadSchema() throws Exception {
        this.schemaReader.loadSchema();
    }

    public Schema getSchema() throws IOException, SAXException {
        return this.schemaReader.getSchema();
    }

    public void setSchema(Schema schema) {
        this.schemaReader.setSchema(schema);
    }

    public String getSchemaLanguage() {
        return this.schemaReader.getSchemaLanguage();
    }

    public void setSchemaLanguage(String schemaLanguage) {
        this.schemaReader.setSchemaLanguage(schemaLanguage);
    }

    public Source getSchemaSource() throws IOException {
        return this.schemaReader.getSchemaSource();
    }

    public void setSchemaSource(Source schemaSource) {
        this.schemaReader.setSchemaSource(schemaSource);
    }

    public URL getSchemaUrl() {
        return this.schemaReader.getSchemaUrl();
    }

    public void setSchemaUrl(URL schemaUrl) {
        this.schemaReader.setSchemaUrl(schemaUrl);
    }

    public File getSchemaFile() {
        return this.schemaReader.getSchemaFile();
    }

    public void setSchemaFile(File schemaFile) {
        this.schemaReader.setSchemaFile(schemaFile);
    }

    public byte[] getSchemaAsByteArray() {
        return this.schemaReader.getSchemaAsByteArray();
    }

    public void setSchemaAsByteArray(byte[] schemaAsByteArray) {
        this.schemaReader.setSchemaAsByteArray(schemaAsByteArray);
    }

    public SchemaFactory getSchemaFactory() {
        return this.schemaReader.getSchemaFactory();
    }

    public void setSchemaFactory(SchemaFactory schemaFactory) {
        this.schemaReader.setSchemaFactory(schemaFactory);
    }

    public ValidatorErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ValidatorErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Deprecated
    public boolean isUseDom() {
        return this.useDom;
    }

    @Deprecated
    public void setUseDom(boolean useDom) {
        this.useDom = useDom;
    }

    public boolean isUseSharedSchema() {
        return this.useSharedSchema;
    }

    public void setUseSharedSchema(boolean useSharedSchema) {
        this.useSharedSchema = useSharedSchema;
    }

    public LSResourceResolver getResourceResolver() {
        return this.schemaReader.getResourceResolver();
    }

    public void setResourceResolver(LSResourceResolver resourceResolver) {
        this.schemaReader.setResourceResolver(resourceResolver);
    }

    public boolean isFailOnNullBody() {
        return this.failOnNullBody;
    }

    public void setFailOnNullBody(boolean failOnNullBody) {
        this.failOnNullBody = failOnNullBody;
    }

    public boolean isFailOnNullHeader() {
        return this.failOnNullHeader;
    }

    public void setFailOnNullHeader(boolean failOnNullHeader) {
        this.failOnNullHeader = failOnNullHeader;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    protected SchemaFactory createSchemaFactory() {
        return this.schemaReader.createSchemaFactory();
    }

    protected Source createSchemaSource() throws IOException {
        return this.schemaReader.createSchemaSource();
    }

    protected Schema createSchema() throws SAXException, IOException {
        return this.schemaReader.createSchema();
    }

    protected boolean isInputStreamNeeded(Exchange exchange) {
        Object content = this.getContentToValidate(exchange);
        if (content == null) {
            return false;
        }
        if (content instanceof InputStream) {
            return true;
        }
        if (content instanceof Source) {
            return false;
        }
        if (content instanceof String) {
            return false;
        }
        if (content instanceof byte[]) {
            return false;
        }
        if (content instanceof Node) {
            return false;
        }
        return exchange.getContext().getTypeConverterRegistry().lookup(Source.class, content.getClass()) == null;
    }

    protected Source getSource(Exchange exchange, Object content) {
        TypeConverter tc;
        if (this.isUseDom()) {
            return exchange.getContext().getTypeConverter().tryConvertTo(DOMSource.class, exchange, content);
        }
        if (content instanceof Source) {
            return (Source)content;
        }
        Source source = null;
        if (content instanceof InputStream) {
            return new StreamSource((InputStream)content);
        }
        if (content != null && (tc = exchange.getContext().getTypeConverterRegistry().lookup(Source.class, content.getClass())) != null) {
            source = tc.convertTo(Source.class, exchange, content);
        }
        if (source == null) {
            source = exchange.getContext().getTypeConverter().tryConvertTo(SAXSource.class, exchange, content);
        }
        if (source == null) {
            source = exchange.getContext().getTypeConverter().tryConvertTo(StreamSource.class, exchange, content);
        }
        if (source == null) {
            source = exchange.getContext().getTypeConverter().tryConvertTo(DOMSource.class, exchange, content);
        }
        if (source == null) {
            if (this.isFailOnNullBody()) {
                throw new ExpectedBodyTypeException(exchange, Source.class);
            }
            try {
                source = this.converter.toDOMSource(this.converter.createDocument());
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeTransformException(e);
            }
        }
        return source;
    }
}

