/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.cluster;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.Experimental;
import org.apache.camel.Route;
import org.apache.camel.cluster.CamelClusterService;
import org.apache.camel.impl.DefaultRouteController;
import org.apache.camel.impl.cluster.ClusterServiceHelper;
import org.apache.camel.impl.cluster.ClusterServiceSelectors;
import org.apache.camel.impl.cluster.ClusteredRouteConfiguration;
import org.apache.camel.impl.cluster.ClusteredRouteFilter;
import org.apache.camel.impl.cluster.ClusteredRoutePolicy;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.spi.RoutePolicyFactory;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class ClusteredRouteController
extends DefaultRouteController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusteredRouteController.class);
    private final Set<String> routes = new CopyOnWriteArraySet<String>();
    private final ConcurrentMap<String, ClusteredRouteConfiguration> configurations = new ConcurrentHashMap<String, ClusteredRouteConfiguration>();
    private final List<ClusteredRouteFilter> filters = new ArrayList<ClusteredRouteFilter>();
    private final PolicyFactory policyFactory;
    private final ClusteredRouteConfiguration defaultConfiguration;
    private CamelClusterService clusterService;
    private CamelClusterService.Selector clusterServiceSelector = ClusterServiceSelectors.DEFAULT_SELECTOR;

    public ClusteredRouteController() {
        this.policyFactory = new PolicyFactory();
        this.defaultConfiguration = new ClusteredRouteConfiguration();
        this.defaultConfiguration.setInitialDelay(Duration.ofMillis(0L));
    }

    public void addFilter(ClusteredRouteFilter filter) {
        this.filters.add(filter);
    }

    public void setFilters(Collection<ClusteredRouteFilter> filters) {
        this.filters.clear();
        this.filters.addAll(filters);
    }

    public Collection<ClusteredRouteFilter> getFilters() {
        return Collections.unmodifiableList(this.filters);
    }

    public void addRouteConfiguration(String routeId, ClusteredRouteConfiguration configuration) {
        this.configurations.put(routeId, configuration);
    }

    public void setRoutesConfiguration(Map<String, ClusteredRouteConfiguration> configurations) {
        this.configurations.clear();
        this.configurations.putAll(configurations);
    }

    public Map<String, ClusteredRouteConfiguration> getRoutesConfiguration() {
        return Collections.unmodifiableMap(this.configurations);
    }

    public Duration getInitialDelay() {
        return this.defaultConfiguration.getInitialDelay();
    }

    public void setInitialDelay(Duration initialDelay) {
        this.defaultConfiguration.setInitialDelay(initialDelay);
    }

    public String getNamespace() {
        return this.defaultConfiguration.getNamespace();
    }

    public void setNamespace(String namespace) {
        this.defaultConfiguration.setNamespace(namespace);
    }

    public CamelClusterService getClusterService() {
        return this.clusterService;
    }

    public void setClusterService(CamelClusterService clusterService) {
        ObjectHelper.notNull(clusterService, "CamelClusterService");
        this.clusterService = clusterService;
    }

    public CamelClusterService.Selector getClusterServiceSelector() {
        return this.clusterServiceSelector;
    }

    public void setClusterServiceSelector(CamelClusterService.Selector clusterServiceSelector) {
        ObjectHelper.notNull(this.clusterService, "CamelClusterService.Selector");
        this.clusterServiceSelector = clusterServiceSelector;
    }

    @Override
    public Collection<Route> getControlledRoutes() {
        return this.routes.stream().map(this.getCamelContext()::getRoute).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public void doStart() throws Exception {
        CamelContext context = this.getCamelContext();
        ObjectHelper.notNull(this.defaultConfiguration.getNamespace(), "Namespace");
        ObjectHelper.notNull(this.defaultConfiguration.getInitialDelay(), "initialDelay");
        ObjectHelper.notNull(context, "camelContext");
        if (this.clusterService == null) {
            this.clusterService = ClusterServiceHelper.mandatoryLookupService(context, this.clusterServiceSelector);
        }
        LOGGER.debug("Using ClusterService instance {} (id={}, type={})", this.clusterService, this.clusterService.getId(), this.clusterService.getClass().getName());
        if (!ServiceHelper.isStarted(this.clusterService)) {
            this.clusterService.start();
        }
        super.doStart();
    }

    @Override
    public void doStop() throws Exception {
        if (ServiceHelper.isStarted(this.clusterService)) {
            this.clusterService.stop();
        }
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        if (!camelContext.getRoutePolicyFactories().contains(this.policyFactory)) {
            camelContext.addRoutePolicyFactory(this.policyFactory);
        }
        super.setCamelContext(camelContext);
    }

    @Override
    public void startRoute(String routeId) throws Exception {
        this.failIfClustered(routeId);
        super.startRoute(routeId);
    }

    @Override
    public void stopRoute(String routeId) throws Exception {
        this.failIfClustered(routeId);
        super.stopRoute(routeId);
    }

    @Override
    public void stopRoute(String routeId, long timeout, TimeUnit timeUnit) throws Exception {
        this.failIfClustered(routeId);
        super.stopRoute(routeId, timeout, timeUnit);
    }

    @Override
    public boolean stopRoute(String routeId, long timeout, TimeUnit timeUnit, boolean abortAfterTimeout) throws Exception {
        this.failIfClustered(routeId);
        return super.stopRoute(routeId, timeout, timeUnit, abortAfterTimeout);
    }

    @Override
    public void suspendRoute(String routeId) throws Exception {
        this.failIfClustered(routeId);
        super.suspendRoute(routeId);
    }

    @Override
    public void suspendRoute(String routeId, long timeout, TimeUnit timeUnit) throws Exception {
        this.failIfClustered(routeId);
        super.suspendRoute(routeId, timeout, timeUnit);
    }

    @Override
    public void resumeRoute(String routeId) throws Exception {
        this.failIfClustered(routeId);
        super.resumeRoute(routeId);
    }

    private void failIfClustered(String routeId) {
        if (this.routes.contains(routeId)) {
            throw new UnsupportedOperationException("Operation not supported as route " + routeId + " is clustered");
        }
    }

    private final class PolicyFactory
    implements RoutePolicyFactory {
        private PolicyFactory() {
        }

        @Override
        public RoutePolicy createRoutePolicy(CamelContext camelContext, String routeId, RouteDefinition route) {
            if (ClusteredRouteController.this.filters.stream().allMatch(filter -> filter.test(camelContext, routeId, route))) {
                if (ObjectHelper.isNotEmpty(route.getRoutePolicies())) {
                    if (route.getRoutePolicies().stream().anyMatch(ClusteredRoutePolicy.class::isInstance)) {
                        LOGGER.debug("Route '{}' has a ClusteredRoutePolicy already set-up", (Object)routeId);
                        return null;
                    }
                }
                try {
                    ClusteredRouteConfiguration configuration = ClusteredRouteController.this.configurations.getOrDefault(routeId, ClusteredRouteController.this.defaultConfiguration);
                    String namespace = ObjectHelper.supplyIfEmpty(configuration.getNamespace(), ClusteredRouteController.this.defaultConfiguration::getNamespace);
                    Duration initialDelay = ObjectHelper.supplyIfEmpty(configuration.getInitialDelay(), ClusteredRouteController.this.defaultConfiguration::getInitialDelay);
                    ClusteredRoutePolicy policy = ClusteredRoutePolicy.forNamespace(ClusteredRouteController.this.clusterService, namespace);
                    policy.setCamelContext(ClusteredRouteController.this.getCamelContext());
                    policy.setInitialDelay(initialDelay);
                    LOGGER.debug("Attaching route '{}' to namespace '{}'", (Object)routeId, (Object)namespace);
                    ClusteredRouteController.this.routes.add(routeId);
                    return policy;
                }
                catch (Exception e) {
                    throw ObjectHelper.wrapRuntimeCamelException(e);
                }
            }
            return null;
        }
    }
}

