/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.pool;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.jms.ConnectionFactory;
import javax.transaction.TransactionManager;
import org.apache.activemq.pool.JcaPooledConnectionFactory;
import org.apache.activemq.pool.PooledConnectionFactory;
import org.apache.activemq.pool.XaPooledConnectionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.ObjectPoolFactory;

public class PooledConnectionFactoryBean {
    private static final Log LOGGER = LogFactory.getLog(PooledConnectionFactoryBean.class);
    private PooledConnectionFactory pooledConnectionFactory;
    private ConnectionFactory connectionFactory;
    private int maxConnections = 1;
    private int maximumActive = 500;
    private Object transactionManager;
    private String resourceName;
    private ObjectPoolFactory poolFactory;

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public int getMaximumActive() {
        return this.maximumActive;
    }

    public void setMaximumActive(int maximumActive) {
        this.maximumActive = maximumActive;
    }

    public Object getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(Object transactionManager) {
        this.transactionManager = transactionManager;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public ObjectPoolFactory getPoolFactory() {
        return this.poolFactory;
    }

    public void setPoolFactory(ObjectPoolFactory poolFactory) {
        this.poolFactory = poolFactory;
    }

    @PostConstruct
    public void afterPropertiesSet() throws Exception {
        PooledConnectionFactory f;
        if (this.pooledConnectionFactory == null && this.transactionManager != null && this.resourceName != null) {
            try {
                LOGGER.debug((Object)"Trying to build a JcaPooledConnectionFactory");
                f = new JcaPooledConnectionFactory();
                ((JcaPooledConnectionFactory)f).setName(this.resourceName);
                ((XaPooledConnectionFactory)f).setTransactionManager((TransactionManager)this.transactionManager);
                f.setMaxConnections(this.maxConnections);
                f.setMaximumActive(this.maximumActive);
                f.setConnectionFactory(this.connectionFactory);
                f.setPoolFactory(this.poolFactory);
                this.pooledConnectionFactory = f;
            }
            catch (Throwable t) {
                LOGGER.debug((Object)("Could not create JCA enabled connection factory: " + t), t);
            }
        }
        if (this.pooledConnectionFactory == null && this.transactionManager != null) {
            try {
                LOGGER.debug((Object)"Trying to build a XaPooledConnectionFactory");
                f = new XaPooledConnectionFactory();
                ((XaPooledConnectionFactory)f).setTransactionManager((TransactionManager)this.transactionManager);
                f.setMaxConnections(this.maxConnections);
                f.setMaximumActive(this.maximumActive);
                f.setConnectionFactory(this.connectionFactory);
                f.setPoolFactory(this.poolFactory);
                this.pooledConnectionFactory = f;
            }
            catch (Throwable t) {
                LOGGER.debug((Object)("Could not create XA enabled connection factory: " + t), t);
            }
        }
        if (this.pooledConnectionFactory == null) {
            try {
                LOGGER.debug((Object)"Trying to build a PooledConnectionFactory");
                f = new PooledConnectionFactory();
                f.setMaxConnections(this.maxConnections);
                f.setMaximumActive(this.maximumActive);
                f.setConnectionFactory(this.connectionFactory);
                f.setPoolFactory(this.poolFactory);
                this.pooledConnectionFactory = f;
            }
            catch (Throwable t) {
                LOGGER.debug((Object)("Could not create pooled connection factory: " + t), t);
            }
        }
        if (this.pooledConnectionFactory == null) {
            throw new IllegalStateException("Unable to create pooled connection factory.  Enable DEBUG log level for more informations");
        }
    }

    @PreDestroy
    public void destroy() throws Exception {
        if (this.pooledConnectionFactory != null) {
            this.pooledConnectionFactory.stop();
            this.pooledConnectionFactory = null;
        }
    }
}

