/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.storagemodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jmi.reflect.ClosureViolationException;
import javax.jmi.reflect.CompositionCycleException;
import javax.jmi.reflect.JmiException;
import javax.jmi.reflect.RefFeatured;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.WrongSizeException;
import org.netbeans.mdr.handlers.AssociationHandler;
import org.netbeans.mdr.handlers.BaseObjectHandler;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.MultivaluedIndex;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.Streamable;
import org.netbeans.mdr.storagemodel.AttrCollection;
import org.netbeans.mdr.storagemodel.MdrStorage;
import org.netbeans.mdr.storagemodel.StorableAssociation;
import org.netbeans.mdr.storagemodel.StorableBaseObject;
import org.netbeans.mdr.storagemodel.StorableClass;
import org.netbeans.mdr.storagemodel.StorableFeatured;
import org.netbeans.mdr.util.DebugException;
import org.netbeans.mdr.util.IOUtils;
import org.netbeans.mdr.util.Logger;

public class StorableObject
extends StorableFeatured
implements Streamable {
    protected Object[] values;
    static final String INDEX_KEY_DELIMITER = "@";
    static final String INDEX_KEY_DELIMITER_2 = "#";
    static final String NULL_VALUE_SUBSTITUTE = "NULL";
    private MOFID classProxyId;
    private transient StorableClass classProxy = null;
    private MOFID attribComposite = null;
    static /* synthetic */ Class class$0;

    protected void replaceValues(Map table) {
        this.objectWillChange();
        super.replaceValues(table);
        this.objectChanged();
    }

    public StorableObject(MdrStorage mdrStorage, MOFID immediatePackage, MOFID meta, MOFID classProxy) throws StorageException {
        this(mdrStorage, immediatePackage, meta, classProxy, null, null);
    }

    public StorableObject(MdrStorage mdrStorage, MOFID immediatePackage, MOFID meta, MOFID classProxy, Object[] params) throws StorageException {
        this(mdrStorage, immediatePackage, meta, classProxy, params, null);
    }

    public StorableObject(MdrStorage mdrStorage, MOFID immediatePackage, MOFID meta, MOFID classProxy, Object[] params, String storageId) throws StorageException {
        super(mdrStorage, immediatePackage, meta, storageId);
        this.classProxyId = classProxy;
        this.classProxy = (StorableClass)mdrStorage.getObject(this.classProxyId);
        if (params != null) {
            this.check();
            int i = 0;
            while (i < params.length) {
                StorableClass.AttributeDescriptor desc = this.getClassProxy().getAttrDesc(i);
                this.values[i] = this.getInitialValue(desc, params[i]);
                ++i;
            }
        }
        this.addInstance();
        if (params != null) {
            this.modifyIndex(this.getClassProxy().getIndexDescriptors(), false);
        }
        this.initFinished = true;
    }

    public StorableObject(StorableObject storable) throws StorageException {
        super(storable.getMdrStorage(), storable.getImmediatePackageId(), storable.getMetaObjectId(), null);
        this.classProxyId = storable.getClassProxyId();
        this.classProxy = storable.getClassProxy();
        this.copyValues(storable);
        this.addInstance();
        this.modifyIndex(this.getClassProxy().getIndexDescriptors(), false);
        StorableFeatured composite = storable.getImmediateComposite();
        if (composite != null) {
            this.attribComposite = composite.getMofId();
        }
        this.initFinished = true;
    }

    public StorableObject() {
    }

    protected void copyValues(StorableObject storable) {
        if (storable.values == null) {
            return;
        }
        this.values = new Object[storable.values.length];
        int i = 0;
        while (i < this.values.length) {
            this.values[i] = storable.values[i];
            if (this.values[i] instanceof AttrCollection) {
                ((AttrCollection)this.values[i]).mdrObject = this;
            }
            ++i;
        }
    }

    public void setAttribute(String featureName, Object value) throws StorageException {
        this.setAttribute(this.getClassProxy().getAttrIndex(featureName), value);
    }

    public void setAttribute(int attrIndex, Object value) throws StorageException {
        Object oldValue = this.getAttribute(attrIndex);
        StorableClass.AttributeDescriptor attribute = this.getClassProxy().getAttrDesc(attrIndex);
        this.objectWillChange();
        this.values[attrIndex] = value;
        if (!attribute.isMultivalued() && value instanceof RefObject) {
            StorableObject storableObj = (StorableObject)((BaseObjectHandler)value)._getDelegate();
            storableObj.setComposite(this.getMofId(), storableObj.getMofId(), attribute.getMofId());
            if (oldValue != null) {
                storableObj = (StorableObject)((BaseObjectHandler)oldValue)._getDelegate();
                storableObj.clearComposite();
            }
        }
        this.modifyIndex(attrIndex, oldValue, value);
        this.objectChanged();
    }

    public Object getAttribute(String featureName) throws StorageException {
        return this.getAttribute(this.getClassProxy().getAttrIndex(featureName));
    }

    public Object getAttribute(int attrIndex) throws StorageException {
        this.check();
        Object result = this.values[attrIndex];
        if (result instanceof MOFID) {
            result = this.getMdrStorage().getRepository().getByMofId((MOFID)result);
        }
        return result;
    }

    public void verify(Collection violations) throws StorageException {
        Object desc;
        int count = this.getClassProxy().getAttrCount();
        int i = 0;
        while (i < count) {
            desc = this.getClassProxy().getAttrDesc(i);
            Object result = this.getAttribute(i);
            if (((StorableClass.AttributeDescriptor)desc).getMaxSize() == 1 && ((StorableClass.AttributeDescriptor)desc).getMinSize() == 1 && result == null || ((StorableClass.AttributeDescriptor)desc).getMaxSize() != 1 && ((Collection)result).size() < ((StorableClass.AttributeDescriptor)desc).getMinSize()) {
                violations.add(new WrongSizeException((RefObject)this.getMdrStorage().getRepository().getHandler(this.getMdrStorage().getObject(((StorableClass.AttributeDescriptor)desc).getMofId()))));
            }
            ++i;
        }
        Iterator it = this.getClassProxy().getAllReferenceDescriptors().iterator();
        while (it.hasNext()) {
            desc = (StorableClass.ReferenceDescriptor)it.next();
            ((StorableClass.ReferenceDescriptor)desc).getAssociation().verifyEnd(violations, ((StorableClass.ReferenceDescriptor)desc).getEndName(), this.getMofId());
        }
    }

    void addReference(String referenceName, MOFID referencedObjectId) throws StorageException {
        MOFID objA;
        MOFID objB;
        StorableClass.ReferenceDescriptor reference = this.getClassProxy().getReferenceDescriptor(referenceName);
        StorableAssociation assocObj = (StorableAssociation)this.getMdrStorage().getObject(reference.getAssociationId());
        if (reference.getEndName().equals(assocObj.getEnd1Name())) {
            objB = referencedObjectId;
            objA = this.getMofId();
        } else {
            objA = referencedObjectId;
            objB = this.getMofId();
        }
        assocObj.addLink(objA, objB);
    }

    public Object getReference(String referenceName) throws StorageException {
        StorableClass.ReferenceDescriptor reference = this.getClassProxy().getReferenceDescriptor(referenceName);
        StorableAssociation asocObj1 = (StorableAssociation)this.getMdrStorage().getObject(reference.getAssociationId());
        return asocObj1.queryObjects(reference.getEndName(), this.getMofId());
    }

    protected void check() throws StorageException {
        if (this.values == null) {
            this.values = new Object[this.getClassProxy().getAttrCount()];
        }
    }

    public MOFID getImmediateCompositeId() {
        return this.attribComposite;
    }

    public StorableFeatured getImmediateComposite() throws StorageException {
        if (this.attribComposite != null) {
            StorableFeatured sf = (StorableFeatured)this.getMdrStorage().getObject(this.attribComposite);
            return sf;
        }
        return null;
    }

    public StorableFeatured getOutermostComposite() throws StorageException {
        StorableFeatured result = this.getImmediateComposite();
        StorableFeatured composite = this;
        while (result != null) {
            composite = result;
            result = result instanceof StorableObject ? ((StorableObject)result).getImmediateComposite() : null;
        }
        return composite;
    }

    public void clearComposite() throws StorageException {
        this.setComposite((MOFID)null, (MOFID)null, (MOFID)null);
    }

    public void setComposite(MOFID composite, MOFID objectId, MOFID elementId) throws StorageException {
        this.setComposite(this.getMdrStorage().getObject(composite), objectId, elementId);
    }

    public void setComposite(StorableBaseObject composite, MOFID objectId, MOFID elementId) throws StorageException {
        this.objectWillChange();
        if (composite == null) {
            this.attribComposite = null;
        } else {
            MOFID id = composite.getMofId();
            if (!id.equals(this.attribComposite)) {
                if (composite instanceof StorableObject && ((StorableObject)composite).getOutermostComposite().equals(this)) {
                    throw new CompositionCycleException((Object)this.getMdrStorage().getRepository().getHandler(this.getMdrStorage().getObject(objectId)), (RefObject)this.getMdrStorage().getRepository().getHandler(this.getMdrStorage().getObject(elementId)));
                }
                if (!composite.getOutermostPackageId().equals(this.getOutermostPackageId())) {
                    throw new ClosureViolationException((Object)this.getMdrStorage().getRepository().getHandler(this.getMdrStorage().getObject(objectId)), (RefObject)this.getMdrStorage().getRepository().getHandler(this.getMdrStorage().getObject(elementId)));
                }
                this.attribComposite = id;
            }
        }
        this.objectChanged();
    }

    public void deleteInstance() throws StorageException {
        this.modifyIndex(this.getClassProxy().getIndexDescriptors(), true);
        this.getMdrStorage().removeInstance(this);
    }

    public void delete() throws StorageException {
        this.deleteAttributes();
        this.deleteLinksAndComponents();
        this.deleteFromComposite();
        this.deleteInstance();
    }

    protected void deleteFromComposite() throws StorageException {
        StorableFeatured composite = this.getImmediateComposite();
        if (composite != null) {
            StorableClass cls = composite.getClassProxy();
            int i = 0;
            while (i < cls.getAttrCount()) {
                StorableClass.AttributeDescriptor desc = cls.getAttrDesc(i);
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("javax.jmi.reflect.RefObject");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.isAssignableFrom(desc.getType())) {
                    RefFeatured obj = (RefFeatured)this.getMdrStorage().getRepository().getHandler(composite);
                    Object value = obj.refGetValue(desc.getName());
                    if (this.equals(value)) {
                        obj.refSetValue(desc.getName(), null);
                    } else if (value instanceof Collection && ((Collection)value).contains(this)) {
                        ((Collection)value).remove(this);
                    }
                }
                ++i;
            }
        }
    }

    protected void deleteLinksAndComponents() throws StorageException {
        RefObject thisObject = (RefObject)this.getMdrStorage().getRepository().getHandler(this);
        ArrayList associationEnds = new ArrayList();
        this.getClassProxy().collectAssociationEnds(associationEnds, new HashSet());
        Iterator it = associationEnds.iterator();
        while (it.hasNext()) {
            Object temp;
            StorableClass.AssocEndDescriptor item = (StorableClass.AssocEndDescriptor)it.next();
            StorableAssociation assocStorable = (StorableAssociation)this.getMdrStorage().getObject(item.mofId);
            if (assocStorable == null) continue;
            AssociationHandler assoc = (AssociationHandler)this.getMdrStorage().getRepository().getHandler(assocStorable);
            try {
                temp = assoc._query(item.endName, thisObject);
            }
            catch (ClassCastException e) {
                temp = null;
            }
            catch (JmiException e) {
                temp = assoc._handleQuery(item.endName, thisObject);
            }
            if (temp == null) continue;
            if (temp instanceof Collection) {
                Iterator itt = ((Collection)temp).iterator();
                while (itt.hasNext()) {
                    RefObject obj = (RefObject)itt.next();
                    itt.remove();
                    if (!item.isAggregate) continue;
                    obj.refDelete();
                }
                continue;
            }
            if (item.endName.equals(assocStorable.getEnd2Name())) {
                assoc.refRemoveLink((RefObject)temp, thisObject);
                continue;
            }
            assoc.refRemoveLink(thisObject, (RefObject)temp);
            if (!item.isAggregate) continue;
            ((RefObject)temp).refDelete();
        }
    }

    public MOFID getClassProxyId() {
        return this.classProxyId;
    }

    public StorableClass getClassProxy() throws StorageException {
        return this.classProxy;
    }

    public void write(OutputStream outputStream) {
        super.write(outputStream);
        try {
            IOUtils.write(outputStream, this.classProxyId, this);
            IOUtils.write(outputStream, this.attribComposite, this);
            if (this.values == null) {
                IOUtils.writeInt(outputStream, 0);
            } else {
                IOUtils.writeInt(outputStream, this.values.length + 1);
                int i = 0;
                while (i < this.values.length) {
                    IOUtils.write(outputStream, this.values[i], this);
                    ++i;
                }
            }
        }
        catch (IOException e) {
            Logger.getDefault().notify(1, (Throwable)e);
        }
    }

    public void read(InputStream inputStream) {
        super.read(inputStream);
        try {
            this.classProxyId = (MOFID)IOUtils.read(inputStream, this);
            this.attribComposite = (MOFID)IOUtils.read(inputStream, this);
        }
        catch (IOException e) {
            throw (RuntimeException)Logger.getDefault().annotate((Throwable)new RuntimeException(e.getMessage()), (Throwable)e);
        }
        try {
            this.classProxy = (StorableClass)this.getMdrStorage().getObject(this.classProxyId);
            this.meta = this.classProxy.getMetaObjectId();
            this.immediatePackage = this.classProxy.getImmediatePackageId();
        }
        catch (StorageException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
        try {
            int objCount = IOUtils.readInt(inputStream);
            if (objCount != 0) {
                int count = objCount - 1;
                this.values = new Object[count];
                int i = 0;
                while (i < count) {
                    this.values[i] = IOUtils.read(inputStream, this, this.getClassProxy().getAttrDesc(i).getType().getName());
                    ++i;
                }
            }
        }
        catch (Exception e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
    }

    protected void addInstance() throws StorageException {
        this.getMdrStorage().addInstance(this);
    }

    /*
     * Exception decompiling
     */
    protected void modifyIndex(int attrIdx, Object oldValue, Object newValue) throws StorageException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [4 : 439->442)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void deleteAttributes() throws StorageException {
        int i = 0;
        while (i < this.values.length) {
            Object value = this.getAttribute(i);
            if (value instanceof RefObject) {
                RefObject obj = (RefObject)value;
                this.setAttribute(i, null);
                obj.refDelete();
            } else if (value instanceof Collection) {
                Iterator it = ((Collection)value).iterator();
                while (it.hasNext()) {
                    Object obj = it.next();
                    if (!(obj instanceof RefObject)) break;
                    it.remove();
                    ((RefObject)obj).refDelete();
                }
            }
            ++i;
        }
    }

    void addToIndex(MOFID id) {
        try {
            StorableClass proxy = this.getClassProxy();
            this.modifyIndex(proxy.getIndexes(id), false);
        }
        catch (StorageException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
    }

    void removeFromIndex(MOFID id) {
        try {
            StorableClass proxy = this.getClassProxy();
            this.modifyIndex(proxy.getIndexes(id), true);
        }
        catch (StorageException e) {
            throw (DebugException)Logger.getDefault().annotate((Throwable)new DebugException(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void modifyIndex(List descriptors, boolean remove) throws StorageException {
        if (descriptors == null) {
            return;
        }
        MultivaluedIndex attrIndex = null;
        MOFID outermostPackageId = this.getOutermostPackageId();
        MOFID mofId = this.getMofId();
        Iterator iter = descriptors.iterator();
        while (iter.hasNext()) {
            Object var9_9;
            StorableClass.IndexDescriptor desc = (StorableClass.IndexDescriptor)iter.next();
            StorableClass.IndexDescriptor.Field[] fields = desc.getFields();
            try {
                attrIndex = this.getMdrStorage().acquireAdditionalIndex(outermostPackageId, desc.getName());
                if (remove) {
                    attrIndex.remove(this.valuesToKey(fields, 0, fields.length - 1), mofId);
                } else {
                    attrIndex.add(this.valuesToKey(fields, 0, fields.length - 1), mofId);
                }
            }
            catch (Throwable throwable) {
                var9_9 = null;
                if (attrIndex != null) {
                    this.getMdrStorage().releaseAdditionalIndex();
                }
                throw throwable;
            }
            {
                var9_9 = null;
                if (attrIndex == null) continue;
                this.getMdrStorage().releaseAdditionalIndex();
                continue;
            }
            break;
        }
        return;
    }

    private static String objectToString(Object o, boolean isOrdered) {
        if (o == null) {
            return NULL_VALUE_SUBSTITUTE;
        }
        if (o instanceof RefObject) {
            return ((RefObject)o).refMofId();
        }
        if (o instanceof StorableObject) {
            return ((StorableObject)o).getMofId().toString();
        }
        if (o instanceof Collection) {
            StringBuffer buf = new StringBuffer();
            Iterator iter = ((Collection)o).iterator();
            LinkedList<String> list = new LinkedList<String>();
            while (iter.hasNext()) {
                list.add(StorableObject.objectToString(iter.next(), true));
            }
            if (!isOrdered) {
                Collections.sort(list);
            }
            if ((iter = list.iterator()).hasNext()) {
                buf.append(iter.next());
            }
            while (iter.hasNext()) {
                buf.append(INDEX_KEY_DELIMITER);
                buf.append(iter.next());
            }
            return buf.toString();
        }
        return o.toString();
    }

    private String valuesToKey(StorableClass.IndexDescriptor.Field[] fields, int pos_1, int pos_2) throws StorageException {
        StringBuffer buf = new StringBuffer();
        int x = pos_1;
        while (x <= pos_2) {
            String res;
            if (fields[x] instanceof StorableClass.IndexDescriptor.Attrib) {
                String name = fields[x].getName();
                res = StorableObject.objectToString(this.values[this.getClassProxy().getAttrIndex(name)], fields[x].isOrdered());
            } else {
                StorableClass.IndexDescriptor.AssocEnd endDesc = (StorableClass.IndexDescriptor.AssocEnd)fields[x];
                StorableAssociation sa = (StorableAssociation)this.getMdrStorage().getObject(endDesc.getAssociation());
                String otherEndName = sa.getEnd1Name();
                if (otherEndName.equals(endDesc.getName())) {
                    otherEndName = sa.getEnd2Name();
                }
                res = StorableObject.objectToString(sa.queryObjects(otherEndName, this.getMofId()), fields[x].isOrdered());
            }
            buf.append(res);
            if (x < pos_2) {
                buf.append(INDEX_KEY_DELIMITER_2);
            }
            ++x;
        }
        return buf.toString();
    }

    public static String valuesToKey(Map map, StorableClass.IndexDescriptor.Field[] fields) {
        StringBuffer buf = new StringBuffer();
        if (map.size() != fields.length) {
            throw new DebugException("Wrong query on additional index, incorrect number of passed parameters.");
        }
        int x = 0;
        while (x < fields.length) {
            String name = fields[x].getName();
            if (!map.containsKey(name)) {
                throw new DebugException("Wrong query on additional index, value of field " + name + " not specified.");
            }
            Object value = map.get(name);
            String str = StorableObject.objectToString(value, fields[x].isOrdered());
            buf.append(str);
            if (x < fields.length - 1) {
                buf.append(INDEX_KEY_DELIMITER_2);
            }
            ++x;
        }
        return buf.toString();
    }

    public static String valueToKey(Object value, StorableClass.IndexDescriptor.Field[] fields) {
        if (fields.length != 1) {
            throw new DebugException("Wrong query on additional index, more than one parameter expected.");
        }
        return StorableObject.objectToString(value, fields[0].isOrdered());
    }

    public byte[] getClassFile() {
        return (byte[])this.getSlot1();
    }

    public void setClassFile(byte[] bytecode) {
        this.setSlot1(bytecode);
    }

    public byte[] getInstanceClassFile() {
        return (byte[])this.getSlot2();
    }

    public void setInstanceClassFile(byte[] bytecode) {
        this.setSlot2(bytecode);
    }
}

