/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.metafacades.uml14;

import java.util.Collection;
import org.andromda.metafacades.uml.ClassifierFacade;
import org.andromda.metafacades.uml.EnumerationFacade;
import org.andromda.metafacades.uml.NameMasker;
import org.andromda.metafacades.uml.TypeMappings;
import org.andromda.metafacades.uml.UMLMetafacadeUtils;
import org.andromda.metafacades.uml.UMLProfile;
import org.andromda.metafacades.uml14.AttributeFacadeLogic;
import org.andromda.utils.StringUtilsHelper;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.omg.uml.foundation.core.Attribute;
import org.omg.uml.foundation.core.Classifier;
import org.omg.uml.foundation.datatypes.ChangeableKindEnum;
import org.omg.uml.foundation.datatypes.Multiplicity;
import org.omg.uml.foundation.datatypes.MultiplicityRange;
import org.omg.uml.foundation.datatypes.OrderingKind;
import org.omg.uml.foundation.datatypes.OrderingKindEnum;
import org.omg.uml.foundation.datatypes.ScopeKindEnum;

public class AttributeFacadeLogicImpl
extends AttributeFacadeLogic {
    private static final long serialVersionUID = 34L;

    public AttributeFacadeLogicImpl(Attribute metaObject, String context) {
        super(metaObject, context);
    }

    public ClassifierFacade getValidationOwner() {
        return this.getOwner();
    }

    @Override
    public String handleGetGetterName() {
        return UMLMetafacadeUtils.getGetterPrefix((ClassifierFacade)this.getType()) + StringUtilsHelper.capitalize((String)this.getName());
    }

    @Override
    public String handleGetSetterName() {
        return "set" + StringUtils.capitalize((String)this.getName());
    }

    @Override
    public String handleGetDefaultValue() {
        String defaultValue = null;
        if (this.metaObject.getInitialValue() != null) {
            defaultValue = this.metaObject.getInitialValue().getBody();
        }
        if (StringUtils.isNotBlank(defaultValue) && !this.isMany() && this.metaObject.getType() != null) {
            String typeName = this.metaObject.getType().getName();
            if ("String".equals(typeName) && defaultValue.indexOf(34) < 0) {
                defaultValue = '\"' + defaultValue + '\"';
            } else if (("char".equals(typeName) || "Character".equals(typeName)) && defaultValue.indexOf(39) < 0) {
                defaultValue = "'" + defaultValue.charAt(0) + '\'';
            }
        }
        if (defaultValue == null) {
            defaultValue = "";
        }
        return defaultValue;
    }

    @Override
    public boolean handleIsChangeable() {
        return ChangeableKindEnum.CK_CHANGEABLE.equals((Object)this.metaObject.getChangeability());
    }

    @Override
    public boolean handleIsAddOnly() {
        return ChangeableKindEnum.CK_ADD_ONLY.equals((Object)this.metaObject.getChangeability());
    }

    protected Classifier handleGetType() {
        return this.metaObject.getType();
    }

    public Classifier handleGetOwner() {
        return this.metaObject.getOwner();
    }

    @Override
    public boolean handleIsReadOnly() {
        return ChangeableKindEnum.CK_FROZEN.equals((Object)this.metaObject.getChangeability());
    }

    @Override
    public boolean handleIsStatic() {
        return ScopeKindEnum.SK_CLASSIFIER.equals((Object)this.metaObject.getOwnerScope());
    }

    @Override
    public Object handleFindTaggedValue(String name, boolean follow) {
        name = StringUtils.trimToEmpty((String)name);
        Object value = this.findTaggedValue(name);
        if (follow) {
            for (ClassifierFacade type = this.getType(); value == null && type != null; type = (ClassifierFacade)type.getGeneralization()) {
                value = type.findTaggedValue(name);
            }
        }
        return value;
    }

    @Override
    public boolean handleIsRequired() {
        int lower = this.getMultiplicityRangeLower();
        return lower >= 1;
    }

    @Override
    public boolean handleIsMany() {
        Collection ranges;
        boolean isMany = false;
        Multiplicity multiplicity = this.metaObject.getMultiplicity();
        if (multiplicity != null && (ranges = multiplicity.getRange()) != null && !ranges.isEmpty()) {
            for (MultiplicityRange multiplicityRange : ranges) {
                int upper = multiplicityRange.getUpper();
                isMany = upper > 1 || upper < 0;
            }
        }
        return isMany;
    }

    private int getMultiplicityRangeLower() {
        Collection ranges;
        Integer lower = null;
        Multiplicity multiplicity = this.metaObject.getMultiplicity();
        if (multiplicity != null && (ranges = multiplicity.getRange()) != null && !ranges.isEmpty()) {
            for (MultiplicityRange multiplicityRange : ranges) {
                lower = multiplicityRange.getLower();
            }
        }
        if (lower == null) {
            String defaultMultiplicity;
            lower = this.getType().isPrimitive() ? Integer.valueOf(1) : (this.getType().isWrappedPrimitive() ? Integer.valueOf(0) : ((defaultMultiplicity = this.getDefaultMultiplicity()).startsWith("0") ? Integer.valueOf(0) : Integer.valueOf(1)));
        }
        return lower;
    }

    private int getMultiplicityRangeUpper() {
        Collection ranges;
        Integer upper = null;
        Multiplicity multiplicity = this.metaObject.getMultiplicity();
        if (multiplicity != null && (ranges = multiplicity.getRange()) != null && !ranges.isEmpty()) {
            for (MultiplicityRange multiplicityRange : ranges) {
                upper = multiplicityRange.getUpper();
            }
        }
        if (upper == null) {
            upper = 1;
        }
        return upper;
    }

    private String getDefaultMultiplicity() {
        return ObjectUtils.toString((Object)this.getConfiguredProperty("defaultMultiplicity"));
    }

    protected EnumerationFacade handleGetEnumeration() {
        return (EnumerationFacade)(this.isEnumerationLiteral() ? this.getOwner() : null);
    }

    @Override
    protected boolean handleIsEnumerationLiteral() {
        ClassifierFacade owner = this.getOwner();
        return owner != null && owner.isEnumeration();
    }

    @Override
    protected String handleGetEnumerationValue() {
        String value = null;
        if (this.isEnumerationLiteral()) {
            value = this.getDefaultValue();
            String string = value = StringUtils.isEmpty((String)value) ? this.getName() : String.valueOf(value);
        }
        if (this.getType().isStringType() && value != null && value.indexOf(34) < 0) {
            value = '\"' + value + '\"';
        }
        return value;
    }

    @Override
    protected boolean handleIsEnumerationMember() {
        boolean isMemberVariable = false;
        String isMemberVariableAsString = (String)this.findTaggedValue(UMLProfile.TAGGEDVALUE_PERSISTENCE_ENUMERATION_MEMBER_VARIABLE);
        if (StringUtils.isNotBlank((String)isMemberVariableAsString) && BooleanUtils.toBoolean((String)isMemberVariableAsString)) {
            isMemberVariable = true;
        }
        return isMemberVariable;
    }

    @Override
    protected String handleGetEnumerationLiteralParameters() {
        return (String)this.findTaggedValue(UMLProfile.TAGGEDVALUE_PERSISTENCE_ENUMERATION_LITERAL_PARAMETERS);
    }

    @Override
    protected boolean handleIsEnumerationLiteralParametersExist() {
        boolean parametersExist = false;
        if (StringUtils.isNotBlank((String)this.getEnumerationLiteralParameters())) {
            parametersExist = true;
        }
        return parametersExist;
    }

    @Override
    public boolean handleIsDefaultValuePresent() {
        return StringUtils.isNotBlank((String)this.getDefaultValue());
    }

    @Override
    protected String handleGetName() {
        String name = null;
        if (this.isEnumerationMember()) {
            name = super.handleGetName();
        } else {
            String mask = String.valueOf(this.getConfiguredProperty(this.getOwner() instanceof EnumerationFacade ? "enumerationLiteralNameMask" : "classifierPropertyNameMask"));
            name = NameMasker.mask((String)super.handleGetName(), (String)mask);
            boolean templating = Boolean.parseBoolean(String.valueOf(this.getConfiguredProperty("enableTemplating")));
            if (this.getType() != null) {
                boolean arrayType = this.getType().isArrayType();
                if (this.isPluralizeAttributeNames() && (this.isMany() && templating || arrayType)) {
                    name = StringUtilsHelper.pluralize((String)name);
                }
            }
        }
        return name;
    }

    private boolean isPluralizeAttributeNames() {
        Object value = this.getConfiguredProperty("pluralizeAttributeNames");
        return value != null && Boolean.valueOf(String.valueOf(value)) != false;
    }

    @Override
    public boolean handleIsLeaf() {
        return false;
    }

    @Override
    public boolean handleIsOrdered() {
        boolean ordered = false;
        OrderingKind ordering = this.metaObject.getOrdering();
        if (ordering != null) {
            ordered = ordering.equals(OrderingKindEnum.OK_ORDERED);
        }
        return ordered;
    }

    @Override
    protected boolean handleIsUnique() {
        return this.hasStereotype(UMLProfile.STEREOTYPE_UNIQUE);
    }

    @Override
    public String handleGetGetterSetterTypeName() {
        String name = null;
        if (this.isMany()) {
            TypeMappings mappings = this.getLanguageMappings();
            if (this.hasStereotype(UMLProfile.STEREOTYPE_UNIQUE)) {
                name = this.isOrdered() ? mappings.getTo(UMLProfile.ORDERED_SET_TYPE_NAME) : mappings.getTo(UMLProfile.SET_TYPE_NAME);
            } else {
                String string = name = this.isOrdered() ? mappings.getTo(UMLProfile.LIST_TYPE_NAME) : mappings.getTo(UMLProfile.COLLECTION_TYPE_NAME);
            }
            if (BooleanUtils.toBoolean((String)ObjectUtils.toString((Object)this.getConfiguredProperty("enableTemplating")))) {
                name = name + '<' + this.getType().getFullyQualifiedName() + ">";
            }
        }
        if (name == null && this.getType() != null) {
            name = this.getType().getFullyQualifiedName();
        }
        return name;
    }

    @Override
    protected int handleGetUpper() {
        return this.getMultiplicityRangeUpper();
    }

    @Override
    protected int handleGetLower() {
        return this.getMultiplicityRangeLower();
    }

    @Override
    protected boolean handleIsDerived() {
        return false;
    }
}

